<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $breadcumb ?><small> <?php echo $breadcumb ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $breadcumb ?>                   
                </li>             
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-globe"></i>Columns Reorder
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-toolbar">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="btn-group">
                                        <a href="<?= site_url($this->config->item('backend_url') . '/blog/add') ?>" class="btn green" id="sample_editable_1_new">
                                            Add New <i class="fa fa-plus"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <table class="table table-striped table-bordered table-hover" id="sample_6">
                            <thead>
                                <tr>
                                    <th>Blog Title</th>                                
                                    <th>Blog Category</th>                                  
                                    <th>Blog Image</th>        
                                    <th>Status</th>
                                    <th>Action</th>   
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($blog_data as $blog) {
                                    $blog_cat = $this->common_model->get_single_field_from_any_table('blog_cat_name', 'blog_cat_id', $blog['blog_cat_fk'], 'tbl_blog_category');
                                    ?>
                                    <tr class="odd gradeX">                                       
                                        <td><?php echo (isset($blog['blog_name'])) ? $blog['blog_name'] : '-'; ?></td> 
                                        <td><?php echo (isset($blog_cat)) ? $blog_cat : '-'; ?></td>                                
                                        <td><img src="<?= base_url() ?>assets/uploads/blog_images/<?php echo (isset($blog['blog_image'])) ? $blog['blog_image'] : '-'; ?>" width="50px" height="50px"></td>
                                        <td>
                                            <?php if ($blog['blog_status'] == 'active') { ?>
                                                <span class="label label-sm label-success">Active</span> 
                                            <?php } else if ($blog['blog_status'] == 'inactive') { ?>
                                                <span class="label label-sm label-warning">Inactive</span> 
                                            <?php } else if ($blog['blog_status'] == 'deleted') { ?>
                                                <span class="label label-sm label-danger">Deleted</span>
                                            <?php } ?>
                                        </td>                                                                          
                                        <td>
                                                <div class="actions">
                                                    <div class="btn-group">
                                                        <a class="btn default yellow-stripe" href="javascript:;" data-toggle="dropdown">
                                                            <i class="fa fa-share"></i>
                                                            <span class="hidden-480">
                                                                Action </span>
                                                            <i class="fa fa-angle-down"></i>
                                                        </a>
                                                        <ul class="dropdown-menu pull-right">
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/blog/edit/' . $blog['blog_id']) ?>">
                                                                    Edit </a>
                                                            </li>
                                                            
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/blog/comment/' . $blog['blog_id']) ?>">
                                                                    Blog Comments </a>
                                                            </li>
                                                            <?php if ($blog['blog_status'] == 'active') { ?>
                                                                <li>
                                                                    <a href="<?= site_url() . $this->config->item('backend_url') . '/blog/status/' . $blog['blog_id'] . '/inactive' ?>">
                                                                        Inactive </a>
                                                                </li>
                                                            <?php } else if ($blog['blog_status'] == 'inactive') { ?>
                                                                <li>
                                                                    <a href="<?= site_url() . $this->config->item('backend_url') . '/blog/status/' . $blog['blog_id'] . '/active' ?>">
                                                                        Active </a>
                                                                </li>
                                                            <?php } ?>

                                                            <li>
                                                                <a href="<?= site_url() . $this->config->item('backend_url') . '/blog/status/' . $blog['blog_id'] . '/deleted' ?>">
                                                                    Delete </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div> 
                                        </td>                                                             
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>