<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $page_heading ?><small ><?php echo $page_heading ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $page_heading ?>                  
                </li>               
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject font-green-sharp bold uppercase"><a href="<?= site_url($this->config->item('backend_url') . '/meta-tag') ?>">Back</a></span>
                        </div>                         
                    </div>
                    <div class="portlet-body form">
                        <form class="form-horizontal" role="form" method="post" enctype="multipart/form-data">
                            <div class="form-body">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Meta Tag Url</label>
                                    <div class="col-md-9">
                                        <input type="text" name="meta_tag_url" value="<?= $meta_tag_url ?>" class="form-control" placeholder="Enter Meta Tag URL">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('meta_tag_url')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Meta Tag Title</label>
                                    <div class="col-md-9">
                                        <input type="text" name="meta_tag_title" value="<?= $meta_tag_title ?>" class="form-control" placeholder="Enter Meta Tag Title">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('meta_tag_title')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Meta Tag Keywords</label>
                                    <div class="col-md-9">
                                        <input type="text" name="meta_tag_keywords" value="<?= $meta_tag_keywords ?>" class="form-control" placeholder="Enter Meta Tag Keywords">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('meta_tag_keywords')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Meta Tag Description</label>
                                    <div class="col-md-9">
                                        <input type="text" name="meta_tag_description" value="<?= $meta_tag_description ?>" class="form-control" placeholder="Enter Meta Tag Description">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('meta_tag_description')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputFile" class="col-md-3 control-label">Meta Tag Image</label>
                                    <div class="col-md-9">
                                        <input type="file" onChange="readURL(this);" id="meta_tag_image" name="meta_tag_image" value="<?= $meta_tag_image ?>"><br>
                                        <?php if (isset($meta_tag_image) && $meta_tag_image != '') { ?>
                                            <img id="meta_tag_image_preview" src="<?= $this->config->item('uploads'); ?>header_images/<?= $meta_tag_image ?>" width="50px" height="50px">
                                        <?php } else { ?>
                                            <img id="meta_tag_image_preview" src="<?= $this->config->item('backend_assets'); ?>layout/img/upload_image.png" width="50px" height="50px">
                                        <?php } ?>                            
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('meta_tag_image')) ?></p>

                                    </div>
                                </div>
                            </div>
                            <div class="form-actions">
                                <div class="row">
                                    <div class="col-md-offset-3 col-md-9">
                                        <button type="submit" class="btn green">Submit</button>
                                        <button type="reset" class="btn default">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            //alert(input.id);
            reader.onload = function (e) {
                $('#' + input.id + '_preview').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>