<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $page_heading; ?><small> <?php echo $page_heading; ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $page_heading; ?>                   
                </li>             
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-globe"></i><?php echo $page_heading; ?>        
                        </div>

                    </div>
                    <div class="portlet-body">
                        <div class="table-toolbar">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="btn-group">
                                        <a href="<?= site_url($this->config->item('backend_url') . '/package/add') ?>" class="btn green" id="sample_editable_1_new">
                                            Add New <i class="fa fa-plus"></i>
                                        </a>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <table class="table table-striped table-bordered table-hover" id="sample_6">
                            <thead>
                                <tr>
                                    <th>Package Name</th>                                  
                                    <th>Package Price</th>                                
                                    <th>Package Min People</th>       
                                    <th>Status</th>
                                    <th>Action</th>   
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($packages_data as $package) { ?>
                                    <tr class="odd gradeX">                                       
                                        <td><?php echo (isset($package['package_name'])) ? $package['package_name'] : '-'; ?></td> 
                                        <td><?php echo (isset($package['package_price'])) ? $package['package_price'] : '-'; ?></td> 
                                        <td><?php echo (isset($package['package_min_people'])) ? $package['package_min_people'] : '-'; ?></td>
                                        <td>
                                            <?php if ($package['package_status'] == 'active') { ?>
                                                <span class="label label-sm label-success">Active</span> 
                                            <?php } else if ($package['package_status'] == 'inactive') { ?>
                                                <span class="label label-sm label-warning">Inactive</span> 
                                            <?php } ?>
                                        </td>                                                                          
                                        <td>
                                            <div class="col-md-6">
                                                <div class="btn-group">
                                                    <button class="btn btn-success dropdown-toggle" data-toggle="dropdown">Action <i class="fa fa-angle-down"></i></button>
                                                    <ul class="dropdown-menu pull-right">
                                                        <li>
                                                            <a href="<?= site_url($this->config->item('backend_url') . '/package/edit/' . $package['package_id']) ?>">Edit </a>
                                                        </li>
                                                        <?php if ($package['package_status'] == 'active') { ?>
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/inactivate-package/' . $package['package_id']) ?>">Inactivate</a>
                                                            </li>
                                                        <?php } else if ($package['package_status'] == 'inactive') { ?>
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/activate-package/' . $package['package_id']) ?>">Activate </a>
                                                            </li>
                                                        <?php } ?>
                                                        <li>
                                                            <a href="<?= site_url($this->config->item('backend_url') . '/delete-package/' . $package['package_id']) ?>">Delete </a>
                                                        </li>
                                                        <li>
                                                            <a href="<?= site_url($this->config->item('backend_url') . '/package/package-attributes/' . $package['package_id']) ?>">Manage Attributes</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>   
                                        </td>                                                             
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
