<script type="text/javascript" src="<?php echo $this->config->item('ckeditor_basepath'); ?>ckeditor.js"></script>
<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $breadcumb ?><small ><?php echo $breadcumb ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . '/dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $breadcumb ?>                  
                </li>               
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject font-green-sharp bold uppercase"><a href="<?= site_url($this->config->item('backend_url') . '/product/' . $cat_type_id) ?>">Back</a></span>
                        </div>                         
                    </div>
                    <div class="portlet-body form">
                        <form class="form-horizontal" role="form" method="post" enctype="multipart/form-data">
                            <div class="form-body">

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Product Category</label>
                                    <div class="col-md-9">
                                        <select name="prd_cat_fk" class="form-control">
                                            <option value="">Select Product Category</option>
                                            <?php foreach ($product_cat_list as $product_cat) { ?>
                                                <option value="<?= $product_cat['cat_id'] ?>"<?php if ($product_cat['cat_id'] == $prd_cat_fk) { ?> selected="selected" <?php } ?>><?= $product_cat['cat_name'] ?></option>  
                                            <?php } ?>                                     
                                        </select>
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('prd_cat_fk')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Product Name</label>
                                    <div class="col-md-9">
                                        <input type="text" name="prd_name" value="<?= $prd_name ?>" class="form-control" placeholder="Enter Product Name">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('prd_name')) ?></p>
                                    </div>
                                </div>
                                <?php if($cat_type_id==2 || $cat_type_id==3 || $cat_type_id==4) { 
                                    $prd_label_fk=  explode(',', $prd_label_fk);
                                   ?>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Product Label</label>
                                    <div class="col-md-9">
                                        <select class='form-control' name='prd_label_fk[]' multiple>
                                            <option value=''>Select Product Label</option>
                                            <?php foreach($product_labels as $product_label) { ?>
                                            <option value='<?= $product_label['prd_label_id'] ?>' <?= in_array($product_label['prd_label_id'], $prd_label_fk)?'selected':'' ?>><?= $product_label['prd_label_name'] ?></option>
                                            <?php } ?>
                                        </select>
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('prd_label_fk')) ?></p>
                                    </div>
                                </div>
                                <?php } ?>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Product Content</label>
                                    <div class="col-md-9">
                                        <textarea class="form-control ckeditor" name="prd_content" rows="3"><?= $prd_content ?></textarea>
                                    </div>
                                </div> 
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Product Price</label>
                                    <div class="col-md-9">
                                        <input type="text" name="prd_price" value="<?= $prd_price ?>" class="form-control" placeholder="Enter Product Price">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('prd_price')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Product Sku</label>
                                    <div class="col-md-9">
                                        <input type="text" name="prd_sku" value="<?= $prd_sku ?>" class="form-control" placeholder="Enter Product Sku">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('prd_sku')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputFile" class="col-md-3 control-label">Product Image</label>
                                    <div class="col-md-9">
                                        <input type="file" onChange="readURL(this);" id="prd_image" name="prd_image" value="<?= $prd_image ?>"><br>
                                        <?php if (isset($prd_image) && $prd_image != '') { ?>
                                            <img id="prd_image_preview" src="<?= $this->config->item('uploads'); ?>product_images/<?= $prd_image ?>" width="50px" height="50px">
                                        <?php } else { ?>
                                            <img id="prd_image_preview" src="<?= $this->config->item('backend_assets'); ?>layout/img/upload_image.png" width="50px" height="50px">
                                        <?php } ?>                            
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('prd_image')) ?></p>

                                    </div>
                                </div>
<!--                                <div class="form-group">
                                    <label class="col-md-3 control-label">Product Meta Title</label>
                                    <div class="col-md-9">
                                        <input type="text" name="prd_title" value="<?= $prd_title ?>" class="form-control" placeholder="Enter Product Meta Title"> 
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Product Keywords</label>
                                    <div class="col-md-9">
                                        <input type="text" name="prd_keywords" value="<?= $prd_keywords ?>" class="form-control" placeholder="Enter Product Keywords"> 
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Product Description</label>
                                    <div class="col-md-9">
                                        <textarea class="form-control" name="prd_description" rows="3"><?= $prd_description ?></textarea>
                                    </div>
                                </div>-->
                            </div>
                            <div class="form-actions">
                                <div class="row">
                                    <div class="col-md-offset-3 col-md-9">
                                        <button type="submit" class="btn green">Submit</button>
                                        <button type="reset" class="btn default">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            //alert(input.id);
            reader.onload = function (e) {
                $('#' + input.id + '_preview').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

</script>