<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $page_heading ?><small ><?php echo $page_heading ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $page_heading ?>                  
                </li>               
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject font-green-sharp bold uppercase"><a href="<?= site_url($this->config->item('backend_url') . '/product-label') ?>">Back</a></span>
                        </div>                         
                    </div>
                    <div class="portlet-body form">
                        <form class="form-horizontal" role="form" method="post" enctype="multipart/form-data">
                            <div class="form-body">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Product Label Name</label>
                                    <div class="col-md-9">
                                        <input type="text" name="prd_label_name" value="<?= $prd_label_name ?>" class="form-control" placeholder="Enter Product Label Name">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('prd_label_name')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputFile" class="col-md-3 control-label">Product Label Image</label>
                                    <div class="col-md-9">
                                        <input type="file" onChange="readURL(this);" id="prd_label_image" name="prd_label_image" value="<?= $prd_label_image ?>"><br>
                                        <?php if (isset($prd_label_image) && $prd_label_image != '') { ?>
                                            <img id="prd_label_image_preview" src="<?= $this->config->item('uploads'); ?>product_images/<?= $prd_label_image ?>" width="50px" height="50px">
                                        <?php } else { ?>
                                            <img id="prd_label_image_preview" src="<?= $this->config->item('backend_assets'); ?>layout/img/upload_image.png" width="50px" height="50px">
                                        <?php } ?>                            
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('prd_label_image')) ?></p>

                                    </div>
                                </div>
                            </div>
                            <div class="form-actions">
                                <div class="row">
                                    <div class="col-md-offset-3 col-md-9">
                                        <button type="submit" class="btn green">Submit</button>
                                        <button type="reset" class="btn default">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            //alert(input.id);
            reader.onload = function (e) {
                $('#' + input.id + '_preview').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>