<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en">
    <head>
        <meta charset="utf-8"/>
        <title><?= $this->config->item('website_name') ?> | Reset Password Form</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
        <meta http-equiv="Content-type" content="text/html; charset=utf-8">
        <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>plugins/simple-line-icons/simple-line-icons.min.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>plugins/uniform/css/uniform.default.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('backend_assets') ?>pages/css/login2.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>css/components-md.css" id="style_components" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>css/plugins-md.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('backend_assets') ?>layout/css/layout.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('backend_assets') ?>layout/css/themes/default.css" rel="stylesheet" type="text/css" id="style_color"/>
        <link href="<?= $this->config->item('backend_assets') ?>layout/css/custom.css" rel="stylesheet" type="text/css"/>
    </head>
    <body class="page-md login">
        <div class="menu-toggler sidebar-toggler">
        </div>
        <div class="logo">
            <a href="<?= site_url($this->config->item('backend_url') . '/login') ?>">
                <img src="<?= $this->config->item('uploads') ?>site_images/<?= $this->config->item('website_logo') ?>"/>
            </a>
        </div>
        <div class="content">
            <form class="login-form" method="post">
                <div class="form-title">
                    <span class="form-title">Please.</span>
                    <span class="form-subtitle">Reset Password</span>
                </div>
                <div class="alert alert-danger display-hide">
                    <button class="close" data-close="alert"></button>
                    <span>
                        <?php if (!empty($message)) { ?>
                            <?php echo $message; ?>
                        <?php } ?> </span>
                </div>
                <div class="form-group">		
                    <label class="control-label">New Password</label>
                    <input class="form-control form-control-solid placeholder-no-fix" type="password"  placeholder="Reset Password" name="new_reset_password"/>
                </div>
                <div class="form-group">
                    <label class="control-label">Confirm New Password</label>
                    <input class="form-control form-control-solid placeholder-no-fix" type="password" placeholder="Confirm Password" name="confirm_new_reset_password"/>
                </div>               
                <div class="form-actions">
                    <input type="submit" value="Reset" name="submit" class="btn btn-primary btn-block uppercase"/>
                </div>		
            </form>
        </div>
        <div class="copyright hide">
            <?php echo date('Y'); ?> © <?= $this->config->item('website_name') ?>
        </div>
        <script src="<?= $this->config->item('global_assets') ?>plugins/jquery.min.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('global_assets') ?>plugins/jquery-migrate.min.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('global_assets') ?>plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('global_assets') ?>plugins/jquery.blockui.min.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('global_assets') ?>plugins/uniform/jquery.uniform.min.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('global_assets') ?>plugins/jquery.cokie.min.js" type="text/javascript"></script>
        <!-- END CORE PLUGINS -->
        <!-- BEGIN PAGE LEVEL PLUGINS -->
        <script src="<?= $this->config->item('global_assets') ?>plugins/jquery-validation/js/jquery.validate.min.js" type="text/javascript"></script>
        <!-- END PAGE LEVEL PLUGINS -->
        <!-- BEGIN PAGE LEVEL SCRIPTS -->
        <script src="<?= $this->config->item('global_assets') ?>scripts/metronic.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('backend_assets') ?>layout/scripts/layout.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('backend_assets') ?>layout/scripts/demo.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('backend_assets') ?>pages/scripts/login.js" type="text/javascript"></script>
        <!-- END PAGE LEVEL SCRIPTS -->
        <script>
            jQuery(document).ready(function () {
                Metronic.init(); // init metronic core components
                Layout.init(); // init current layout
                Login.init();
                Demo.init();
            });
        </script>
    </body>
</html>