<div class="well_success text-success text-center bold">
    <?php if ($this->session->userdata('cart_error_message')) { ?>
       <div class="alert alert-danger" role="alert"><?= $this->session->userdata('cart_error_message') ?></div>
    <?php $this->session->unset_userdata('cart_error_message'); } ?>
</div>
<div id="Main_Content">
    <div class="row">
        <div class="col-md-12">
            <h3 class="side-heading">Items Detail</h3>
			<div class="table-responsive">
            <table class="table order-table table-bordered">
                <tr>
                    <th>Item Name</th>
                    <th align='center'>Qty.</th>
                    <th align='center'>Size/Unit/Type</th>
                    <th align='center'>People</th>
                    <th align='center'>Price</th>
                    <th align="right">Total Price</th>
                </tr>
                <?php
                if ($cart_products_data) {
                    foreach ($cart_products_data as $cart_product) {
                        ?>
                        <tr>
                            <td><?= $cart_product['cart_prd_name'] ?>  <?php if ($cart_product['cart_prd_type'] == 'package') { ?>
                                    <a href="<?= site_url('cart-package-products/' . $cart_product['cart_prd_id']) ?>" class="fancybox fancybox.iframe btn btn-default btn-sm" ><i class="fa fa-eye"></i></a>
                                <?php } ?></td>
                            <td><?= $cart_product['cart_prd_quantity'] ?></td>
                            <td><?= $cart_product['cart_prd_unit'] ?></td>
                            <td><?= ($cart_product['cart_prd_people']!=0)?$cart_product['cart_prd_people'] . ' People':'' ?></td>
                            <td><?= '$ ' . number_format($cart_product['cart_prd_price'], 2, '.', ',') ?></td>
                            <td align="left"><?= '$ ' . number_format($cart_product['cart_prd_tot_price'], 2, '.', ',') ?></td>
                        </tr>
                        <?php
                    }
                } else {
                    ?>
                    <tr>
                        <td colspan="5" class="text-center">No Item Added</td>
                    </tr>
                <?php } ?>
                <tr>
                    <th colspan="5" align="right">Subtotal</th>
                    <td width="100" align="left"><?= ($cart_data['cart_prd_total']) ? '$ ' . number_format($cart_data['cart_prd_total'], 2, '.', ',') : '$ 0.00' ?></td>
                </tr>
                <?php if ($cart_data['cart_cpn_discount']) { ?>
                    <tr>
                        <th colspan="5" align="right">Discount <?= ($cart_data['cart_cpn_per']) ? '( ' . number_format($cart_data['cart_cpn_per'], 2, '.', ',') . '%)' : '$ 0.00' ?></th>
                        <td width="100" align="left"><?= ($cart_data['cart_cpn_discount']) ? '$ ' . number_format($cart_data['cart_cpn_discount'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_gst'] && $cart_data['cart_gst_per']) { ?>
                    <tr>
                        <th colspan="5" align="right">GST (<?= $cart_data['cart_gst_per'] ?>%)</th>
                        <td width="100" align="left"><?= ($cart_data['cart_gst']) ? '$ ' . number_format($cart_data['cart_gst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_pst'] && $cart_data['cart_pst_per']) { ?>
                    <tr>
                        <th colspan="5" align="right">PST (<?= $cart_data['cart_pst_per'] ?>%)</th>
                        <td width="100" align="left"><?= ($cart_data['cart_pst']) ? '$ ' . number_format($cart_data['cart_pst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_hst'] && $cart_data['cart_hst_per']) { ?>
                    <tr>
                        <th colspan="5" align="right">HST (<?= $cart_data['cart_hst_per'] ?>%)</th>
                        <td width="100" align="left"><?= ($cart_data['cart_hst']) ? '$ ' . number_format($cart_data['cart_hst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                    <?php if ($cart_data['cart_del_charges']) { ?>
                       <tr class="active">
                            <th colspan="5" align="right"><strong>Delivery Charges (<?= $cart_data['cart_del_loc_name'] ?>)</strong></th>
                            <td width="100" align="left"><strong>$ <?php echo number_format($cart_data['cart_del_charges'], 2, '.', '') ?></strong></td>
                        </tr>
                    <?php } ?>
                <tr class="active">
                    <th colspan="5" align="right"><strong>Total Amount</strong></th>
                    <td width="100" align="left"><strong>$ <?php echo number_format($cart_data['cart_total'], 2, '.', '') ?></strong></td>
                </tr>
                </tbody>
            </table> 
			</div>
            <div class="clearfix"></div>  
            <div class="pull-right">    
                <a href="<?= site_url() ?>" class="btn btn-primary">Go Back</a>
                <a href="<?= site_url('empty-cart') ?>" class="btn btn-primary">Empty Cart</a>
                <a href="<?= site_url('checkout') ?>" class="btn btn-primary">Checkout</a>
            </div>               
        </div>
    </div>
</div>
