<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
/*
  | -------------------------------------------------------------------------
  | URI ROUTING
  | -------------------------------------------------------------------------
  | This file lets you re-map URI requests to specific controller functions.
  |
  | Typically there is a one-to-one relationship between a URL string
  | and its corresponding controller class/method. The segments in a
  | URL normally follow this pattern:
  |
  |	example.com/class/method/id/
  |
  | In some instances, however, you may want to remap this relationship
  | so that a different class/function is called than the one
  | corresponding to the URL.
  |
  | Please see the user guide for complete details:
  |
  |	http://codeigniter.com/user_guide/general/routing.html
  |
  | -------------------------------------------------------------------------
  | RESERVED ROUTES
  | -------------------------------------------------------------------------
  |
  | There area two reserved routes:
  |
  |	$route['default_controller'] = 'welcome';
  |
  | This route indicates which controller class should be loaded if the
  | URI contains no data. In the above example, the "welcome" class
  | would be loaded.
  |
  |	$route['404_override'] = 'errors/page_missing';
  |
  | This route will tell the Router what URI segments to use if those provided
  | in the URL cannot be matched to a valid route.
  |
 */

$route['default_controller'] = "home";
$route['404_override'] = '';
$route['uploads/(:any)/(:any)'] = "media/resize/";

$route['menu'] = "category/menu";
$route['dine-in'] = "category/dine_in";
$route['online-order'] = "category/online_order";
$route['online-order/(:any)'] = "category/online_order_items/$1";


$route['order-by-tray'] = "category/order_by_tray";
$route['order-by-tray/(:any)'] = "category/order_by_tray_items/$1";

$route['apply-cart-coupon'] = "shopping/cart/apply_coupon";

$route['package'] = 'packages/packages_list';
$route['package/(:any)'] = 'packages/package_detail/$1';


$route['live-catering'] = 'packages/live_packages_list';
$route['live-catering/(:any)'] = 'packages/live_package_detail/$1';


$route['add-live-catering-to-cart'] = 'shopping/cart/add_cart_live_catering_product';


//$route['locations'] = 'locations/locations_list';
$route['location'] = 'locations/location_detail';
$route['select-user-location'] = 'locations/select_user_location';
$route['set-user-location/(:any)'] = 'locations/set_user_location/$1';
$route['location-detail/(:any)'] = 'locations/location_detail/$1';
$route['location-gallery/(:any)'] = 'locations/location_gallery/$1';

$route['inquiry'] = 'users/contact_us';
$route['create-subscriber'] = 'users/newsletter_subscribe';

$route['blog'] = 'blog/index';
$route['blog/(:any)'] = 'blog/blog_detail/$1';
$route['blog-category/(:any)'] = 'blog/blogs_by_category/$1';
$route['blog-archive/(:any)'] = 'blog/blogArchive/$1';

///======= Shopping Urls===================//
$route['empty-cart'] = 'shopping/cart/empty_cart';
$route['add-product-to-cart'] = 'shopping/cart/add_cart_product';
$route['add-package-to-cart'] = 'shopping/cart/add_cart_Package_product';
$route['checkout'] = 'shopping/cart/checkout';
$route['cart-package-products/(:num)'] = 'shopping/cart/cart_package_products/$1';
$route['cart'] = 'shopping/cart/index';
$route['update-cart-prd-qty'] = 'shopping/cart/update_product_quantity';
$route['update-cart-pkg-product'] = 'shopping/cart/delete_pkg_product';
$route['order-complete'] = 'shopping/order/process_order';
$route['track-my-order/(:num)/(:any)'] = 'shopping/order/track_order/$1/$2';
$route['thanks-for-your-order'] = 'shopping/thanks/index';
$route['payment-failure'] = 'shopping/thanks/paypal_failure';
$route['payment-success'] = 'shopping/thanks/paypal_success';
$route['validate-paypal'] = 'shopping/thanks/validatePaypal';


///======= Backend Urls===================//

$route[config_item('backend_url') . '/underconstruction'] = "admin/admin/error404";
$route[config_item('backend_url') . '/admin-logout'] = "admin/admin/admin_logout";
$route[config_item('backend_url') . '/login'] = "admin/admin/login";
$route[config_item('backend_url') . '/dashboard'] = "admin/dashboard/index";
$route[config_item('backend_url') . '/forgot-password'] = 'admin/admin/forgot_admin_password';
$route[config_item('backend_url') . '/change-password'] = 'admin/admin/change_admin_password';
$route[config_item('backend_url') . '/reset-password'] = 'admin/admin/reset_admin_password';
$route[config_item('backend_url') . '/website-links'] = 'admin/website/index';


$route[config_item('backend_url') . '/banner/(:num)'] = 'admin/banner/index/$1';
$route[config_item('backend_url') . '/banner/add/(:num)'] = 'admin/banner/add/$1';
$route[config_item('backend_url') . '/banner/edit/(:num)/(:num)'] = 'admin/banner/edit/$1/$2';
$route[config_item('backend_url') . '/banner/status/(:num)/(:num)/(:any)'] = 'admin/banner/change_status/$1/$2/$3';

$route[config_item('backend_url') . '/blog'] = 'admin/blog/index';
$route[config_item('backend_url') . '/blog/add'] = 'admin/blog/add';
$route[config_item('backend_url') . '/blog/edit/(:num)'] = 'admin/blog/edit/$1';
$route[config_item('backend_url') . '/blog/status/(:num)/(:any)'] = 'admin/blog/change_status/$1/$2';

$route[config_item('backend_url') . '/blog/category'] = 'admin/blog_category/index';
$route[config_item('backend_url') . '/blog/category/add'] = 'admin/blog_category/add';
$route[config_item('backend_url') . '/blog/category/edit/(:num)'] = 'admin/blog_category/edit/$1';
$route[config_item('backend_url') . '/blog/category/status/(:num)/(:any)'] = 'admin/blog_category/change_status/$1/$2';

//$route[config_item('backend_url') . '/blog-comment'] = 'admin/blog_comment/commentList';
$route[config_item('backend_url') . '/blog/comment/(:num)'] = 'admin/blog_comment/index/$1';
$route[config_item('backend_url') . '/comment/view/(:num)'] = 'admin/blog_comment/view/$1';
$route[config_item('backend_url') . '/comment/status/(:num)/(:num)/(:any)'] = 'admin/blog_comment/change_status/$1/$2/$3';

$route[config_item('backend_url') . '/navigation/(:num)'] = 'admin/nav_menu/index/$1';
$route[config_item('backend_url') . '/navigation/add/(:num)'] = 'admin/nav_menu/add/$1';
$route[config_item('backend_url') . '/navigation/edit/(:num)/(:num)'] = 'admin/nav_menu/edit/$1/$2';
$route[config_item('backend_url') . '/navigation/status/(:num)/(:num)/(:any)'] = 'admin/nav_menu/change_status/$1/$2/$3';

$route[config_item('backend_url') . '/category/(:num)'] = 'admin/category/index/$1';
$route[config_item('backend_url') . '/category/add/(:num)'] = 'admin/category/add/$1';
$route[config_item('backend_url') . '/category/edit/(:num)/(:num)'] = 'admin/category/edit/$1/$2';
$route[config_item('backend_url') . '/category/status/(:num)/(:any)'] = 'admin/category/change_status/$1/$2';

$route[config_item('backend_url') . '/product/(:num)'] = 'admin/product/index/$1';
$route[config_item('backend_url') . '/product/add/(:num)'] = 'admin/product/add/$1';
$route[config_item('backend_url') . '/product/edit/(:num)/(:num)'] = 'admin/product/edit/$1/$2';
$route[config_item('backend_url') . '/product/product-attributes/(:num)'] = 'admin/product/product_attributes/$1';
$route[config_item('backend_url') . '/activate-product/(:num)'] = 'admin/product/change_status/$1/active';
$route[config_item('backend_url') . '/inactivate-product/(:num)'] = 'admin/product/change_status/$1/inactive';
$route[config_item('backend_url') . '/delete-product/(:num)'] = 'admin/product/change_status/$1/deleted';

$route[config_item('backend_url') . '/product-label'] = 'admin/product_label/index';
$route[config_item('backend_url') . '/product-label/add'] = 'admin/product_label/add';
$route[config_item('backend_url') . '/product-label/edit/(:num)'] = 'admin/product_label/edit/$1';
$route[config_item('backend_url') . '/activate-product-label/(:num)'] = 'admin/product_label/change_status/$1/active';
$route[config_item('backend_url') . '/inactivate-product-label/(:num)'] = 'admin/product_label/change_status/$1/inactive';
$route[config_item('backend_url') . '/delete-product-label/(:num)'] = 'admin/product_label/change_status/$1/deleted';

$route[config_item('backend_url') . '/meta-tag'] = 'admin/meta_tag/index';
$route[config_item('backend_url') . '/meta-tag/add'] = 'admin/meta_tag/add';
$route[config_item('backend_url') . '/meta-tag/edit/(:num)'] = 'admin/meta_tag/edit/$1';
$route[config_item('backend_url') . '/activate-meta-tag/(:num)'] = 'admin/meta_tag/change_status/$1/active';
$route[config_item('backend_url') . '/inactivate-meta-tag/(:num)'] = 'admin/meta_tag/change_status/$1/inactive';
$route[config_item('backend_url') . '/delete-meta-tag/(:num)'] = 'admin/meta_tag/change_status/$1/deleted';

$route[config_item('backend_url') . '/testimonial'] = 'admin/testimonial/index';
$route[config_item('backend_url') . '/testimonial/add'] = 'admin/testimonial/add';
$route[config_item('backend_url') . '/testimonial/edit/(:num)'] = 'admin/testimonial/edit/$1';
$route[config_item('backend_url') . '/testimonial/status/(:num)/(:any)'] = 'admin/testimonial/change_status/$1/$2';

$route[config_item('backend_url') . '/page'] = 'admin/static_page/index';
$route[config_item('backend_url') . '/page/add'] = 'admin/static_page/add';
$route[config_item('backend_url') . '/page/edit/(:num)'] = 'admin/static_page/edit/$1';
$route[config_item('backend_url') . '/page/status/(:num)/(:any)'] = 'admin/static_page/change_status/$1/$2';

$route[config_item('backend_url') . '/email-template'] = 'admin/email_templates/index';
$route[config_item('backend_url') . '/email-template/edit/(:num)'] = 'admin/email_templates/edit/$1';
$route[config_item('backend_url') . '/activate-email-template/(:num)'] = 'admin/email_templates/change_status/$1/active';
$route[config_item('backend_url') . '/inactivate-email-template/(:num)'] = 'admin/email_templates/change_status/$1/inactive';
$route[config_item('backend_url') . '/delete-email-template/(:num)'] = 'admin/email_templates/change_status/$1/deleted';

$route[config_item('backend_url') . '/coupon'] = 'admin/coupon/index';
$route[config_item('backend_url') . '/coupon/add'] = 'admin/coupon/add';
$route[config_item('backend_url') . '/coupon/edit/(:num)'] = 'admin/coupon/edit/$1';
$route[config_item('backend_url') . '/activate-coupon/(:num)'] = 'admin/coupon/change_status/$1/active';
$route[config_item('backend_url') . '/inactivate-coupon/(:num)'] = 'admin/coupon/change_status/$1/inactive';
$route[config_item('backend_url') . '/delete-coupon/(:num)'] = 'admin/coupon/change_status/$1/deleted';

$route[config_item('backend_url') . '/order'] = 'admin/orders/order_list';
$route[config_item('backend_url') . '/order/(:num)'] = 'admin/orders/view_order/$1';
$route[config_item('backend_url') . '/order/update-tracking-message/(:num)'] = 'admin/orders/update_tracking_message/$1';
$route[config_item('backend_url') . '/cancil-order/(:num)'] = 'admin/orders/change_status/$1/cancelled';
$route[config_item('backend_url') . '/complete-order/(:num)'] = 'admin/orders/change_status/$1/completed';
$route[config_item('backend_url') . '/delete-order/(:num)'] = 'admin/orders/change_status/$1/deleted';
$route[config_item('backend_url') . '/order-package-products/(:num)'] = 'admin/orders/order_package_products/$1';

$route[config_item('backend_url') . '/package'] = 'admin/package/index';
$route[config_item('backend_url') . '/package/add'] = 'admin/package/add';
$route[config_item('backend_url') . '/package/edit/(:num)'] = 'admin/package/edit/$1';
$route[config_item('backend_url') . '/activate-package/(:num)'] = 'admin/package/change_status/$1/active';
$route[config_item('backend_url') . '/inactivate-package/(:num)'] = 'admin/package/change_status/$1/inactive';
$route[config_item('backend_url') . '/delete-package/(:num)'] = 'admin/package/change_status/$1/deleted';
$route[config_item('backend_url') . '/package/package-attributes/(:num)'] = 'admin/package/package_attributes/$1';
$route[config_item('backend_url') . '/get-package-products'] = 'admin/package/get_package_products';
$route[config_item('backend_url') . '/delete-package-attribute/(:num)'] = 'admin/package/delete_package_attribute/$1';



$route[config_item('backend_url') . '/live-catering'] = 'admin/live_catering/index';
$route[config_item('backend_url') . '/live-catering/add'] = 'admin/live_catering/add';
$route[config_item('backend_url') . '/live-catering/edit/(:num)'] = 'admin/live_catering/edit/$1';
$route[config_item('backend_url') . '/activate-live-catering/(:num)'] = 'admin/live_catering/change_status/$1/active';
$route[config_item('backend_url') . '/inactivate-live-catering/(:num)'] = 'admin/live_catering/change_status/$1/inactive';
$route[config_item('backend_url') . '/delete-live-catering/(:num)'] = 'admin/live_catering/change_status/$1/deleted';
$route[config_item('backend_url') . '/live-catering/package-attributes/(:num)'] = 'admin/live_catering/package_attributes/$1';
$route[config_item('backend_url') . '/get-live-catering-products'] = 'admin/live_catering/get_package_products';
$route[config_item('backend_url') . '/delete-live-catering-attribute/(:num)'] = 'admin/live_catering/delete_package_attribute/$1';




$route[config_item('backend_url') . '/user/inquiries'] = 'admin/users/inquiries';
$route[config_item('backend_url') . '/user/subscribers'] = 'admin/users/subscribers';
$route[config_item('backend_url') . '/user/inquiries/(:num)'] = 'admin/users/view_user/$1';
$route[config_item('backend_url') . '/user/subscribers/(:num)'] = 'admin/users/view_user/$1';
$route[config_item('backend_url') . '/user/delete-user/(:num)'] = 'admin/users/change_status/$1/deleted';
$route[config_item('backend_url') . '/user/export-inquiry'] = 'admin/users/export_inquiries';
$route[config_item('backend_url') . '/user/export-subscribers'] = 'admin/users/export_subscribers';

$route[config_item('backend_url') . '/location/(:num)'] = 'admin/locations/index/$1';
$route[config_item('backend_url') . '/location/add/(:num)'] = 'admin/locations/add/$1';
$route[config_item('backend_url') . '/location/edit/(:num)/(:num)'] = 'admin/locations/edit/$1/$2';
$route[config_item('backend_url') . '/activate-location/(:num)'] = 'admin/locations/change_status/$1/active';
$route[config_item('backend_url') . '/inactivate-location/(:num)'] = 'admin/locations/change_status/$1/inactive';
$route[config_item('backend_url') . '/delete-location/(:num)'] = 'admin/locations/change_status/$1/deleted';
$route[config_item('backend_url') . '/location/images/(:num)'] = 'admin/locations/location_images/$1';
$route[config_item('backend_url') . '/location/image/status/(:num)/(:num)/(:any)'] = 'admin/locations/change_image_status/$1/$2/$3';
$route[config_item('backend_url') . '/location/set-default-image/(:num)/(:num)/(:any)'] = 'admin/locations/set_default_image/$1/$2/$3';
$route[config_item('backend_url') . '/location/detail/(:num)/(:num)'] = 'admin/locations/location_detail/$1/$2';


$route['page/(:any)'] = 'home/static_pages/$1';
$route['(:any)'] = 'home/static_pages/$1';
/* End of file routes.php */
/* Location: ./application/config/routes.php */