<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model($this->config->config['backend_folder_name'] . '/admin_model', 'admin');
        $this->load->model('mailsending_model', 'mailer');
        $this->load->library('form_validation');
    }

    public function login() {
        if ($this->session->userdata('ADM_ID')) {
            redirect($this->config->config['backend_url']. '/dashboard');
            exit;
        }
        if (!empty($_POST)) {
            $this->form_validation->set_rules('login_identity', 'User Name', 'trim|required');
            $this->form_validation->set_rules('login_password', 'Password', 'trim|required');
            if ($this->form_validation->run()) {
                $returnLogin = $this->admin->do_login();
                if ($returnLogin === TRUE) {
                    redirect($this->config->config['backend_url']. '/dashboard');
                    exit;
                } else {
                    $data['error_login'] = 'Invalid login details.';
                }
            }
        }
        $this->load->view($this->config->config['backend_folder_name'] . '/login', $data);
    }

    public function forgot_admin_password() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('forgot_password_identity', 'Forgotten Email', 'trim|required|valid_email');
            if ($this->form_validation->run()) {
                if ($this->admin->check_forgot_email()) {
                    $returnPassword = $this->admin->set_verification_code();
                    echo $returnPassword;die;
                    $admin_detail= $this->admin->get_loggedin_admin_detail();
                     $this->mailer->forgot_password_mail($admin_detail);
                    $this->session->set_flashdata('FORGOT_PASSWORD_SUCCESS_MESSAGE', 'Your Password reset link has been successfully sent to your E-mail Address.');
                } else {
                    $data['is_error'] = 'Invalid Email';
                }
            }
        }
        redirect($this->config->config['backend_url']. '/login');
            exit;
    }

    public function reset_admin_password($token) {
        if ($this->session->userdata('ADM_ID')) {
            redirect($this->config->config['backend_url']);
            exit;
        }
        if (!empty($_POST)) {
            $this->form_validation->set_rules('new_reset_password', 'New Password', 'trim|required|min_length[3]|max_length[15]');
            $this->form_validation->set_rules('confirm_new_reset_password', 'Confirm New Password', 'trim|required|min_length[3]|max_length[15]|matches[resetPassword]');
            if ($this->form_validation->run()) {
                $this->admin->reset_password($token);
                $this->session->set_flashdata('RESET_PASSWORD_SUCCESS_MESSAGE', 'You Have Successfully Reset Your Password');
                redirect($this->config->item('backend_url'));
                exit();
            }
        }
        $this->load->view($this->config->item('backend_folder_name') . '/reset_password');
    }

    public function change_admin_password() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('old_password', 'Old Password', 'trim|required');
            $this->form_validation->set_rules('new_password', 'New Password', 'trim|required|min_length[3]|max_length[15]');
            $this->form_validation->set_rules('confirm_new_password', 'Confirm Password', 'trim|required|min_length[3]|max_length[15]|matches[new_password]');
            if ($this->form_validation->run()) {
                $check_old_password = $this->admin->check_old_password($this->input->post('old_password'));
              //  print_r($checkOldPassword);die;
                if ($check_old_password) {
                    $this->admin->change_password();
                    $this->session->set_flashdata('success_message', 'Password Updation Successful');
                    redirect($this->config->item('backend_url') . '/change-password');
                    exit;
                } else {
                    $this->session->set_flashdata('error_message', 'OLD Password is Wrong');
                    redirect($this->config->item('backend_url') . '/change-password');
                    exit;
                }
                redirect($this->config->item('backend_url') . '/admin_logout');
                exit;
            }
        }
        $this->load->view($this->config->item('backend_folder_name') . '/header');
        $this->load->view($this->config->item('backend_folder_name') . '/change_password');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function index() {
        $this->load->view($this->config->config['backend_folder_name'] . '/header');
        $this->load->view($this->config->config['backend_folder_name'] . '/dashboard');
        $this->load->view($this->config->config['backend_folder_name'] . '/footer');
    }

    public function error404() {
        $this->load->view($this->config->config['backend_folder_name'] . '/header');
        $this->load->view($this->config->config['backend_folder_name'] . '/underconstruction');
        $this->load->view($this->config->config['backend_folder_name'] . '/footer');
    }

    public function admin_logout() {
        $returnLogin = $this->admin->do_logout();
        redirect($this->config->config['backend_url'] . '/login');
        exit;
    }

}
