<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Blog extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/blog_model', 'blog');
        $this->load->model($this->config->item('backend_folder_name') . '/blog_category_model', 'category');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['blog_data'] = $this->blog->get_blog_list();
        $data['breadcumb'] = 'Edit Blog';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/blog/blog_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add() {  
        if (!empty($_POST)) {
            $this->form_validation->set_rules('blog_name', 'Blog Title', 'trim|required');

            if ($this->form_validation->run()) {
                if ($_FILES["blog_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/blog_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('blog_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->blog->add_blog($detail['upload_data']['file_name']);         
                $this->session->set_flashdata('BlogSuccess', 'Blog Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/blog');
                exit;
            } else {
                $data['blog_cat_fk'] = $this->input->post('blog_cat_fk');
                $data['blog_name'] = $this->input->post('blog_name');
                $data['blog_content'] = $this->input->post('blog_content');
                $data['blog_title'] = $this->input->post('blog_title');
                $data['blog_keywords'] = $this->input->post('blog_keywords');
                $data['blog_description'] = $this->input->post('blog_description');
                $data['blog_blogger_name'] = $this->input->post('blog_blogger_name');
                $data['blog_image'] = $this->input->post('blog_image');
                $data['blog_show_image'] = $this->input->post('blog_show_image');                   
            }
        }
        $data['breadcumb'] = 'Add Blog';
        $data['blog_cat_list'] = $this->category->get_blog_category_list();
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/blog/blog_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($blogId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('blog_name', 'Blog Title', 'trim|required');
            if ($this->form_validation->run()) {
                $temp = TRUE;
                if ($_FILES["blog_image"]['name']) {
                    @mkdir($this->config->item('uploads') . "blog_images/", 0777, true);
                    @chmod($this->config->item('uploads') . "blog_images/", 0777);
                    $config['upload_path'] ='./assets/uploads/blog_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('blog_image')) {
                        $error_msg = $this->upload->display_errors();
                       
                        $temp = FALSE;
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                if ($temp) {
                    $this->blog->update_blog($blogId, $detail['upload_data']['file_name']);             
                $this->session->set_flashdata('BlogSuccess', 'Blog Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/blog');
                exit;
                } else {
                    $this->session->set_flashdata('BlogSuccess', $error_msg);
                }
            } else {
                $data['blog_cat_fk'] = $this->input->post('blog_cat_fk');
                $data['blog_name'] = $this->input->post('blog_name');
                $data['blog_content'] = $this->input->post('blog_content');
                $data['blog_title'] = $this->input->post('blog_title');
                $data['blog_keywords'] = $this->input->post('blog_keywords');
                $data['blog_description'] = $this->input->post('blog_description');
                $data['blog_blogger_name'] = $this->input->post('blog_blogger_name');
                $data['blog_image'] = $this->input->post('blog_image');
                $data['blog_show_image'] = $this->input->post('blog_show_image');           
            }
        } else {
            $value = $this->common_model->get_single_row_from_any_table('blog_id',$blogId,'tbl_blog');   
             
                $data['blog_cat_fk'] = $value->blog_cat_fk;
                $data['blog_name'] = $value->blog_name;
                $data['blog_content'] = $value->blog_content;
                $data['blog_title'] = $value->blog_title;                
                $data['blog_keywords'] = $value->blog_keywords;
                $data['blog_description'] = $value->blog_description;
                $data['blog_blogger_name'] = $value->blog_blogger_name;
                $data['blog_image'] = $value->blog_image;
                $data['blog_show_image'] = $value->blog_show_image;          
            }       
      
        $data['blog_cat_list'] = $this->category->get_blog_category_list();
        $data['breadcumb'] = 'Edit Blog';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/blog/blog_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($blogId, $status) {
        if ($blogId != '' && $status != '') {
            $this->blog->update_status($blogId, $status);
            $this->session->set_flashdata('BlogSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/blog');
            exit;
        }
    }


}
