<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Blog_Category extends CI_Controller {

    public function __construct() {
        parent::__construct();
        //  $this->common_model->check_admin_login_session();
        $this->load->model($this->config->item('backend_folder_name') . '/blog_category_model', 'category');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['blog_cat_list'] = $this->category->get_blog_category_list();
        $data['breadcumb'] = 'Manage Blog Category';
        $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('backend_folder_name') . '/blog/blog_category_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add() {
        $data['breadcum'] = 'Add Blog Category';
        if (!empty($_POST)) {
            $this->form_validation->set_rules('blog_cat_name', 'Blog Category', 'trim|required');
            if ($this->form_validation->run()) {
                $this->category->add();
                $this->session->set_flashdata('BlogCategorySuccess', 'Blog Category Has Been Added Successfully');
                redirect($this->config->item('backend_folder_name') . '/blog-category');
                exit;
            } else {
                $data['blog_cat_name'] = $this->input->post('blog_cat_name');
                $data['blog_cat_title'] = $this->input->post('blog_cat_title');
                $data['blog_cat_keywords'] = $this->input->post('blog_cat_keywords');
                $data['blog_cat_description'] = $this->input->post('blog_cat_description');
            }
        }
        $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('backend_folder_name') . '/blog/blog_category_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($catId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('blog_cat_name', 'Blog Category', 'trim|required');

            if ($this->form_validation->run()) {
                $this->category->update($catId);
                $this->session->set_flashdata('BlogCategorySuccess', 'Blog Category Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/blog/category');
                exit;
            } else {
                $data['blog_cat_name'] = $this->input->post('blog_cat_name');
                $data['blog_cat_title'] = $this->input->post('blog_cat_title');
                $data['blog_cat_keywords'] = $this->input->post('blog_cat_keywords');
                $data['blog_cat_description'] = $this->input->post('blog_cat_description');
            }
        } else {
            $lists = $this->common_model->get_single_row_from_any_table('blog_cat_id', $catId, 'tbl_blog_category');
            $data['blog_cat_name'] = $lists->blog_cat_name;
            $data['blog_cat_title'] = $lists->blog_cat_title;        
            $data['blog_cat_keywords'] = $lists->blog_cat_keywords;
            $data['blog_cat_description'] = $lists->blog_cat_description;
        }
        $data['breadcum'] = 'Edit Blog Category';
        $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('backend_folder_name') . '/blog/blog_category_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($catId, $status) {
        if ($catId != '' && $status != '') {
            $this->category->update_status($catId, $status);
            $this->session->set_flashdata('BlogCategorySuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/blog/category');
            exit;
        }
    }

}
