<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Coupon extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/coupon_model', 'coupon');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['coupons_data'] = $this->coupon->get_coupons_list();
        $data['page_heading'] = 'Manage Coupons';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/coupon/coupon_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('cpn_code', 'Coupon Code', 'trim|required');
            $this->form_validation->set_rules('cpn_discount', 'Coupon Discount', 'trim|required');
            $this->form_validation->set_rules('cpn_min_price', 'Coupon Min Price', 'trim|required');
            $this->form_validation->set_rules('cpn_type', 'Coupon Type', 'trim|required');
            if ($this->form_validation->run()) {
                $this->coupon->add_coupon();
                $this->session->set_flashdata('success_message', 'Coupon Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/coupon');
                exit;
            } else {
                $data['cpn_code'] = $this->input->post('cpn_code');
                $data['cpn_discount'] = $this->input->post('cpn_discount');
                $data['cpn_min_price'] = $this->input->post('cpn_min_price');
                $data['cpn_type'] = $this->input->post('cpn_type');
                $data['location_id'] = $this->input->post('location_id');
                $data['cpn_exp_date'] = $this->input->post('cpn_exp_date');
            }
        }
        $data['page_heading'] = 'Add Coupon';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/coupon/coupon_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($coupon_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('cpn_code', 'Coupon Code', 'trim|required');
            $this->form_validation->set_rules('cpn_discount', 'Coupon Discount', 'trim|required');
            $this->form_validation->set_rules('cpn_min_price', 'Coupon Min Price', 'trim|required');
            $this->form_validation->set_rules('cpn_type', 'Coupon Type', 'trim|required');
            if ($this->form_validation->run()) {
                $this->coupon->update_coupon($coupon_id);
                $this->session->set_flashdata('success_message', 'Coupon Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/coupon');
                exit;
            } else {
                $data['cpn_code'] = $this->input->post('cpn_code');
                $data['cpn_discount'] = $this->input->post('cpn_discount');
                $data['cpn_min_price'] = $this->input->post('cpn_min_price');
                $data['cpn_type'] = $this->input->post('cpn_type');
                $data['location_id'] = $this->input->post('location_id');
                $data['cpn_exp_date'] = $this->input->post('cpn_exp_date');
            }
        } else {
            $coupon_detail = $this->coupon->get_coupon_detail($coupon_id);
            $data['cpn_code'] = $coupon_detail['cpn_code'];
            $data['cpn_discount'] = $coupon_detail['cpn_discount'];
            $data['cpn_min_price'] = $coupon_detail['cpn_min_price'];
            $data['cpn_type'] = $coupon_detail['cpn_type'];
            $data['location_id'] = $coupon_detail['cpn_loc_fk'];
            $data['cpn_exp_date'] = $coupon_detail['cpn_exp_date'];
        }
        $data['page_heading'] = 'Edit Coupon';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/coupon/coupon_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($coupon_id, $coupon_status) {
        if ($coupon_id != '' && $coupon_status != '') {
            $this->coupon->update_status($coupon_id, $coupon_status);
            $this->session->set_flashdata('success_message', 'Status Of This Record Has Been Updated Successfully');
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

}
