<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Dashboard extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->common_model->check_admin_login_session();
        $this->load->model($this->config->config['backend_folder_name'] . '/user_model', 'user');
        $this->load->model($this->config->item('backend_folder_name') . '/order_model', 'order');
        $this->load->model($this->config->item('backend_folder_name') . '/location_model', 'location');
        $this->load->model($this->config->item('backend_folder_name') . '/product_model', 'product');
    }

    public function index() {
        $data['total_unread_enquiries']=$this->user->get_user_counts('inquiry');
        $data['total_subscribers']=$this->user->get_user_counts('subscriber');
        $data['total_pending_orders']=$this->order->get_order_counts();
        $data['total_locations']=$this->location->get_location_counts();
        $data['total_menu_counts']=$this->product->get_product_counts(1);
        $data['total_tray_counts']=$this->product->get_product_counts(4);
        $data['total_online_order_counts']=$this->product->get_product_counts(2);
        $data['total_package_products_counts']=$this->product->get_product_counts(3);
        $this->load->view($this->config->config['backend_folder_name'] . '/header',$data);
        $this->load->view($this->config->config['backend_folder_name'] . '/dashboard');
        $this->load->view($this->config->config['backend_folder_name'] . '/footer');
    }
}
