<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Orders extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/order_model', 'order');
        $this->load->library('form_validation');
    }

    public function order_list() {
        $data['orders_list'] = $this->order->get_order_list();
        $data['page_heading'] = 'Manage Orders';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/order/order_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function view_order($order_id) {
        $data['order_data'] = $order_detail = $this->order->get_order_detail($order_id);
        $data['order_products'] = $this->order->get_order_products($order_id);
        $data['page_heading'] = 'View Order Detail';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/order/order_view');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }
    
    public function order_package_products($order_product_id) {
        $data['page_heading'] = 'Package Products';
        $data['order_package_products'] = $order_data = $this->order->get_order_package_products($order_product_id);
        //$this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/order/order_package_products_view', $data);
        //$this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function update_tracking_message($order_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('tracking_message', 'Tracking Mesaage Name', 'trim|required');
            if ($this->form_validation->run()) {
                $this->order->update_tracking_message($order_id);
                $this->session->set_userdata('success_message', 'Tracking Message Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/order');
                exit;
            } else {
                $data['tracking_message'] = $this->input->post('tracking_message');
            }
        } else {
            $order_detail = $this->order->get_order_detail($order_id);
            $data['tracking_message'] = $order_detail['order_tracking_message'];
        }
        $data['page_heading'] = 'Edit Tracking Message';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/order/tracking_message_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($order_id, $order_status) {
        if ($order_id != '' && $order_status != '') {
            $this->order->update_status($order_id, $order_status);
            $this->session->set_flashdata('success_message', 'Status Of This Order Has Been Updated Successfully');
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

}
