<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Product extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/product_model', 'product');
        $this->load->model($this->config->item('backend_folder_name') . '/product_label_model', 'product_label');
        $this->load->model($this->config->item('backend_folder_name') . '/category_model', 'category');
        $this->load->library('form_validation');
    }

    public function index($category_type_id) {
        $data['product_list'] = $this->product->get_product_list($category_type_id);
        $data['breadcumb'] = 'Manage Product';
        $data['cat_type_id'] = $category_type_id;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/product/product_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add($category_type_id) {
        if (!empty($_POST)) {
            
            $this->form_validation->set_rules('prd_cat_fk', 'Product Category', 'trim|required');
            $this->form_validation->set_rules('prd_name', 'Product Title', 'trim|required');
            $this->form_validation->set_rules('prd_price', 'Product Price', 'trim|required');
           
            
            
            if ($this->form_validation->run()) {
                if ($_FILES["prd_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/product_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('prd_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->product->add_product($detail['upload_data']['file_name']);
                $this->session->set_flashdata('ProductSuccess', 'Product Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/product/' . $category_type_id);
                exit;
            } else {
                $data['prd_cat_fk'] = $this->input->post('prd_cat_fk');
                $data['prd_name'] = $this->input->post('prd_name');
                $data['prd_label_fk'] = $this->input->post('prd_label_fk');
                $data['prd_content'] = $this->input->post('prd_content');
                $data['prd_sku'] = $this->input->post('prd_sku');
                $data['prd_price'] = $this->input->post('prd_price');
//                $data['prd_title'] = $this->input->post('prd_title');
//                $data['prd_keywords'] = $this->input->post('prd_keywords');
//                $data['prd_description'] = $this->input->post('prd_description');
            }
        }
        $data['breadcumb'] = 'Add Product';
        $data['product_cat_list'] = $this->category->get_category_list($category_type_id);
        $data['product_labels'] = $this->product_label->get_product_label_list();
        $data['cat_type_id'] = $category_type_id;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/product/product_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($category_type_id, $product_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('prd_name', 'Product Title', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["prd_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/product_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('prd_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->product->update_product($product_id, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('ProductSuccess', 'Product Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/product/' . $category_type_id);
                exit;
            } else {
                $data['prd_name'] = $this->input->post('prd_name');
                $data['prd_content'] = $this->input->post('prd_content');
                $data['prd_label_fk'] = $this->input->post('prd_label_fk');
                $data['prd_sku'] = $this->input->post('prd_sku');
                $data['prd_price'] = $this->input->post('prd_price');
//                $data['prd_title'] = $this->input->post('prd_title');
//                $data['prd_keywords'] = $this->input->post('prd_keywords');
//                $data['prd_description'] = $this->input->post('prd_description');
            }
        } else {
            $product_detail = $this->common_model->get_single_row_from_any_table('prd_id', $product_id, 'tbl_products');
            $data['prd_name'] = $product_detail->prd_name;
            $data['prd_cat_fk'] = $product_detail->prd_cat_fk;
            $data['prd_label_fk'] = $product_detail->prd_label_fk;
            $data['prd_content'] = $product_detail->prd_content;
            $data['prd_sku'] = $product_detail->prd_sku;
            $data['prd_price'] = $product_detail->prd_price;
            $data['prd_image'] = $product_detail->prd_image;
//            $data['prd_title'] = $product_detail->prd_title;
//            $data['prd_keywords'] = $product_detail->prd_keywords;
//            $data['prd_description'] = $product_detail->prd_description;
        }
        $data['breadcumb'] = 'Edit Product';
        $data['product_cat_list'] = $this->category->get_category_list($category_type_id);
        $data['product_labels'] = $this->product_label->get_product_label_list();
        $data['cat_type_id'] = $category_type_id;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/product/product_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($product_id, $product_status) {
        if ($product_id != '' && $product_status != '') {
            $this->product->update_status($product_id, $product_status);
            $this->session->set_flashdata('product_msg', 'Status Of This Record Has Been Updated Successfully');
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

    public function product_attributes($product_id) {
        if (!empty($_POST)) {
            $this->product->delete_product_attributes($product_id);
            $this->product->add_product_attributes($product_id);
            $this->session->set_userdata('product_msg', 'Product Attributes Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/product/product-attributes/' . $product_id);
            exit;
        } else {
            $data['breadcumb'] = 'Manage Product Attributes';
            $data['prd_attribute_list'] = $this->product->get_product_attributes($product_id);
            $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
            $this->load->view($this->config->item('backend_folder_name') . '/product/product_attributes');
            $this->load->view($this->config->item('backend_folder_name') . '/footer');
        }
    }

}
