<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Static_Page extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/static_page_model', 'page');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['page_data'] = $this->page->get_page_list();
        $data['breadcumb'] = 'Manage Page';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/static_page/page_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('static_page_name', 'Page Name', 'trim|required');
            if ($this->form_validation->run()) {
                $this->page->add_page();
                $this->session->set_flashdata('PageSuccess', 'Page Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/page');
                exit;
            } else {
                $data['static_page_name'] = $this->input->post('static_page_name');
                $data['static_page_content'] = $this->input->post('static_page_content');
                $data['static_page_title'] = $this->input->post('static_page_title');
                $data['static_page_keywords'] = $this->input->post('static_page_keywords');
                $data['static_page_description'] = $this->input->post('static_page_description');
            }
        }
        $data['breadcumb'] = 'Add Page';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/static_page/page_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($pageId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('static_page_name', 'Page Name', 'trim|required');
            if ($this->form_validation->run()) {
                $this->page->update_page($pageId);
                $this->session->set_flashdata('PageSuccess', 'Page Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/page');
                exit;
            } else {
                $data['static_page_name'] = $this->input->post('static_page_name');
                $data['static_page_content'] = $this->input->post('static_page_content');
                $data['static_page_title'] = $this->input->post('static_page_title');
                $data['static_page_keywords'] = $this->input->post('static_page_keywords');
                $data['static_page_description'] = $this->input->post('static_page_description');
            }
        } else {
            $value = $this->common_model->get_single_row_from_any_table('static_page_id', $pageId, 'tbl_static_pages');
            $data['static_page_name'] = $value->static_page_name;
            $data['static_page_content'] = $value->static_page_content;
            $data['static_page_title'] = $value->static_page_title;
            $data['static_page_keywords'] = $value->static_page_keywords;
            $data['static_page_description'] = $value->static_page_description;
        }
        $data['breadcumb'] = 'Edit Page';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/static_page/page_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($pageId, $status) {
        if ($pageId != '' && $status != '') {
            $this->page->update_status($pageId, $status);
            $this->session->set_flashdata('PageSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/page');
            exit;
        }
    }
}