<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Users extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/user_model', 'user');
        $this->load->library('form_validation');
        $this->load->dbutil();
    }

    public function inquiries() {
        $data['users_data'] = $this->user->get_user_list('inquiry');
        $data['page_heading'] = 'Manage Inquiries';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/user/inquiries_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function subscribers() {
        $data['users_data'] = $this->user->get_user_list('subscriber');
        $data['page_heading'] = 'Manage Subscribers';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/user/subscribers_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function view_user($user_id) {
        $data['user_detail'] = $this->user->get_user_detail($user_id);
        $this->user->update_status($user_id, 'read');
        $data['page_heading'] = 'View Detail';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/user/user_view');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($user_id, $user_status) {
        if ($user_id != '' && $user_status != '') {
            $this->user->update_status($user_id, $user_status);
            $this->session->set_flashdata('success_message', 'Status Of This Record Has Been Updated Successfully');
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

    public function export_inquiries() {
        $data = $this->user->export_inquiries();
        $this->load->helper('download');
        force_download("inquiry_list.csv", $data);
        exit;
    }

    public function export_subscribers() {
        $data = $this->user->export_subscribers();
        $this->load->helper('download');
        force_download("subscribers_list.csv", $data);
        exit;
    }

}
