<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Website extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/website_model', 'website');
        $this->load->library('form_validation');
    }

    public function index() {
        $lists = $this->website->website_list();
        $website_id = $lists['website_id'];
        $data['website_paypal_email'] = $lists['website_paypal_email'];
        $data['website_email'] = $lists['website_email'];
        $data['website_address'] = $lists['website_address'];
		$data['website_address2'] = $lists['website_address2'];
        $data['website_phone_number'] = $lists['website_phone_number'];
        $data['website_facebook_link'] = $lists['website_facebook_link'];
        $data['website_twitter_link'] = $lists['website_twitter_link'];
        $data['website_instagram_link'] = $lists['website_instagram_link'];
        $data['website_youtube_link'] = $lists['website_youtube_link'];
        $data['website_cod_note'] = $lists['website_cod_note'];
        $data['website_checkout_notice'] = $lists['website_checkout_notice'];
        $data['website_linkedin_link'] = $lists['website_linkedin_link'];
        $data['website_name'] = $lists['website_name'];
        $data['website_google_indexing'] = $lists['website_google_indexing'];
        $data['website_logo'] = $lists['website_logo'];
        if (!empty($_POST)) {
            if ($_FILES["website_logo"]['name']) {
                $config['upload_path'] = './assets/uploads/site_images';
                $config['allowed_types'] = 'jpg|png|jpeg|gif';
                $this->load->library('upload', $config);
                if (!$this->upload->do_upload('website_logo')) {
                    $error_msg = $this->upload->display_errors();
                } else {
                    $detail = array('upload_data' => $this->upload->data());
                }
            }
            $this->website->update_website_settings($website_id, $detail['upload_data']['file_name']);
            $this->session->set_flashdata('websiteSettingsUpdate', 'Website Setting Detail Has Been Update Successfully');
            redirect($this->config->item('backend_url') . '/website-links');
            exit;
        }
        $data['breadcumb'] = 'Website Settings';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/website/website_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

}
