<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Home extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->model('users_model', 'user');
        $this->load->model('mailsending_model', 'sendingEmail');
        $this->load->library('recaptcha');
    }
    public function index() {
        $data['page_name'] = 'home';
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/home');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }
    public function static_pages($static_page_slug) {
        $data['static_page_data'] =$static_page_data= $this->common_model->get_static_content($static_page_slug);
        $data['page_heading'] = $static_page_data['static_page_name'];
        $data['METATITLE'] = $static_page_data['static_page_title'];
        $data['METAKEYWORDS'] = $static_page_data['static_page_keywords'];
        $data['METADESCRIPTION'] = $static_page_data['static_page_description'];
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        if($static_page_slug == 'party-room'){
            if (!empty($_POST)) {
                $this->form_validation->set_rules('g-recaptcha-response', 'Recaptcha validation', 'required|callback_validate_captcha');
                $this->form_validation->set_rules('name', 'Name', 'trim|required');
                $this->form_validation->set_rules('email', 'Email Id', 'trim|required|valid_email');
                $this->form_validation->set_rules('phone', 'Phone No', 'trim|required');
                if ($this->form_validation->run()) {
                    $this->user->create_new_user('inquiry');
                    $this->sendingEmail->global_mail(4);
                    $this->session->set_userdata('success_message', 'Thanks for your query/Feedback. Our team will get back to you within 24 hours.');
                    redirect(site_url('page/party-room'));
                    exit();
                } else {
                    $data['name'] = $this->input->post('name');
                    $data['email'] = $this->input->post('email');
                    $data['phone'] = $this->input->post('phone');
                    $data['no_of_guest'] = $this->input->post('no_of_guest');
                    $data['datet'] = $this->input->post('datet');
                    $data['timet'] = $this->input->post('timet');
                    $data['comment'] = $this->input->post('comment');
                    $this->session->set_userdata('error_message', 'There Is Some Error');
                }
            }
            $data['recaptcha_html'] = $this->recaptcha->recaptcha_get_html();
            $this->load->view($this->config->item('frontend_folder_name') . '/party_room_page', $data);
        }else{
            $this->load->view($this->config->item('frontend_folder_name') . '/static_page');
        }
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }
    
    function validate_captcha() {
        $recaptcha = trim($this->input->post('g-recaptcha-response'));
        $userIp= $this->input->ip_address();
        $secret='6Lc5w84UAAAAAChCsSrVNMjN0V-4wd-_VIcnJjzd';
        $data = array(
            'secret' => "$secret",
            'response' => "$recaptcha",
            'remoteip' =>"$userIp"
        );

        $verify = curl_init();
        curl_setopt($verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
        curl_setopt($verify, CURLOPT_POST, true);
        curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($verify);
        $status= json_decode($response, true);
        //print_r($status);die;
        if(empty($status['success'])){
            $this->form_validation->set_message('validate_captcha', 'Please confirm you are not a robot');
            return FALSE;
        }else{
            return TRUE;
        }
    }
    
}
