<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Packages extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('packages_model', 'packages');
         $this->load->model('live_catering_model', 'livecatering');
        $this->load->model('category_model', 'category');
        $this->load->model($this->config->item('shopping_folder_name') . '/cart_model', 'cart');
    }

    public function packages_list() {
        $data['page_heading'] = 'Packages';
        $data['packages_list'] = $this->packages->get_all_packages();
        $data['package_categories'] = $this->category->get_categories_by_type(3);
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/package_list');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }
    
    
    public function live_packages_list() {
        $data['page_heading'] = 'Packages';
        $data['packages_list'] = $this->livecatering->get_all_packages();
       
       // $data['package_categories'] = $this->category->get_categories_by_type(3);
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/live_package_list');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }
    

    public function package_detail($package_id) {
        if (!empty($_POST)) {
            $no_of_people = $this->input->post('no_of_people');
            $data['package_detail'] =$package_detail = $this->packages->get_package_detail($package_id);
            if ($no_of_people >= $package_detail['package_min_people'] && $no_of_people <= 100) {
                $data['package_categories'] = $this->category->get_categories_by_type(3);
                $data['page_heading'] = 'Customize Package';
                $data['erase_cache'] = true;
                $data['no_of_people'] = $no_of_people;
                $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
                $this->load->view($this->config->item('frontend_folder_name') . '/package_detail');
                $this->load->view($this->config->item('frontend_folder_name') . '/footer');
            } else if ($no_of_people > 100) {
                $this->session->set_userdata('error_message', 'For more info please email' . $this->config->item('website_email'));
                redirect(site_url('package'));
                exit;
            } else {
                $this->session->set_userdata('error_message', 'You have entered less no of people for this package');
                redirect(site_url('package'));
                exit;
            }
        } else {
            redirect(site_url('package'));
            exit;
        }
    }
    
    
    public function live_package_detail($package_id) {
        if (!empty($_POST)) {
            $no_of_people = $this->input->post('no_of_people');
            $data['package_detail'] =$package_detail = $this->livecatering->get_package_detail($package_id);
            
            if ($no_of_people >= $package_detail['package_min_people'] && $no_of_people <= 100) {
                $data['package_categories'] = $this->category->get_categories_by_type(6);
                
                //print_r($data['package_categories']); exit;
                
                $data['page_heading'] = 'Customize Package';
                $data['erase_cache'] = true;
                $data['no_of_people'] = $no_of_people;
                $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
                $this->load->view($this->config->item('frontend_folder_name') . '/live_package_detail');
                $this->load->view($this->config->item('frontend_folder_name') . '/footer');
            } else if ($no_of_people > 100) {
                $this->session->set_userdata('error_message', 'For more info please email' . $this->config->item('website_email'));
                redirect(site_url('package'));
                exit;
            } else {
                $this->session->set_userdata('error_message', 'You have entered less no of people for this package');
                redirect(site_url('package'));
                exit;
            }
        } else {
            redirect(site_url('package'));
            exit;
        }
    }

//    public function getPackgeDetail($package_id, $no_of_people) {
//        if ($no_of_people > 100) {
//            $this->session->set_userdata('packageErrorMessage', 'For more info please email info@a1sweets.com');
//            redirect(site_url('package'));
//            exit;
//        }
//        $min_people = $this->common_model->getSingleFieldFromAnyTable('min_order_amount', 'package_id', $packageId, 'tbl_packages');
//        if ($no_of_people < $min_people) {
//            redirect(site_url('package'));
//            exit;
//        } else {
//            $data['breadcrumb'] = 'package';
//            $data['page_name'] = 'package';
//            $data['eraseCache'] = true;
//            $data['no_of_people'] = $no_of_people;
//            $data['package_detail'] = $this->package->getPackageRecordsById($packageId);
//            $data['pkg_category_data'] = $this->package->getAllPackageCategory();
//            $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
//            $this->load->view($this->config->item('frontend_folder_name') . '/package_detail');
//            $this->load->view($this->config->item('frontend_folder_name') . '/footer');
//        }
//    }
}
