<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cart extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('shopping_folder_name') . '/cart_model', 'cart');
        $this->load->model('locations_model', 'locations');
        $this->load->model('category_model', 'category');
        $this->load->model('live_catering_model', 'livecatering');
        $this->load->model('packages_model', 'packages');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['page_heading'] = 'Shopping Cart';
        $data['cart_data'] = $cart_data = $this->cart->get_cart_detail();
        if (empty($cart_data)) {
            redirect(site_url('online-order'));
            exit;
        }
        $data['cart_products_data'] = $this->cart->get_cart_products();
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('shopping_folder_name') . '/cart');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

    public function cart_package_products($cart_product_id) {
        $data['page_heading'] = 'Package Products';
        $data['cart_package_products'] = $cart_data = $this->cart->get_cart_package_products($cart_product_id);
        $this->load->view($this->config->item('shopping_folder_name') . '/cart_package_products', $data);
    }

    public function checkout() {
        $data['cart_data'] = $cart_data = $this->cart->get_cart_detail();
        // print_r($cart_data);die;
        if (empty($cart_data)) {
            redirect(site_url('online-order'));
            exit;
        }
        if (!empty($_POST)) {
            // echo '<pre>';print_r($_POST);die;
            $cart_id = ($cart_data['cart_id']) ? $cart_data['cart_id'] : FALSE;
            $this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('phone', 'Phone', 'trim|required');
            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
            $this->form_validation->set_rules('address', 'Address', 'trim|required');
            $this->form_validation->set_rules('city', 'City', 'trim|required');
            $this->form_validation->set_rules('comments', 'Comments', 'trim|required');
            $this->form_validation->set_rules('date', 'Date', 'trim|required');
            $this->form_validation->set_rules('time', 'Time', 'trim|required');
            //  $this->form_validation->set_rules('delivery_location', 'Delivery Location', 'trim|required');
            $this->form_validation->set_rules('payment_type', 'Payment Type', 'trim|required');
            $this->form_validation->set_rules('cart_type', 'Cart Type', 'trim|required');
            $this->form_validation->set_rules('notice_time', 'Time Notice', 'trim|required');
            if ($this->form_validation->run()) {
                $delivery_location = $this->input->post('cart_type') == 'pickup' ? $this->input->post('order_location') : $this->input->post('delivery_location');
                $cart_data = array(
                    'cart_sess_id' => $this->session->userdata('session_id'),
                    'cart_cus_name' => $this->input->post('name'),
                    'cart_cus_email' => $this->input->post('email'),
                    'cart_cus_phone' => $this->input->post('phone'),
                    'cart_cus_address' => $this->input->post('address'),
                    'cart_cus_city' => $this->input->post('city'),
                    'cart_cus_comments' => $this->input->post('comments'),
                    'cart_del_date' => strtotime($this->input->post('date')),
                    'cart_del_time' => strtotime($this->input->post('time')),
                    'cart_type' => $this->input->post('cart_type'),
                    'cart_pay_type' => $this->input->post('payment_type'),
                    'cart_del_loc_fk' => $delivery_location,
                );
                $this->cart->update_cart($cart_data, $cart_id);
                $this->update_cart_price(FALSE, FALSE, $delivery_location);
                $data['cart_data'] = $this->cart->get_cart_detail();
                $data['page_heading'] = 'Order Confirmation';
                $data['cart_products_data'] = $this->cart->get_cart_products();
                $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
                $this->load->view($this->config->item('shopping_folder_name') . '/order_confirmation');
                $this->load->view($this->config->item('frontend_folder_name') . '/footer');
            } else {
                $this->session->set_userdata('order_process_active', FALSE);
                $this->session->set_flashdata('order_submit_error', 'There is some error in form.');
                redirect($_SERVER['HTTP_REFERER']);
                exit;
            }
        } else {
            $data['page_heading'] = 'Checkout';
            $data['pickup_locations_list'] = $this->locations->get_locations_list();
            $data['delivery_locations_list'] = $this->locations->get_locations_list();
            $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
            $this->load->view($this->config->item('shopping_folder_name') . '/checkout');
            $this->load->view($this->config->item('frontend_folder_name') . '/footer');
        }
    }

    public function add_cart_product() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('product_id', 'Product Name', 'trim|required');
            $this->form_validation->set_rules('product_attribute[]', 'Product Attribute', 'trim|required');
            $this->form_validation->set_rules('product_quantity[]', 'Product Quantity', 'trim|required');
            if ($this->form_validation->run()) {
                $product_attribute = $this->input->post('product_attribute');
                $product_quantity = $this->input->post('product_quantity');
                $product_note = $this->input->post('product_note');
                $product_id = $this->input->post('product_id');
                foreach ($product_attribute as $key => $prd_attr_id) {
                    $new_product_quantity = $product_quantity[$key];
                    $previous_cart_product_id = FALSE;
                    $check_product_existence = $this->cart->check_product_existence($product_id, $prd_attr_id);
                    if (isset($check_product_existence) && !empty($check_product_existence)) {
                        $new_product_quantity+=$check_product_existence['cart_prd_quantity'];
                        $previous_cart_product_id = $check_product_existence['cart_prd_id'];
                    }
                    $product_detail = $this->category->get_product_detail($product_id, $prd_attr_id);
                    
                    
                    
                    if(empty($product_detail['prd_attr_people']))
                         $product_detail['prd_attr_people']=0;
                    
                    
                    $cart_product_data = array(
                        'cart_prd_sess_id' => $this->session->userdata('session_id'),
                        'cart_prd_cat_fk' => $product_detail['cat_id'],
                        'cart_prd_fk' => $product_detail['prd_id'],
                        'cart_prd_attr_fk' => $product_detail['prd_attr_id'],
                        'cart_prd_cat_name' => $product_detail['cat_name'],
                        'cart_prd_name' => $product_detail['prd_name'],
                        'cart_prd_note' => $product_note,
                        'cart_prd_price' => $product_detail['prd_attr_price'],
                        'cart_prd_quantity' => $new_product_quantity,
                        'cart_prd_tot_price' => ($new_product_quantity * $product_detail['prd_attr_price']),
                        'cart_prd_unit' => $product_detail['prd_attr_value'],
                        'cart_prd_people' => $product_detail['prd_attr_people'],
                        'cart_prd_type' => 'product',
                    );
                    $this->cart->add_cart_product($cart_product_data, $previous_cart_product_id);
                }
                $this->update_cart_price();
                redirect($_SERVER['HTTP_REFERER']);
                exit;
//                $data = array(
//                    'sidebar_cart_content' => $this->load->view($this->config->item('shopping_folder_name') . '/sidebar_cart', null, true),
//                );
//                return $this->output->set_header("HTTP/1.0 200 OK")->set_content_type('application/json')->set_output(json_encode($data));
            } else {
                redirect($_SERVER['HTTP_REFERER']);
                exit;
            }
        } else {
            echo 'false';
        }
    }


    //changes done 
    
    public function add_cart_live_catering_product(){
        
        if (!empty($_POST)) {
            $package_id = $this->input->post('package_id');
            $no_of_people = $this->input->post('no_of_people');
            $package_detail = $this->livecatering->get_package_detail($package_id);
            if ($no_of_people < $package_detail['package_min_people']) {
                $this->session->set_flashdata('package_error', 'Minimum number of people for package should be ' . $package_detail['package_min_people']);
                redirect($_SERVER['HTTP_REFERER']);
                exit;
            }
            $selected_package_products = $this->input->post('package_products');
            $total_additional_price = 0;
            $package_products_quantity = $this->input->post('package_product_quantity');
            foreach ($selected_package_products as $key => $product_id) {
                $product_detail = $this->livecatering->get_package_attributes_by_prd_id($package_id, $product_id, $no_of_people);
                if ($product_detail['pkg_attr_type'] == 'default')
                    $product_price = '0';
                else
                    $product_price = $product_detail['pkg_attr_price'];
                if ($product_detail['pkg_attr_upgradable'] == 'no')
                    $product_quantity = $no_of_people;
                else if ($product_detail['pkg_attr_upgradable'] == 'yes')
                    $product_quantity = $package_products_quantity[$key];
                if ($product_quantity != '') {
                    if ($product_quantity >= $product_detail['min_people']) {
                        $total_product_price = $product_quantity * $product_price;
                        $all_package_products[] = array(
                            'cart_pkg_prd_name' => $product_detail['prd_name'],
                            'cart_pkg_prd_fk' => $product_detail['prd_id'],
                            'cart_pkg_cat_fk' => $product_detail['cat_id'],
                            'cart_pkg_cat_name' => $product_detail['cat_name'],
                            'cart_pkg_prd_price' => $product_price,
                            'cart_pkg_prd_type' => $product_detail['pkg_attr_type'],
                            'cart_pkg_prd_quantity' => $product_quantity,
                            'cart_pkg_prd_tot_price' => $total_product_price,
                        );
                        $total_additional_price+=$total_product_price;
                    }
                }
            }
            $cart_product_data = array(
                'cart_prd_sess_id' => $this->session->userdata('session_id'),
                'cart_prd_fk' => $package_id,
                'cart_prd_name' => $package_detail['package_name'],
                'cart_prd_price' => $package_detail['package_price'] * $no_of_people + $total_additional_price,
                'cart_prd_quantity' => 1,
                'cart_prd_tot_price' => $package_detail['package_price'] * $no_of_people + $total_additional_price,
                'cart_prd_people' => $no_of_people,
                'cart_prd_type' => 'package',
            );
            $cart_product_id = $this->cart->add_cart_product($cart_product_data);
            foreach ($all_package_products as $k => $v) {
                $all_package_products[$k]['cart_pkg_cart_prd_fk'] = $cart_product_id;
            }
            $this->cart->add_cart_package_product($all_package_products, $cart_product_id);
            $this->update_cart_price();
            $this->session->set_userdata('package_success_message', 'Your Package has been successfully added to cart.');
            redirect('package');
            exit();
        }
    }
    
    
    
    //end changes

    public function add_cart_Package_product() {
        if (!empty($_POST)) {
            $package_id = $this->input->post('package_id');
            $no_of_people = $this->input->post('no_of_people');
            $package_detail = $this->packages->get_package_detail($package_id);
            if ($no_of_people < $package_detail['package_min_people']) {
                $this->session->set_flashdata('package_error', 'Minimum number of people for package should be ' . $package_detail['package_min_people']);
                redirect($_SERVER['HTTP_REFERER']);
                exit;
            }
            $selected_package_products = $this->input->post('package_products');
            $total_additional_price = 0;
            $package_products_quantity = $this->input->post('package_product_quantity');
            foreach ($selected_package_products as $key => $product_id) {
                $product_detail = $this->packages->get_package_attributes_by_prd_id($package_id, $product_id, $no_of_people);
                if ($product_detail['pkg_attr_type'] == 'default')
                    $product_price = '0';
                else
                    $product_price = $product_detail['pkg_attr_price'];
                if ($product_detail['pkg_attr_upgradable'] == 'no')
                    $product_quantity = $no_of_people;
                else if ($product_detail['pkg_attr_upgradable'] == 'yes')
                    $product_quantity = $package_products_quantity[$key];
                if ($product_quantity != '') {
                    if ($product_quantity >= $product_detail['min_people']) {
                        $total_product_price = $product_quantity * $product_price;
                        $all_package_products[] = array(
                            'cart_pkg_prd_name' => $product_detail['prd_name'],
                            'cart_pkg_prd_fk' => $product_detail['prd_id'],
                            'cart_pkg_cat_fk' => $product_detail['cat_id'],
                            'cart_pkg_cat_name' => $product_detail['cat_name'],
                            'cart_pkg_prd_price' => $product_price,
                            'cart_pkg_prd_type' => $product_detail['pkg_attr_type'],
                            'cart_pkg_prd_quantity' => $product_quantity,
                            'cart_pkg_prd_tot_price' => $total_product_price,
                        );
                        $total_additional_price+=$total_product_price;
                    }
                }
            }
            $cart_product_data = array(
                'cart_prd_sess_id' => $this->session->userdata('session_id'),
                'cart_prd_fk' => $package_id,
                'cart_prd_name' => $package_detail['package_name'],
                'cart_prd_price' => $package_detail['package_price'] * $no_of_people + $total_additional_price,
                'cart_prd_quantity' => 1,
                'cart_prd_tot_price' => $package_detail['package_price'] * $no_of_people + $total_additional_price,
                'cart_prd_people' => $no_of_people,
                'cart_prd_type' => 'package',
            );
            $cart_product_id = $this->cart->add_cart_product($cart_product_data);
            foreach ($all_package_products as $k => $v) {
                $all_package_products[$k]['cart_pkg_cart_prd_fk'] = $cart_product_id;
            }
            $this->cart->add_cart_package_product($all_package_products, $cart_product_id);
            $this->update_cart_price();
            $this->session->set_userdata('package_success_message', 'Your Package has been successfully added to cart.');
            redirect('package');
            exit();
        }
    }

    public function apply_coupon() {
        $data['cart_data'] = $cart_data = $this->cart->get_cart_detail();
        if (empty($cart_data)) {
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
        if (!empty($_POST)) {
            $this->form_validation->set_rules('coupon_code', 'Coupon Code', 'trim|required');
            if ($this->form_validation->run()) {
                $cart_products_total = $this->cart->get_cart_products_total();
                $cart_products_total = $cart_products_total['cart_prd_tot_price'];
                $coupon_data = $this->common_model->get_coupon_detail($cart_products_total);
                if ($coupon_data) {
                    if ($coupon_data['cpn_status'] == 'inactive') {
                        $this->session->set_flashdata('cart_coupon_messages', 'This Coupon code is inactivated now.');
                        redirect($_SERVER['HTTP_REFERER']);
                        exit;
                    }
                    if ($coupon_data['cpn_exp_date'] <= time()) {
                        $this->session->set_flashdata('cart_coupon_messages', 'This Coupon code Got Expired Now.');
                        redirect($_SERVER['HTTP_REFERER']);
                        exit;
                    }
                    if ($cart_products_total < $coupon_data['cpn_min_price']) {
                        $this->session->set_flashdata('cart_coupon_messages', 'Your Amount Should be greater than ' . $coupon_data->minimum_order_amount);
                        redirect($_SERVER['HTTP_REFERER']);
                        exit;
                    }
                    $discounted_amount = 0;
                    if ($coupon_data['cpn_type'] == 'percentage') {
                        $coupon_percentage = $coupon_data['cpn_discount'];
                        $discounted_amount = $cart_products_total * ($coupon_data['cpn_discount'] / 100);
                    } else if ($coupon_data['coupon_type'] == 'money') {
                        $coupon_percentage = 0;
                        $discounted_amount = $coupon_data['cpn_discount'];
                    }
                    $coupon_data = array(
                        'cpn_id' => $coupon_data['cpn_id'],
                        'cpn_code' => $coupon_data['cpn_code'],
                        'cpn_discount' => $discounted_amount,
                        'cpn_per' => $coupon_percentage,
                    );
                    $this->update_cart_price($coupon_data);
                    $this->session->set_flashdata('cart_coupon_messages', 'Congratulations! Your Coupon Code Has Been Applied Successfully.');
                    redirect($_SERVER['HTTP_REFERER']);
                    exit;
                } else {
                    $this->session->set_flashdata('cart_coupon_messages', 'This is not valid coupon code.');
                    redirect($_SERVER['HTTP_REFERER']);
                    exit;
                }
            } else {
                $this->session->set_flashdata('cart_coupon_messages', 'This is not valid coupon code.');
                redirect($_SERVER['HTTP_REFERER']);
                exit;
            }
        } else {
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

    public function empty_cart() {
        $this->cart->delete_cart();
        $this->cart->delete_cart_product();
        $this->cart->delete_cart_package_product();
        redirect($_SERVER['HTTP_REFERER']);
        exit;
    }

    public function update_product_quantity() {
        $cart_product_id = $this->input->post('cart_product_id');
        $cart_product_quantity = $this->input->post('cart_product_quantity');
        $cart_product_detail = $this->cart->get_cart_product_detail($cart_product_id);
        if ($cart_product_detail) {
            if ($cart_product_quantity) {
                $cart_product_data = array(
                    'cart_prd_quantity' => $cart_product_quantity,
                    'cart_prd_tot_price' => $cart_product_detail['cart_prd_price'] * $cart_product_quantity,
                );
                $this->cart->add_cart_product($cart_product_data, $cart_product_id);
            } else {
                $this->cart->delete_cart_product($cart_product_id);
            }
            $redirection_link = $this->update_cart_price();
			$cart_detail = $this->cart->get_cart_detail();
            $data = array(
                'sidebar_cart_html' => $this->load->view($this->config->item('shopping_folder_name') . '/sidebar_cart', null, true),
                'cart_products_count' => $this->common_model->total_cart_products(),
                'cart_products_total' => $cart_detail['cart_prd_total']
            );
            if ($redirection_link)
                $data['redirect'] = site_url('online-order');
            return $this->output->set_header("HTTP/1.0 200 OK")->set_content_type('application/json')->set_output(json_encode($data));
        } else {
            echo 'false';
        }
    }

    public function update_cart_price($coupon_data = '', $tax_location = FALSE, $delivery_location = FALSE) {
        if (!$tax_location) {
            if ($this->session->userdata('user_location_id'))
                $tax_location = $this->session->userdata('user_location_id');
            else
                $tax_location = $this->config->item('website_default_location');
        }
        $cart_products_total = $this->cart->get_cart_products_total();
        $cart_products_total = $cart_products_total['cart_prd_tot_price'];
        if (!$cart_products_total) {
            $this->cart->delete_cart();
            $this->cart->delete_cart_product();
            $this->cart->delete_cart_package_product();
            return true;
        }
        $cart_data = $this->cart->get_cart_detail();
        $cart_id = ($cart_data['cart_id']) ? $cart_data['cart_id'] : FALSE;
        /* -----------------------------Coupon Start -------------------------------- */
        $cart_cpn_discount = 0;
        $cart_cpn_id = 0;
        $cart_cpn_code = '';
        $cart_type = '';
        $cart_cpn_per = 0;
        if ($coupon_data) {
            $cart_cpn_discount = $coupon_data['cpn_discount'];
            $cart_cpn_id = $coupon_data['cpn_id'];
            $cart_cpn_code = $coupon_data['cpn_code'];
            $cart_cpn_per = $coupon_data['cpn_per'];
        } else if ($cart_data) {
            if ($cart_data['cart_cpn_per'] != 0)
                $cart_cpn_discount = (($cart_products_total * $cart_data['cart_cpn_per']) / 100);
            else
                $cart_cpn_discount = $cart_data['cart_cpn_discount'];
            $cart_cpn_id = $cart_data['cart_cpn_id'];
            $cart_cpn_code = $cart_data['cart_cpn_code'];
            $cart_cpn_per = $cart_data['cart_cpn_per'];
        }
        /* ------------------------Coupon End-------------------------- */
        /* ----------------------Delivery Charges Start------------------------------- */
        $cart_del_charges = 0;
        $cart_del_loc_id = 0;
        $cart_del_loc_name = '';
        if ($cart_data) {
            $cart_del_charges = $cart_data['cart_del_charges'];
            $cart_del_loc_id = $cart_data['cart_del_loc_fk'];
            $cart_del_loc_name = $cart_data['cart_del_loc_name'];
        }

        if ($delivery_location) {
            $delivery_location_detail = $this->locations->get_location_detail(FALSE, $delivery_location, FALSE);
            if ($delivery_location_detail) {
                if ($this->input->post('cart_type') == 'delivery') {
                    if ($delivery_location_detail['loc_min_order'] > $cart_products_total) {
                        $this->session->set_userdata('cart_error_message', 'Your order value should be greater than $' . $delivery_location_detail['loc_min_order'] . ' For Delivery In ' . $delivery_location_detail['loc_name'] . '.');
                        redirect(site_url('cart'));
                        exit;
                    }
                    $cart_del_charges = $delivery_location_detail['loc_del_charges'];
                } else {
                    $cart_del_charges = 0;
                }
                $cart_del_loc_id = $delivery_location_detail['loc_id'];
                $cart_del_loc_name = $delivery_location_detail['loc_name'];
            }
        }
        /* ------------------------Delivery Charges End-------------------------- */
        /* ----------------------Cart Tax Calculations------------------------------- */
        $gst_per = 0;
        $pst_per = 0;
        $hst_per = 0;
        $cart_ord_loc_id = 0;
        $cart_ord_loc_name = '';
        $tax_location_detail = $this->locations->get_location_detail(FALSE, $tax_location, FALSE);
        if ($tax_location_detail) {
            $gst_per = $tax_location_detail['loc_gst'];
            $pst_per = $tax_location_detail['loc_pst'];
            $hst_per = $tax_location_detail['loc_hst'];
            $cart_ord_loc_name = $tax_location_detail['loc_name'];
            $cart_ord_loc_id = $tax_location;
        }

        /* ------------------------Cart Tax Calculations End-------------------------- */
        $cart_discounted_total = $cart_products_total - $cart_cpn_discount;
        $cart_gst = number_format((($cart_discounted_total * $gst_per) / 100), 2, '.', '');
        $cart_pst = number_format((($cart_discounted_total * $pst_per) / 100), 2, '.', '');
        $cart_hst = number_format((($cart_discounted_total * $hst_per) / 100), 2, '.', '');
        $cart_total = number_format(($cart_discounted_total + $cart_del_charges + $cart_gst + $cart_pst + $cart_hst), 2, '.', '');
        $cart_data = array(
            'cart_sess_id' => $this->session->userdata('session_id'),
            'cart_prd_total' => $cart_products_total,
            'cart_cpn_per' => $cart_cpn_per,
            'cart_cpn_fk' => $cart_cpn_id,
            'cart_cpn_code' => $cart_cpn_code,
            'cart_cpn_discount' => $cart_cpn_discount,
            'cart_del_charges' => $cart_del_charges,
            'cart_ord_loc_name' => $cart_ord_loc_name,
            'cart_ord_loc_fk' => $cart_ord_loc_id,
            'cart_del_loc_name' => $cart_del_loc_name,
            'cart_del_loc_fk' => $cart_del_loc_id,
            'cart_gst' => $cart_gst,
            'cart_pst' => $cart_pst,
            'cart_hst' => $cart_hst,
            'cart_gst_per' => $gst_per,
            'cart_pst_per' => $pst_per,
            'cart_hst_per' => $hst_per,
            'cart_total' => $cart_total,
        );
        $this->cart->update_cart($cart_data, $cart_id);
    }
    public function delete_pkg_product() {
        $cart_product_id = $this->input->post('cart_product_id');
        $cart_product_quantity = $this->input->post('cart_product_quantity');
        if($cart_product_id){
            $this->cart->delete_cart_pkg_product($cart_product_id);
            $data = array(
                'sidebar_cart_html' => $this->load->view($this->config->item('shopping_folder_name') . '/sidebar_package_cart', null, true),
                'cart_products_count' => $this->common_model->total_cart_products()
            );
            echo 'true';
        } else {
            echo 'false';
        }
    }
}