<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Users extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('users_model', 'user');
        $this->load->model('mailsending_model', 'mailer');
        $this->load->library('form_validation');
        $this->load->library('recaptcha');
    }

    public function contact_us() {
        if (!empty($_POST)) {
            $this->recaptcha->recaptcha_check_answer($_SERVER['REMOTE_ADDR'], $this->input->post('recaptcha_challenge_field'), $this->input->post('recaptcha_response_field'));
            $this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('email', 'Email Id', 'trim|required|valid_email');
            $this->form_validation->set_rules('phone', 'Phone No', 'trim|required');
            if ($this->form_validation->run() && $this->recaptcha->getIsValid()) {
                $this->user->create_new_user('inquiry');
                $this->mailer->global_mail(4);
                $this->session->set_userdata('success_message', 'Thanks for your query/Feedback. Our team will get back to you within 24 hours.');
                redirect(site_url('inquiry'));
                exit();
            } else if (!$this->recaptcha->getIsValid()) {
                $data['captcha_error'] = "The characters you entered didn't match the word verification. Please try again. ";
                $data['name'] = $this->input->post('name');
                $data['email'] = $this->input->post('email');
                $data['phone'] = $this->input->post('phone');
                $data['comment'] = $this->input->post('comment');
                $this->session->set_userdata('error_message', 'There Is Some Error');
            }
        }
        $data['page_heading'] = 'Inquiry';
        $data['recaptcha_html'] = $this->recaptcha->recaptcha_get_html();
        $this->load->view($this->config->item('frontend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('frontend_folder_name') . '/contact_us');
        $this->load->view($this->config->item('frontend_folder_name') . '/footer');
    }

    public function newsletter_subscribe() {
        if (!empty($_POST)) {
            //$this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('email', 'Email Id', 'trim|required');
            if ($this->form_validation->run()) {
                $this->user->create_new_user('subscriber');
                $this->mailer->global_mail(3);
                $message = "You have Subscribed to Our newsletter successfully.";
            } else {
                $message = validation_errors('', '');
            }
            echo json_encode(strip_tags($message));
        }
    }

}
