<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Category_Model extends CI_Model {

    var $tableName = 'tbl_category'; 

    function get_category_list($typeId) {
        $this->db->where($this->tableName . '.cat_status !=', 'deleted');       
        $this->db->where($this->tableName . '.cat_type_fk', $typeId);       
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }  
    
    function add_category($cat_type_id,$cat_image) {
        if ($cat_image)
            $this->db->set('cat_image', $cat_image);
        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('cat_name'), $this->tableName,'cat_slug');
        $this->db->set('cat_slug', $slug);
        if ($this->config->item('website_multi_location') == 'yes')
        $this->db->set('cat_loc_fk', $this->input->post('location_id'));  
        $this->db->set('cat_type_fk', $cat_type_id);
        $this->db->set('cat_name', $this->input->post('cat_name'));  
        $this->db->set('cat_content', $this->input->post('cat_content'));  
        $this->db->set('cat_title', $this->input->post('cat_title'));
        $this->db->set('cat_keywords', $this->input->post('cat_keywords'));
        $this->db->set('cat_description', $this->input->post('cat_description'));     
        $this->db->set('cat_status', 'active');
        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $this->db->insert_id();
    }

    function update_category($catId, $cat_image) {
        if ($cat_image)
            $this->db->set('cat_image', $cat_image);
        $this->db->set('cat_name', $this->input->post('cat_name'));  
        if ($this->config->item('website_multi_location') == 'yes')
        $this->db->set('cat_loc_fk', $this->input->post('location_id'));  
        $this->db->set('cat_content', $this->input->post('cat_content'));  
        $this->db->set('cat_title', $this->input->post('cat_title'));
        $this->db->set('cat_keywords', $this->input->post('cat_keywords'));
        $this->db->set('cat_description', $this->input->post('cat_description'));    
        $this->db->where('cat_id', $catId);
        $query = $this->db->update($this->tableName);
        return $response;
    }
    
    public function update_status($catId, $action) {
        $this->db->set('cat_status', $action);
        $this->db->where('cat_id', $catId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

}
