<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Meta_Tag_Model extends CI_Model {

    var $meta_tag_table = 'tbl_meta_tags';

    function get_meta_tag_list() {
        $this->db->select('*');
        $this->db->from($this->meta_tag_table);
        $this->db->where($this->meta_tag_table . '.meta_tag_status !=', 'deleted');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    function get_meta_tag_detail($meta_tag_id) {
        $this->db->select('*');
        $this->db->from($this->meta_tag_table);
        $this->db->where($this->meta_tag_table . '.meta_tag_status !=', 'deleted');
        $this->db->where($this->meta_tag_table . '.meta_tag_id', $meta_tag_id);
        $query = $this->db->get();
        $result = $query->row_array();
        return $result;
    }

    function add_meta_tag($meta_tag_image) {
        if ($meta_tag_image)
            $this->db->set('meta_tag_image', $meta_tag_image);
        $this->db->set('meta_tag_url', $this->input->post('meta_tag_url'));
        $this->db->set('meta_tag_title', $this->input->post('meta_tag_title'));
        $this->db->set('meta_tag_keywords', $this->input->post('meta_tag_keywords'));
        $this->db->set('meta_tag_description', $this->input->post('meta_tag_description'));
        $this->db->set('meta_tag_status', 'active');
        return $this->db->insert($this->meta_tag_table);
    }

    function update_meta_tag($meta_tag_id, $meta_tag_image) {
        if ($meta_tag_image)
            $this->db->set('meta_tag_image', $meta_tag_image);
        $this->db->set('meta_tag_url', $this->input->post('meta_tag_url'));
        $this->db->set('meta_tag_title', $this->input->post('meta_tag_title'));
        $this->db->set('meta_tag_keywords', $this->input->post('meta_tag_keywords'));
        $this->db->set('meta_tag_description', $this->input->post('meta_tag_description'));
        $this->db->where('meta_tag_id', $meta_tag_id);
        return $this->db->update($this->meta_tag_table);
    }

    public function update_status($meta_tag_id, $meta_tag_status) {
        $this->db->set('meta_tag_status', $meta_tag_status);
        $this->db->where('meta_tag_id', $meta_tag_id);
        $response = $this->db->update($this->meta_tag_table);
        return $response;
    }

}
