<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Nav_Menu_Model extends CI_Model {

    var $tableName = 'tbl_nav_menu';
    var $tableNavGrups = 'tbl_nav_groups';

    function get_nav_list($grupId) {
        $this->db->where($this->tableName . '.nav_menu_nav_grp_fk', $grupId); 
        $this->db->where($this->tableName . '.nav_menu_status !=', 'deleted');     
           
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }    

    function add_nav_menu($grupId) {
        $this->db->set('nav_menu_nav_grp_fk', $grupId);
        $this->db->set('nav_menu_title', $this->input->post('nav_menu_title'));
        $this->db->set('nav_menu_url', $this->input->post('nav_menu_url'));
        $this->db->set('nav_menu_position', $this->input->post('nav_menu_position'));        
        $this->db->set('nav_menu_parent_fk', $this->input->post('nav_menu_parent_fk'));
        $this->db->set('nav_menu_parent', $this->input->post('nav_menu_parent'));
        
        $this->db->set('nav_menu_status', 'active');
        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }


    function update_nav_menu($navMenuId) {
        $this->db->set('nav_menu_title', $this->input->post('nav_menu_title'));
        $this->db->set('nav_menu_url', $this->input->post('nav_menu_url'));
        $this->db->set('nav_menu_position', $this->input->post('nav_menu_position'));    
        $this->db->set('nav_menu_parent_fk', $this->input->post('nav_menu_parent_fk'));
        $this->db->set('nav_menu_parent', $this->input->post('nav_menu_parent'));
        
        $this->db->where('nav_menu_id', $navMenuId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    function update_status($navMenuId, $status) {
        $this->db->set('nav_menu_status', $status);
        $this->db->where('nav_menu_id', $navMenuId);
        $response = $this->db->update($this->tableName);
       return $response;
    }

}
