<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Product_Model extends CI_Model {

    var $products_table = 'tbl_products';
    var $category_table = 'tbl_category';
    var $product_attributes_table = 'tbl_product_attributes';

    function get_product_list($category_type_id = FALSE, $category_id = FALSE) {
        $this->db->select('*');
        $this->db->from($this->products_table);
        $this->db->where($this->products_table . '.prd_status !=', 'deleted');
        $this->db->join($this->category_table, $this->products_table . '.prd_cat_fk=' . $this->category_table . '.cat_id');
        if ($category_type_id)
            $this->db->where($this->category_table . '.cat_type_fk', $category_type_id);
        if ($category_id)
            $this->db->where($this->products_table . '.prd_cat_fk', $category_id);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    function get_product_counts($category_type_id = FALSE) {
        $this->db->where($this->products_table . '.prd_status !=', 'deleted');
        $this->db->join($this->category_table, $this->products_table . '.prd_cat_fk=' . $this->category_table . '.cat_id');
        if ($category_type_id)
            $this->db->where($this->category_table . '.cat_type_fk', $category_type_id);
        $query = $this->db->get($this->products_table);
        $result = $query->num_rows();
        return $result;
    }

    function get_product_detail($product_id) {
        $this->db->select('*');
        $this->db->from($this->products_table);
        $this->db->where($this->products_table . '.prd_status !=', 'deleted');
        $this->db->where($this->products_table . '.prd_id', $product_id);
        $query = $this->db->get();
        $result = $query->row_array();
        return $result;
    }

    function add_product($product_image) {
        if ($product_image)
            $this->db->set('prd_image', $product_image);
        if ($this->input->post('prd_label_fk'))
            $this->db->set('prd_label_fk', implode(',', $this->input->post('prd_label_fk')));
        else
            $this->db->set('prd_label_fk', 0);
        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('prd_name'), $this->products_table, 'prd_slug');
        $this->db->set('prd_slug', $slug);
        $this->db->set('prd_cat_fk', $this->input->post('prd_cat_fk'));
        $this->db->set('prd_name', $this->input->post('prd_name'));
        $this->db->set('prd_content', $this->input->post('prd_content'));
        $this->db->set('prd_sku', $this->input->post('prd_sku'));
        $this->db->set('prd_price', $this->input->post('prd_price'));
//        $this->db->set('prd_title', $this->input->post('prd_title'));
//        $this->db->set('prd_keywords', $this->input->post('prd_keywords'));
//        $this->db->set('prd_description', $this->input->post('prd_description'));
        $this->db->set('prd_status', 'active');
        $query = $this->db->insert($this->products_table);
        $response = $this->db->insert_id();
        return $this->db->insert_id();
    }

    function update_product($product_id, $product_image) {
        if ($product_image)
            $this->db->set('prd_image', $product_image);
        if ($this->input->post('prd_label_fk'))
            $this->db->set('prd_label_fk', implode(',', $this->input->post('prd_label_fk')));
        else
            $this->db->set('prd_label_fk', 0);
        $this->db->set('prd_cat_fk', $this->input->post('prd_cat_fk'));
        $this->db->set('prd_name', $this->input->post('prd_name'));
        $this->db->set('prd_content', $this->input->post('prd_content'));
        $this->db->set('prd_sku', $this->input->post('prd_sku'));
        $this->db->set('prd_price', $this->input->post('prd_price'));
//        $this->db->set('prd_title', $this->input->post('prd_title'));
//        $this->db->set('prd_keywords', $this->input->post('prd_keywords'));
//        $this->db->set('prd_description', $this->input->post('prd_description'));
        $this->db->where('prd_id', $product_id);
        $query = $this->db->update($this->products_table);
        return $response;
    }

    public function update_status($product_id, $product_status) {
        $this->db->set('prd_status', $product_status);
        $this->db->where('prd_id', $product_id);
        $response = $this->db->update($this->products_table);
        return $response;
    }

    function add_product_attributes($product_id) {
        $product_attributes = $this->input->post('prd_attr_attr_fk');
        $prd_attr_attr_fk = $this->input->post('prd_attr_attr_fk');
        $prd_attr_value = $this->input->post('prd_attr_value');
        $prd_attr_price = $this->input->post('prd_attr_price');
        $prd_attr_people = $this->input->post('prd_attr_people');
        $prd_attr_status = $this->input->post('prd_attr_status');
        foreach ($product_attributes as $key => $product_attribute) {
            $this->db->set('prd_attr_prd_fk', $product_id);
            $this->db->set('prd_attr_attr_fk', $product_attribute);
            $this->db->set('prd_attr_value', $prd_attr_value[$key]);
            $this->db->set('prd_attr_people', $prd_attr_people[$key]);
            $this->db->set('prd_attr_price', $prd_attr_price[$key]);
            $this->db->set('prd_attr_status', $prd_attr_status[$key]);
            $query = $this->db->insert($this->product_attributes_table);
            $response = $this->db->insert_id();
        }
        return $response;
    }

    function get_product_attributes($product_id) {
        $this->db->where('prd_attr_prd_fk', $product_id);
        $query = $this->db->get($this->product_attributes_table);
        $result = $query->result();
        return $result;
    }

    public function delete_product_attributes($product_id) {
        $this->db->where('prd_attr_prd_fk', $product_id);
        $response = $this->db->delete($this->product_attributes_table);
        return $response;
    }

}
