<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Static_Page_Model extends CI_Model {

    var $tableName = 'tbl_static_pages';

     function get_page_list() {
        $this->db->where($this->tableName . '.static_page_status !=', 'deleted');       
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }   

    function add_page() {
        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('static_page_name'), $this->tableName,'static_page_slug');
        $this->db->set('static_page_slug', $slug);
       
        $this->db->set('static_page_name', $this->input->post('static_page_name'));
        $this->db->set('static_page_content', $this->input->post('static_page_content'));
        $this->db->set('static_page_title', $this->input->post('static_page_title'));
        $this->db->set('static_page_keywords', $this->input->post('static_page_keywords'));
        $this->db->set('static_page_description', $this->input->post('static_page_description'));  
         
        $this->db->set('static_page_status', 'active');

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $this->db->insert_id();
    }

    function update_page($pageId) {
     
        $this->db->set('static_page_name', $this->input->post('static_page_name'));
        $this->db->set('static_page_content', $this->input->post('static_page_content'));
        $this->db->set('static_page_title', $this->input->post('static_page_title'));
        $this->db->set('static_page_keywords', $this->input->post('static_page_keywords'));
        $this->db->set('static_page_description', $this->input->post('static_page_description')); 
        
        $this->db->where('static_page_id', $pageId);
        $query = $this->db->update($this->tableName);
        return $response;
    }
    
    public function update_status($pageId, $action) {
        $this->db->set('static_page_status', $action);
        $this->db->where('static_page_id', $pageId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

}
