<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Testimonial_Model extends CI_Model {

    var $tableName = 'tbl_testimonial';

    function get_testimonial_list() {   
        $this->db->where($this->tableName . '.testimonial_status !=', 'deleted');      
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }    

    function add($testimonial_image) {
        if ($testimonial_image)
            $this->db->set('testimonial_image', $testimonial_image);
     
        $this->db->set('testimonial_content', $this->input->post('testimonial_content'));
        $this->db->set('testimonial_user', $this->input->post('testimonial_user'));
        $this->db->set('testimonial_user_company', $this->input->post('testimonial_user_company')); 

        $this->db->set('testimonial_status', 'active');  
        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($testimonialId, $testimonial_image) {
        if ($testimonial_image)
            $this->db->set('testimonial_image', $testimonial_image);
     
        $this->db->set('testimonial_content', $this->input->post('testimonial_content'));
        $this->db->set('testimonial_user', $this->input->post('testimonial_user'));
        $this->db->set('testimonial_user_company', $this->input->post('testimonial_user_company')); 

        $this->db->where('testimonial_id', $testimonialId);
        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function update_status($testimonialId, $status) {
        $this->db->set('testimonial_status', $status);
        $this->db->where('testimonial_id', $testimonialId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

}
