<?php

class Common_Model extends CI_Model {

    public function __construct() {
        global $URI, $CFG, $IN;
        $ci = get_instance();
        $ci->load->config('config');
        define('TIMEZONE', 'America/New_York');
        @date_default_timezone_set(TIMEZONE);
        $dt = new DateTime();
        $offset = $dt->format("P");
        //mysql_query("SET time_zone='$offset';");
        $websiteData = $this->get_single_row_from_any_table('website_id', '1', 'tbl_website_settings');
        $ci->config->set_item('website_paypal_email', $websiteData->website_paypal_email);
        $ci->config->set_item('website_email', $websiteData->website_email);
        $ci->config->set_item('website_address', $websiteData->website_address);
	$ci->config->set_item('website_address2', $websiteData->website_address2);
	$ci->config->set_item('website_cod_note', $websiteData->website_cod_note);
	$ci->config->set_item('website_checkout_notice', $websiteData->website_checkout_notice);
        $ci->config->set_item('website_phone_number', $websiteData->website_phone_number);
        $ci->config->set_item('website_facebook_link', $websiteData->website_facebook_link);
        $ci->config->set_item('website_twitter_link', $websiteData->website_twitter_link);
        $ci->config->set_item('website_instagram_link', $websiteData->website_instagram_link);
        $ci->config->set_item('website_youtube_link', $websiteData->website_youtube_link);
        $ci->config->set_item('website_linkedin_link', $websiteData->website_linkedin_link);
        $ci->config->set_item('website_name', $websiteData->website_name);
        $ci->config->set_item('website_google_indexing', $websiteData->website_google_indexing);
        $ci->config->set_item('website_default_location', $websiteData->website_def_loc_fk);
        $ci->config->set_item('website_analytic_code', $websiteData->website_analytic_code);
        $ci->config->set_item('website_logo', $websiteData->website_logo);
        $ci->config->set_item('website_favicon', $websiteData->website_favicon);
        $ci->config->set_item('website_multi_location', $websiteData->website_multi_location);
        $ci->config->set_item('website_location_selector', $websiteData->website_location_selector);
       /* if(!$this->session->userdata('user_location_id') && $this->uri->segment(1)!='select-user-location' && $this->uri->segment(1)!='set-user-location' && $this->uri->segment(1)!=$this->config->item('backend_url')){
            redirect(site_url('select-user-location'));
            exit;
        }*/
    }

    function check_admin_login_session() {
        if (!$this->session->userdata('ADM_ID')) {
            redirect($this->config->config['backend_url'] . '/login');
            exit;
        } else {
            return true;
        }
    }

    function create_unique_slug_for_common($app_title, $table, $field_name) {
        $slug = url_title($app_title);
        $slug = strtolower($slug);
        $i = 0;
        $params = array();
        $params[$field_name] = $slug;
        while ($this->db->where($params)->get($table)->num_rows()) {
            if (!preg_match('/-{1}[0-9]+$/', $slug)) {
                $slug .= '-' . ++$i;
            } else {
                $slug = preg_replace('/[0-9]+$/', ++$i, $slug);
            }
            $params [$field_name] = $slug;
        }
        $app_title = $slug;
        return $app_title;
    }

    function get_single_field_from_any_table($field_name, $condition_coloum, $condition_value, $table_name) {
        $this->db->select($field_name);
        $this->db->where($condition_coloum, $condition_value);
        $query = $this->db->get($table_name);
        $data = $query->row();
        return $data->$field_name;
    }

    function get_single_row_from_any_table($condition_coloum, $condition_value, $table_name) {
        $this->db->select('*');
        $this->db->where($condition_coloum, $condition_value);
        $query = $this->db->get($table_name);
        $data = $query->row();
        return $data;
    }

    function get_count_all_from_any_table($condition_coloum, $condition_value, $table_name, $status) {
        $this->db->where($condition_coloum, $condition_value);
        if ($status)
            $this->db->where('status', $status);
        $query = $this->db->get($table_name);
        $nums = $query->num_rows();
        return $nums;
    }

    function get_fields_from_any_table($table_name, $order_coloum) {
        if ($order_coloum)
            $this->db->order_by($order_coloum, 'asc');
        $query = $this->db->get($table_name);
        $data = $query->result();
        return $data;
    }

    function get_fields_from_any_table_one_condition($condition_coloum, $condition_value, $table_name, $order_coloum) {
        $this->db->where($condition_coloum, $condition_value);
        if ($order_coloum)
            $this->db->order_by($order_coloum, 'asc');
        $query = $this->db->get($table_name);
        $data = $query->result();
        return $data;
    }

    function get_fields_from_any_table_two_condition($condition_coloum1, $condition_value1, $condition_coloum2, $condition_value2, $table_name, $order_coloum, $order_by, $status, $limit, $group_by) {
        $this->db->where($condition_coloum1, $condition_value1);
        if ($condition_coloum2)
            $this->db->where($condition_coloum2, $condition_value2);
        if ($status)
            $this->db->where('status', $status);
        if ($limit)
            $this->db->limit($limit);
        if ($order_coloum)
            $this->db->order_by($order_coloum, $order_by);
        if ($group_by)
            $this->db->group_by($group_by);
        $query = $this->db->get($table_name);
        $data = $query->result();
        return $data;
    }

    function get_static_content($static_page_slug = FALSE, $static_page_id = FALSE) {
        if ($static_page_slug)
            $this->db->where('tbl_static_pages.static_page_slug', $static_page_slug);
        if ($static_page_id)
            $this->db->where('tbl_static_pages.static_page_id', $static_page_id);
        $this->db->where('tbl_static_pages.static_page_status', 'active');
        $query = $this->db->get('tbl_static_pages');
        $data = $query->row_array();
        return $data;
    }

    function get_coupon_detail($cart_products_total = FALSE) {
        if ($this->session->userdata('user_location_id'))
            $this->db->where('tbl_coupons.cpn_loc_fk', $this->session->userdata('user_location_id'));
        $this->db->where('tbl_coupons.cpn_exp_date >', time());
        $this->db->where('tbl_coupons.cpn_status', 'active');
        if ($cart_products_total)
            $this->db->where('tbl_coupons.cpn_min_price <=', $cart_products_total);
        $this->db->where('tbl_coupons.cpn_code', $this->input->post('coupon_code'));
        $query = $this->db->get('tbl_coupons');
        $data = $query->row_array();
        return $data;
    }

    function get_banners($bnr_type = FALSE) {
        if ($bnr_type)
            $this->db->where('tbl_banner.bnr_type_fk', $bnr_type);
        $this->db->where('tbl_banner.bnr_status', 'active');
        $this->db->order_by('tbl_banner.bnr_order', 'asc');
        $query = $this->db->get('tbl_banner');
        $data = $query->result_array();
        return $data;
    }

    function get_navigations_menus($nav_group = FALSE) {
        if ($nav_group)
            $this->db->where('tbl_nav_menu.nav_menu_nav_grp_fk', $nav_group);
        $this->db->where('tbl_nav_menu.nav_menu_parent', 'yes');
        $this->db->where('tbl_nav_menu.nav_menu_status', 'active');
        $this->db->order_by('tbl_nav_menu.nav_menu_position', 'asc');
        $query = $this->db->get('tbl_nav_menu');
        $data = $query->result_array();
        return $data;
    }

    public function total_cart_products() {
        $this->db->where('cart_prd_sess_id', $this->session->userdata('session_id'));
        $query = $this->db->get('tbl_cart_products');
        $result = $query->num_rows();
        return $result;
    }

    function get_locations_list($location_type_id = FALSE, $location_for_site = TRUE) {
        $this->db->select('*');
        $this->db->where('tbl_locations.loc_status', 'active');
        $this->db->join('tbl_location_type', 'tbl_locations.loc_type_fk=tbl_location_type.loc_type_id');
        if ($location_for_site)
            $this->db->where('tbl_location_type.loc_for_site', 'yes');
        if ($location_type_id)
            $this->db->where('tbl_locations.loc_type_fk', $location_type_id);
        $this->db->where('tbl_location_type.loc_type_status', 'active');
        $query = $this->db->get('tbl_locations');
        $result = $query->result_array();
        return $result;
    }

    function get_meta_tags($current_url) {
        $this->db->select('*');
        $this->db->from('tbl_meta_tags');
        $this->db->where('tbl_meta_tags.meta_tag_status', 'active');
        $this->db->where('tbl_meta_tags.meta_tag_url', $current_url);
        $query = $this->db->get();
        $result = $query->row_array();
        return $result;
    }

}
