<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Live_catering_Model extends CI_Model {

    // var $packages_table = 'tbl_packages';
    // var $packages_attributes_table = 'tbl_package_attributes';
    var $packages_table = 'tbl_live_catering';
    var $packages_attributes_table = 'tbl_live_catering_attributes';
    var $products_table = 'tbl_products';
    var $category_table = 'tbl_category';

    function get_all_packages() {
        
        $this->db->where($this->packages_table . '.package_status !=', 'deleted');
        $query = $this->db->get($this->packages_table);
        $result = $query->result_array();
        return $result;
    }

    function get_package_detail($package_id) {
        $this->db->where('package_id', $package_id);
        $query = $this->db->get($this->packages_table);
        $result = $query->row_array();
        return $result;
    }

    function get_package_attributes_by_cat_id($package_id, $cat_id, $no_of_people) {
        $this->db->select('*');
        $this->db->where($this->packages_attributes_table . '.pkg_attr_cat_fk', $cat_id);
        $this->db->where($this->packages_attributes_table . '.pkg_attr_package_fk', $package_id);
        $this->db->where($this->packages_attributes_table . '.pkg_attr_status', 'active');
        $this->db->where($this->packages_attributes_table . '.pkg_attr_min_people <= ', $no_of_people);
        $this->db->join($this->products_table, $this->packages_attributes_table . '.pkg_attr_prd_fk=' . $this->products_table . '.prd_id');
        $this->db->where($this->products_table . '.prd_status', 'active');
        $this->db->order_by($this->packages_attributes_table . '.pkg_attr_type', 'DESC');
        $query = $this->db->get($this->packages_attributes_table);
        $result = $query->result_array();
        return $result;
    }

    function get_package_attributes_by_prd_id($package_id, $prd_id, $no_of_people) {
        $this->db->select('*');
        $this->db->where($this->packages_attributes_table . '.pkg_attr_prd_fk', $prd_id);
        $this->db->where($this->packages_attributes_table . '.pkg_attr_package_fk', $package_id);
        $this->db->where($this->packages_attributes_table . '.pkg_attr_status', 'active');
        $this->db->where($this->packages_attributes_table . '.pkg_attr_min_people <= ', $no_of_people);
        $this->db->join($this->products_table, $this->packages_attributes_table . '.pkg_attr_prd_fk=' . $this->products_table . '.prd_id');
        $this->db->where($this->products_table . '.prd_status', 'active');
        $this->db->join($this->category_table, $this->packages_attributes_table . '.pkg_attr_cat_fk=' . $this->category_table . '.cat_id');
        $this->db->where($this->category_table . '.cat_status', 'active');
        $this->db->order_by($this->packages_attributes_table . '.pkg_attr_type', 'DESC');
        $query = $this->db->get($this->packages_attributes_table);
        $result = $query->row_array();
        return $result;
    }

    function getPackageSpecificationsByCategoryPeople($packageId, $category_id, $no_of_people) {
        $this->db->where('package_id', $packageId);
        if ($no_of_people >= 100)
            $no_of_people = 99;
        $this->db->where('category_id', $category_id);
        $this->db->where('min_people <=', $no_of_people);
        $this->db->where('is_active', 'yes');
        $this->db->order_by('item_id', 'asc');
        $query = $this->db->get($this->tablePkgSpecification);

        $result = $query->result_array();
        return $result;
    }

    function getSpecificationsbyPackageAndItem($packageId, $selected_package_items) {
        $this->db->where('package_id', $packageId);
        $this->db->where('item_id', $selected_package_items);
        $this->db->where('is_active', 'yes');
        $query = $this->db->get($this->tablePkgSpecification);
        $result = $query->row_array();
        return $result;
    }

}
