<?php

class Mailsending_Model extends CI_Model {

    function __construct() {
        $this->mailtype = 'html';
        $this->load->model($this->config->item('shopping_folder_name') . '/order_model', 'order');
    }

    function get_template_detail($template_id) {
        $this->db->where('tbl_email_template.et_id', $template_id);
        $this->db->where('tbl_email_template.et_status', 'active');
        $query = $this->db->get('tbl_email_template');
        $result = $query->row_array();
        return $result;
    }

    function global_mail($template_id = FALSE) {
        $template_detail = $this->get_template_detail($template_id);
        $str = str_replace("{#client_name}", $this->input->post('name'), $template_detail['et_content']);
        $str = str_replace("{#client_email}", $this->input->post('email'), $str);
        $str = str_replace("{#client_phone}", $this->input->post('phone'), $str);
        $str = str_replace("{#client_message}", $this->input->post('comment'), $str);
        $this->email->from($template_detail['et_sender_email'], $template_detail['et_sender_name']);
        $this->email->to($template_detail['et_cc_emails']);
        $this->email->mailtype = $this->mailtype;
        $this->email->subject($template_detail['et_subject']);
        $this->email->message($str);
        if ($this->email->send()) {
            return true;
        } else {
            show_error($this->email->print_debugger());
        }
    }

    function order_mail($order_id) {
        $template_detail = $this->get_template_detail(1);
        $order_detail = $this->order->get_order_detail($order_id);
          //echo '<pre>';
              //      print_r($template_detail);die;
        $order_products = $this->order->get_order_products($order_id);
        
        // pr($order_items);die;
		$inc = 1;
        foreach ($order_products as $order_product) {
            if ($order_product['order_prd_type'] == 'product') {
				if($inc == 1)
				{
					$items.= '<table width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td width="49%" height="30" style=" background-image:url(http://64.77.51.231/~gurusindiancuisi/assets/email_images/heading_bg.jpg); padding-left:5px; color:#fff;"><b>Item Name</b></td><td width="14%" height="30" style=" background-image:url(http://64.77.51.231/~gurusindiancuisi/assets/email_images/heading_bg.jpg); color:#fff;"><strong>UNIT</strong></td><td width="17%" height="30" align="center" style=" background-image:url(http://64.77.51.231/~gurusindiancuisi/assets/email_images/heading_bg.jpg); color:#fff;"><b>Quantity</b></td><td width="4%" height="30" style=" background-image:url(http://64.77.51.231/~gurusindiancuisi/assets/email_images/heading_bg.jpg); color:#fff;">&nbsp;</td><td width="16%" height="30" style=" background-image:url(http://64.77.51.231/~gurusindiancuisi/assets/email_images/heading_bg.jpg); color:#fff;"><b>Price</b></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td align="center">&nbsp;</td><td align="center">&nbsp;</td><td align="center">&nbsp;</td></tr>';
				}
				
                $items.= '<tr><td height="10">' . $order_product['order_prd_name'] . '</td><td align="left">' . $order_product['order_prd_unit'] . '</td><td align="center">' . $order_product['order_prd_quantity'] . '</td><td align="left">&nbsp;</td><td align="left">$ ' . number_format($order_product['order_prd_tot_price'], 2, '.', '') . '</td></tr>';
            } else if ($order_product['order_prd_type'] == 'package') {
				$template_detail = $this->get_template_detail(7);
                $order_package_products = $this->order->get_order_package_products($order_product['order_prd_id']);
				
				if($inc == 1)
				{
					$items.= '<table width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td width="49%" height="30" style=" background-image:url(http://64.77.51.231/~gurusindiancuisi/assets/email_images/heading_bg.jpg); padding-left:5px; color:#fff;"><b>Item Name</b></td><td width="14%" height="30" style=" background-image:url(http://64.77.51.231/~gurusindiancuisi/assets/email_images/heading_bg.jpg); color:#fff;"><strong>Category</strong></td><td width="17%" height="30" align="center" style=" background-image:url(http://64.77.51.231/~gurusindiancuisi/assets/email_images/heading_bg.jpg); color:#fff;"><b>People</b></td><td width="4%" height="30" style=" background-image:url(http://64.77.51.231/~gurusindiancuisi/assets/email_images/heading_bg.jpg); color:#fff;">&nbsp;</td><td width="16%" height="30" style=" background-image:url(http://64.77.51.231/~gurusindiancuisi/assets/email_images/heading_bg.jpg); color:#fff;"><b>Price</b></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td align="center">&nbsp;</td><td align="center">&nbsp;</td><td align="center">&nbsp;</td></tr>';
				}
				
                $items.= '<tr><td height="10"><h3>' . $order_product['order_prd_name'] . '</h3></td><td align="center">&nbsp;</td><td align="center">' . $order_product['order_prd_people'] . '</td><td align="left">&nbsp;</td><td align="left">$ ' . number_format($order_product['order_prd_price'], 2, '.', '') . '</td></tr>';
                foreach ($order_package_products as $order_package_product) {
                    $items.= '<tr><td valign="top" style="padding-left:20px;">' . $order_package_product['order_pkg_prd_name'] . '</td><td align="center">' . $order_package_product['order_pkg_cat_name'] . '</td><td align="left">&nbsp;</td><td align="left">&nbsp;</td></tr>';
                }
            }
		$inc++;
        }
		$items.='<tr><td valign="top" style="padding-left:20px">&nbsp;</td><td align="center"></td><td align="left">&nbsp;</td><td align="left">&nbsp;</td></tr>';
		
        $items.='<tr><td height="20"><b>Total Price</b></td><td align="left">&nbsp;</td><td align="left" style="color:#f53e49;">&nbsp;</td><td align="left" style="color:#f53e49;">&nbsp;</td><td align="left"><b>$ ' . number_format($order_detail['order_prd_total'], 2, '.', '') . '</b></td></tr>';
        if ($order_detail['order_cpn_discount']) {
            $items.= '<tr><td height="20" style="text-transform:uppercase;color:#c70000;"><b>Discount (' . number_format($order_detail['order_cpn_per'], 2, '.', '') . '%)</b></td><td align="center" style="text-transform:uppercase;">&nbsp;</td><td align="center" style="text-transform:uppercase;">&nbsp;</td><td align="center" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase; color:#c70000;"><b>$ ' . number_format($order_detail['order_cpn_discount'], 2, '.', '') . '</b></td></tr>';
        }
        if ($order_detail['order_gst_per'] && $order_detail['order_gst']) {
            $items.= '<tr><td height="20" style="text-transform:uppercase;"><b>GST (' . $order_detail['order_gst_per'] . '%)</b></td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;"><b>$ ' . number_format($order_detail['order_gst'], 2, '.', '') . '</b></td></tr>';
        }
        if ($order_detail['order_pst_per'] && $order_detail['order_pst']) {
            $items.= '<tr><td height="20" style="text-transform:uppercase;"><b>PST (' . $order_detail['order_pst_per'] . '%)</b></td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;"><b>$ ' . number_format($order_detail['order_pst'], 2, '.', '') . '</b></td></tr>';
        }
        if ($order_detail['order_hst_per'] && $order_detail['order_hst']) {
            $items.= '<tr><td height="20" style="text-transform:uppercase;"><b>HST (' . $order_detail['order_hst_per'] . '%)</b></td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;"><b>$ ' . number_format($order_detail['order_hst'], 2, '.', '') . '</b></td></tr>';
        }
        if ($order_detail['order_del_charges']) {
            $items.= '<tr><td height="20" style="text-transform:uppercase;"><b>Delivery Charges (' . $order_detail['order_del_loc_name'] . ')</b></td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;">&nbsp;</td><td align="left" style="text-transform:uppercase;"><b>$ ' . number_format($order_detail['order_del_charges'], 2, '.', '') . '</b></td></tr>';
        }
		$items.= '<tr><td>&nbsp;</td><td align="left">&nbsp;</td><td align="center">&nbsp;</td><td align="center">&nbsp;</td><td align="center">&nbsp;</td></tr>';
		
        $items.= '<tr><td height="30" bgcolor="#f4f4f4" style="border-bottom:1px solid #ff9306;background: #fbe586; font-size: 12px; border-top:1px solid #ff9306; border-left:1px solid #ff9306; text-transform:uppercase; color:#000; padding-left:5px;"><b>GRAND TOTAL</b></td><td align="left" bgcolor="#f4f4f4" style="border-bottom:1px solid #ff9306;background: #fbe586; font-size: 14px; border-top:1px solid #ff9306; text-transform:uppercase;">&nbsp;</td><td align="left" bgcolor="#f4f4f4" style="border-bottom:1px solid #ff9306; border-top:1px solid #ff9306;background: #fbe586; font-size: 14px; text-transform:uppercase; color:#000;">&nbsp;</td><td align="left" bgcolor="#f4f4f4" style="border-bottom:1px solid #ff9306; border-top:1px solid #ff9306;text-transform:uppercase;background: #fbe586; font-size: 14px; color:#000;">&nbsp;</td><td align="left" bgcolor="#f4f4f4" style="border-bottom:1px solid #ff9306; border-top:1px solid #ff9306;  border-right:1px solid #f53e49;  text-transform:uppercase;background: #fbe586; font-size: 12px; color:#000;"><b>$ ' . number_format($order_detail['order_total'], 2, '.', '') . '</b></td></tr>';
		
        $items.='<tr><td>&nbsp;</td><td align="left">&nbsp;</td><td align="center">&nbsp;</td><td align="center">&nbsp;</td><td align="center">&nbsp;</td></tr>';
        $i = 1;
        foreach ($order_products as $order_product) {
            if($order_product['order_prd_note'] && $order_product['order_prd_note']!='0') {
                if($i==1)
                    $items.= '<tr><td colspan="5"><table width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td width="6%"><strong>Note</strong>:</td><td width="94%">&nbsp;</td></tr>';
            $items.= '<tr><td>' . $i . '</td><td>#<strong> ' . $order_product['order_prd_name'] . '</strong>:' . $order_product['order_prd_note'] . '</td></tr>';
            $i++;
            }
        }
        if($i>1)
        $items.= '<tr><td>&nbsp;</td><td>&nbsp;</td></tr></table></td></tr>';
        $items.='</table>';
        $sub_total = $order_detail['order_prd_total'];
        $gst = $order_detail['order_prd_total'];
        $pst = $order_detail['order_prd_total'];
        $hst = $order_detail['order_prd_total'];
        $total = $order_detail['order_prd_total'];
        $str = str_replace("{#order_id}", 'KW-' . $order_id, $template_detail['et_content']);
        $str = str_replace("{#client_name}", ucfirst($order_detail['order_cus_name']), $str);
        $str = str_replace("{#client_email}", $order_detail['order_cus_email'], $str);
        $str = str_replace("{#client_phone}", $order_detail['order_cus_phone'], $str);
        $str = str_replace("{#client_address}", $order_detail['order_cus_address'], $str);
        $str = str_replace("{#delivery_location}", $order_detail['order_del_loc_name'], $str);
        $str = str_replace("{#order_created_location}", $order_detail['order_sess_loc_name'], $str);
		$str = str_replace("{#order_type}", ucfirst($order_detail['order_type']), $str);
        $str = str_replace("{#delivery_date}", date('d-m-Y', $order_detail['order_del_date']), $str);
        $str = str_replace("{#delivery_time}", date('h:i A', $order_detail['order_del_time']), $str);
        $str = str_replace("{#order_date}", date('d-m-Y', $order_detail['order_creation_time']), $str);
        $str = str_replace("{#order_time}", date('h:i A', $order_detail['order_creation_time']), $str);
        $str = str_replace("{#order_tracking_link}", site_url('track-my-order/'.$order_id.'/'.$order_detail['order_sess_id']), $str);
        $str = str_replace("{#client_comment}", $order_detail['order_cus_comments'], $str);
		$str = str_replace("{#notice_line}",$this->config->item('website_checkout_notice'), $str);
       // $str = str_replace("{#client_payment_mode}", $order_detail['order_pay_type'], $str);
        $str = str_replace("{#products}", $items, $str);
        if ($order_detail['order_pay_type'] == 'cod') {
            $str = str_replace("{#cash_on_delivery_note}", $this->config->item('website_cod_note'), $str);
            $str = str_replace("{#client_payment_mode}", 'Cash & Credit Card on Delivery', $str);
        }
        else {
            $str = str_replace("{#cash_on_delivery_note}", '', $str);
            $str = str_replace("{#client_payment_mode}", 'Paypal', $str);
        }
        $this->email->from($template_detail['et_sender_email'], $template_detail['et_sender_name']);
        $this->email->to($order_detail['order_cus_email']);
        $this->email->cc($template_detail['et_cc_emails']);
        $this->email->mailtype = $this->mailtype;
        if ($order_detail['order_status'] == 'pending') {
        $this->email->subject('Order has been Successfully done');
        } else if ($order_detail['order_status'] == 'cancelled') {
        $this->email->subject('Order has been Cancelled');
        }
        $this->email->message($str);
        if ($this->email->send()) {
            return true;
        } else {
            show_error($this->email->print_debugger());
        }
    }

    function forgot_password_mail($admin_data,$template_id = 2) {
        $template_detail = $this->get_template_detail($template_id);
        $str = str_replace("{#client_username}",$admin_data['admin_username'], $template_detail['et_content']);
        $str = str_replace("{#client_email}", $admin_data['admin_email'], $str);
        $str = str_replace("{#forgot_password_link}", site_url($this->config->config['backend_url'].'/reset-password/'.$admin_data['admin_verification_code']), $str);
        $this->email->from($template_detail['et_sender_email'], $template_detail['et_sender_name']);
        $this->email->to($template_detail['et_cc_emails']);
        $this->email->mailtype = $this->mailtype;
        $this->email->subject($template_detail['et_subject']);
        $this->email->message($str);
       // echo $str;die;
        if ($this->email->send()) {
            return true;
        } else {
            show_error($this->email->print_debugger());
        }
    }

}
