<?php

class Cart_Model extends CI_Model {

    var $cart_table = 'tbl_cart';
    var $cart_products_table = 'tbl_cart_products';
    var $cart_pkg_products_table = 'tbl_cart_pkg_products';

    function get_cart_detail() {
        $this->db->where($this->cart_table . '.cart_sess_id', $this->session->userdata('session_id'));
        $query = $this->db->get($this->cart_table);
        $result = $query->row_array();
        return $result;
    }

    function get_cart_products() {
        $this->db->where($this->cart_products_table . '.cart_prd_sess_id', $this->session->userdata('session_id'));
        $query = $this->db->get($this->cart_products_table);
        $result = $query->result_array();
        return $result;
    }
    
    function get_cart_package_products($cart_product_id) {
        $this->db->where($this->cart_pkg_products_table . '.cart_pkg_cart_prd_fk', $cart_product_id);
        $query = $this->db->get($this->cart_pkg_products_table);
        $result = $query->result_array();
        return $result;
    }
function get_cart_product_detail($cart_prd_id) {
        $this->db->where($this->cart_products_table . '.cart_prd_sess_id', $this->session->userdata('session_id'));
        $this->db->where($this->cart_products_table . '.cart_prd_id', $cart_prd_id);
        $query = $this->db->get($this->cart_products_table);
        $result = $query->row_array();
        return $result;
    }
    function check_product_existence($prd_id = FALSE, $prd_attr_id = FALSE) {
        $this->db->where($this->cart_products_table . '.cart_prd_sess_id', $this->session->userdata('session_id'));
        $this->db->where($this->cart_products_table . '.cart_prd_fk', $prd_id);
        if($prd_attr_id)
        $this->db->where($this->cart_products_table . '.cart_prd_attr_fk', $prd_attr_id);
        $query = $this->db->get($this->cart_products_table);
        $result = $query->row_array();
        return $result;
    }

    public function add_cart_product($cart_product_data, $previous_cart_product_id = FALSE) {
        if ($previous_cart_product_id) {
            $this->db->where($this->cart_products_table . '.cart_prd_id', $previous_cart_product_id);
            $this->db->where($this->cart_products_table . '.cart_prd_sess_id', $this->session->userdata('session_id'));
            $response = $this->db->update($this->cart_products_table, $cart_product_data);
        } else {
            $response = $this->db->insert($this->cart_products_table, $cart_product_data);
            $response=$this->db->insert_id();
        }
        return $response;
    }

    public function add_cart_package_product($cart_package_product_data, $cart_product_id) {
        //$this->db->set('cart_pkg_cart_prd_fk',$cart_product_id);
        $response = $this->db->insert_batch($this->cart_pkg_products_table, $cart_package_product_data);
        return $response;
    }

    public function update_cart($cart_data, $cart_id = FALSE) {
        if ($cart_id) {
            $this->db->where($this->cart_table . '.cart_id', $cart_id);
            $this->db->where($this->cart_table . '.cart_sess_id', $this->session->userdata('session_id'));
            $response = $this->db->update($this->cart_table, $cart_data);
        } else {
            $response = $this->db->insert($this->cart_table, $cart_data);
        }
        return $response;
    }

    function get_cart_products_total() {
        $this->db->select_sum($this->cart_products_table . '.cart_prd_tot_price');
        $this->db->where($this->cart_products_table . '.cart_prd_sess_id', $this->session->userdata('session_id'));
        $query = $this->db->get($this->cart_products_table);
        $result = $query->row_array();
        return $result;
    }

    public function delete_cart() {
        $this->db->where($this->cart_table . '.cart_sess_id', $this->session->userdata('session_id'));
        return $this->db->delete($this->cart_table);
    }

    public function delete_cart_product($cart_product_id="") {
        if ($cart_product_id)
            $this->db->where($this->cart_products_table . '.cart_prd_id', $cart_product_id);
        $this->db->where($this->cart_products_table . '.cart_prd_sess_id', $this->session->userdata('session_id'));
        return $this->db->delete($this->cart_products_table);
    }

    public function delete_cart_package_product($cart_product_id="") {
        if ($cart_product_id)
            $this->db->where($this->cart_pkg_products_table . '.cart_pkg_cart_prd_fk', $cart_product_id);
        $this->db->where($this->cart_pkg_products_table . '.cart_pkg_sess_id', $this->session->userdata('session_id'));
        return $this->db->delete($this->cart_pkg_products_table);
    }
    
    public function delete_cart_pkg_product($cart_product_id="") {
        if ($cart_product_id)
		{
            $this->db->where($this->cart_pkg_products_table . '.cart_pkg_id', $cart_product_id);
            //$this->db->where($this->cart_pkg_products_table . '.cart_pkg_prd_type', 'additional');
			return $this->db->delete($this->cart_pkg_products_table);
		}
    }

}
