<?php

class Order_Model extends CI_Model {

    var $order_table = 'tbl_order';
    var $order_products_table = 'tbl_order_products';
    var $order_pkg_products_table = 'tbl_order_pkg_products';

    public function process_order($order_data, $order_id = FALSE) {
        foreach ($order_data as $key => $value)
            $this->db->set(str_replace('cart', 'order', $key), $value);
        if ($order_id) {
            $this->db->where('order_id', $order_id);
            return $this->db->update($this->order_table);
        } else {
            $this->db->set('order_sess_loc_fk', $this->session->userdata('user_location_id'));
            $this->db->set('order_sess_loc_name', $this->session->userdata('user_location_name'));
            $this->db->set('order_creation_time', time());
            $this->db->set('order_tracking_message','Your Order is in pending status.');
            $this->db->insert($this->order_table);
            return $this->db->insert_id();
        }
    }

    public function process_order_products($order_id, $order_product) {
        foreach ($order_product as $key => $value)
            $this->db->set(str_replace('cart', 'order', $key), $value);
        $this->db->set('order_prd_order_fk', $order_id);
        $this->db->insert($this->order_products_table);
        return $this->db->insert_id();
    }

    public function process_order_package_products($order_product_id, $order_package_product) {
        foreach ($order_package_product as $key => $value)
            $this->db->set(str_replace('cart', 'order', $key), $value);
        $this->db->set('order_pkg_order_prd_fk', $order_product_id);
        return $this->db->insert($this->order_pkg_products_table);
    }

    function get_order_detail($order_id,$order_session_id=FALSE) {
        $this->db->where('order_id', $order_id);
        if($order_session_id)
            $this->db->where('order_sess_id', $order_session_id);
        $query = $this->db->get($this->order_table);
        $result = $query->row_array();
        return $result;
    }

    function get_order_products($order_id) {
        $this->db->where('order_prd_order_fk', $order_id);
        $query = $this->db->get($this->order_products_table);
        $result = $query->result_array();
        return $result;
    }

    function get_order_package_products($order_product_id) {
        $this->db->where('order_pkg_order_prd_fk', $order_product_id);
        $query = $this->db->get($this->order_pkg_products_table);
        $result = $query->result_array();
        return $result;
    }

}
