<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            Banner Management <small><?php echo $breadcumb ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . '/dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $breadcumb ?>                  
                </li>               
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <?php echo $breadcumb ?>
                        </div>   
                        <div class="actions">
                            <a href="<?= site_url($this->config->item('backend_url') . '/banner/' . $group_id) ?>"  class="btn blue btn-sm"><i class="fa fa-share icon-black"></i> Back</a>
                        </div>
                    </div>
                    <div class="portlet-body form">
                        <form class="form-horizontal" role="form" method="post" enctype="multipart/form-data">
                            <div class="form-body">

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Banner Title</label>
                                    <div class="col-md-6">
                                        <input type="text" name="bnr_title" value="<?= $bnr_title ?>" class="form-control" placeholder="Enter Banner Title">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('bnr_title')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Banner Link</label>
                                    <div class="col-md-6">
                                        <input type="text" name="bnr_link" value="<?= $bnr_link ?>" class="form-control" placeholder="Enter Banner Link">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Banner Text</label>
                                    <div class="col-md-9">
                                        <textarea class="form-control" name="bnr_text" rows="3"><?= $bnr_text ?></textarea>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputFile" class="col-md-3 control-label">Banner Image</label>
                                    <div class="col-md-9">
                                        <input type="file" onChange="readURL(this);" id="banner_image" name="bnr_image" value="<?= $bnr_image ?>"><br>
                                        <?php if (isset($bnr_image) && $bnr_image != '') { ?>
                                            <img id="banner_image_preview" src="<?= $this->config->item('uploads'); ?>banner_images/<?= $bnr_image ?>" width="50px" height="50px">
                                        <?php } else { ?>
                                            <img id="banner_image_preview" src="<?= $this->config->item('backend_assets'); ?>layout/img/upload_image.png" width="50px" height="50px">
                                        <?php } ?>                            
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('bnr_image')) ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="form-actions">
                                <div class="row">
                                    <div class="col-md-offset-3 col-md-9">
                                        <button type="submit" class="btn green">Submit</button>
                                        <button type="reset" class="btn default">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            //alert(input.id);
            reader.onload = function (e) {
                $('#' + input.id + '_preview').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

</script>
<script type="text/javascript">
    CKEDITOR.replace('editor',
            {
                filebrowserBrowseUrl: '<?php echo $this->config->item('ckeditor_basepath'); ?>ckfinder/ckfinder.html',
                filebrowserImageBrowseUrl: '<?php echo $this->config->item('ckeditor_basepath'); ?>ckfinder/ckfinder.html?type=Images',
                filebrowserFlashBrowseUrl: '<?php echo $this->config->item('ckeditor_basepath'); ?>ckfinder/ckfinder.html?type=Flash'
            });
</script> 