<script type="text/javascript" src="<?php echo $this->config->item('ckeditor_basepath'); ?>ckeditor.js"></script>
<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $page_heading ?><small ><?php echo $page_heading ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $page_heading ?>                  
                </li>               
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject font-green-sharp bold uppercase"><a href="<?= site_url($this->config->item('backend_url') . '/package') ?>">Back</a></span>
                        </div>                         
                    </div>
                    <div class="portlet-body form">
                        <form class="form-horizontal" role="form" method="post" enctype="multipart/form-data">
                            <div class="form-body">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Coupon Code</label>
                                    <div class="col-md-9">
                                        <input type="text" name="cpn_code" value="<?= $cpn_code ?>" class="form-control" placeholder="Enter Coupon Code">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('cpn_code')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Coupon Discount</label>
                                    <div class="col-md-9">
                                        <input type="text" name="cpn_discount" value="<?= $cpn_discount ?>" class="form-control" placeholder="Enter Coupon Discount">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('cpn_discount')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Min Order Amount</label>
                                    <div class="col-md-9">
                                        <input type="text" name="cpn_min_price" value="<?= $cpn_min_price ?>" class="form-control" placeholder="Enter Min Order Amount">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('cpn_min_price')) ?></p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Coupon Type</label>
                                    <div class="col-md-9">
                                        <select name="cpn_type" class="form-control">
                                            <option value="percentage" <?= $cpn_type == 'percentage' ? 'selected' : '' ?>>Percentage</option>
                                            <option value="money" <?= $cpn_type == 'money' ? 'selected' : '' ?>>Money</option>
                                        </select>
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('cpn_type')) ?></p>
                                    </div>
                                </div>
                                <?php
                                if ($this->config->item('website_multi_location') == 'yes') {
                                    $this->load->view($this->config->item('backend_folder_name') . '/location_dropdown_div');
                                }
                                ?>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Coupon Expiry date</label>
                                    <div class="col-md-9">
                                        <div class="input-group date date-picker" data-date-format="dd-mm-yyyy">
                                            <input type="text" class="form-control" readonly name="cpn_exp_date" value="<?= ($cpn_exp_date)?date('d-m-Y', $cpn_exp_date):''; ?>">
                                            <span class="input-group-btn">
                                                <button class="btn default" type="button"><i class="fa fa-calendar"></i></button>
                                            </span>
                                        </div>
<!--                                        <input type="text" name="cpn_exp_date" value="<?= ($cpn_exp_date)?date('d-m-y', $cpn_exp_date):'' ?>" class="form-control datepicker" placeholder="Enter Coupon Expiry date">-->
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('cpn_exp_date')) ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="form-actions">
                                <div class="row">
                                    <div class="col-md-offset-3 col-md-9">
                                        <button type="submit" class="btn green">Submit</button>
                                        <button type="reset" class="btn default">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>