<script type="text/javascript" src="<?php echo $this->config->item('ckeditor_basepath'); ?>ckeditor.js"></script>
<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $page_heading ?><small ><?php echo $page_heading ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . '/dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $page_heading ?>                  
                </li>               
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject font-green-sharp bold uppercase"><a href="<?= site_url($this->config->item('backend_url') . '/location/'.$location_type_id) ?>">Back</a></span>
                        </div>                         
                    </div>
                    <div class="portlet-body form">
                        <form class="form-horizontal" role="form" method="post" enctype="multipart/form-data">
                            <div class="form-body">
                                <?php if ($parent_locations) { ?>
                                    <div class="form-group">
                                        <label class="col-md-3 control-label">Parent Location</label>
                                        <div class="col-md-9">
                                            <select name="loc_parent_fk" class="form-control">
                                                <option value="">Select Parent Location</option>
                                                <?php foreach ($parent_locations as $parent_location) { ?>
                                                    <option value="<?= $parent_location['loc_id'] ?>"<?php if ($parent_location['loc_id'] == $loc_parent_fk) { ?> selected="selected" <?php } ?>><?= $parent_location['loc_name'] ?></option>  
                                                <?php } ?>                                     
                                            </select>
                                        </div>
                                    </div>
                                <?php } ?>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Location Name</label>
                                    <div class="col-md-9">
                                        <input type="text" name="loc_name" value="<?= $loc_name ?>" class="form-control" placeholder="Enter Location Name">
                                        <p class="help-block" style="color: red;"><?= strip_tags(form_error('loc_name')) ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="form-actions">
                                <div class="row">
                                    <div class="col-md-offset-3 col-md-9">
                                        <button type="submit" class="btn green">Submit</button>
                                        <button type="reset" class="btn default">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            //alert(input.id);
            reader.onload = function (e) {
                $('#' + input.id + '_preview').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>