<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en">
    <head>
        <meta charset="utf-8"/>
        <title><?= $this->config->item('website_name') ?> | Login Form</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
        <meta http-equiv="Content-type" content="text/html; charset=utf-8">
        <!-- BEGIN GLOBAL MANDATORY STYLES -->
        <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>plugins/simple-line-icons/simple-line-icons.min.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>plugins/uniform/css/uniform.default.css" rel="stylesheet" type="text/css"/>

        <link href="<?= $this->config->item('backend_assets') ?>pages/css/login2.css" rel="stylesheet" type="text/css"/>

        <link href="<?= $this->config->item('global_assets') ?>css/components.css" id="style_components" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('global_assets') ?>css/plugins.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('backend_assets') ?>layout/css/layout.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('backend_assets') ?>layout/css/themes/darkblue.css" rel="stylesheet" type="text/css"/>
        <link href="<?= $this->config->item('backend_assets') ?>layout/css/custom.css" rel="stylesheet" type="text/css"/>
    </head>

    <body class="page-md login">
        <div class="menu-toggler sidebar-toggler">
        </div>

        <div class="logo">
            <a href="<?= base_url() ?>">
                <img src="<?= $this->config->item('uploads') ?>site_images/<?= $this->config->item('website_logo') ?>"/>
            </a>
        </div>

        <div class="content">

            <form class="login-form" method="post">
                <div class="form-title">
                    <span class="form-title">Welcome.</span>
                    <span class="form-subtitle">Please login.</span>
                </div>
                <?php
                $success_message = $this->session->flashdata('SUCCESS_MESSAGE');
                if ($success_message) {
                    ?>
                    <div class="alert alert-success">
                        <button class="close" data-close="alert"></button>
                        <span><?php echo $success_message; ?></span>
                    </div>
                    <?php
                }
                if ($error_message) {
                    ?>
                    <div class="alert alert-danger">
                        <button class="close" data-close="alert"></button>
                        <span><?php echo $error_message; ?></span>
                    </div>
                <?php } ?>
                <?php
                $error_message = $this->session->flashdata('error_message');
                if ($error_message) {
                    ?>
                    <div class="alert alert-danger">
                        <button class="close" data-close="alert"></button>
                        <span><?php echo $error_message; ?></span>
                    </div>
                <?php } ?>
                <div class="form-group">		
                    <label class="control-label visible-ie8 visible-ie9">Username</label>
                    <input class="form-control form-control-solid placeholder-no-fix" type="text"  placeholder="Username Or Email-Id" name="login_identity"/>
                </div>
                <div class="form-group">
                    <label class="control-label visible-ie8 visible-ie9">Password</label>
                    <input class="form-control form-control-solid placeholder-no-fix" type="password" placeholder="Password" name="login_password"/>
                </div>
                <?php
                if (isset($captcha)) {
                    echo "<div class=\"form-group\">";
                    echo " <label class=\"control-label visible-ie8 visible-ie9\">Captcha</label>";
                    echo $captcha . ' = <input type="text" id="captcha" name="login_captcha" class="form-control form-control-solid placeholder-no-fix" placeholder="Captcha Question"/>' . "\n";
                    echo "</div>";
                }
                ?>
                <div class="form-actions">
                    <input type="submit" value="Login" name="login_user" class="btn btn-primary btn-block uppercase"/>
                </div>
                <div class="form-actions">
                    <div class="pull-right forget-password-block">
                        <a href="javascript:;" id="forget-password" class="forget-password">Forgot Password?</a>
                    </div>
                </div>
            </form>
            <form class="forget-form" action="<?= site_url($this->config->item('backend_url') . '/forgot-password') ?>" method="post">
                <div class="form-title">
                    <span class="form-title">Forget Password ?</span>
                    <span class="form-subtitle">Enter your e-mail to reset it.</span>
                </div>
                <div class="form-group">
                    <input class="form-control placeholder-no-fix" type="text" autocomplete="off" placeholder="Username Or Email-Id" name="forgot_password_identity" required/>
                </div>
                <div class="form-actions">
                    <button type="button" id="back-btn" class="btn btn-default">Back</button>
                    <input type="submit" name="send_forgotten_password" value="Submit" class="btn btn-primary uppercase pull-right"/>
                </div>
            </form>
        </div>
        <div class="copyright hide">
            <?php echo date('Y'); ?> © <?= $this->config->item('website_name') ?>
        </div>
        <script src="<?= $this->config->item('global_assets') ?>plugins/jquery.min.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('global_assets') ?>plugins/jquery-migrate.min.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('global_assets') ?>plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('global_assets') ?>plugins/jquery.blockui.min.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('global_assets') ?>plugins/uniform/jquery.uniform.min.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('global_assets') ?>plugins/jquery.cokie.min.js" type="text/javascript"></script>
        <!-- END CORE PLUGINS -->
        <!-- BEGIN PAGE LEVEL PLUGINS -->
        <script src="<?= $this->config->item('global_assets') ?>plugins/jquery-validation/js/jquery.validate.min.js" type="text/javascript"></script>
        <!-- END PAGE LEVEL PLUGINS -->
        <!-- BEGIN PAGE LEVEL SCRIPTS -->
        <script src="<?= $this->config->item('global_assets') ?>scripts/metronic.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('backend_assets') ?>layout/scripts/layout.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('backend_assets') ?>layout/scripts/demo.js" type="text/javascript"></script>
        <script src="<?= $this->config->item('backend_assets') ?>pages/scripts/login.js" type="text/javascript"></script>
        <!-- END PAGE LEVEL SCRIPTS -->
        <script>
            jQuery(document).ready(function () {
                Metronic.init(); // init metronic core components
                Layout.init(); // init current layout
                Login.init();
                Demo.init();
            });
        </script>
    </body>
</html>