<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            Invoice <small>Order Id: SI-<?= $order_data['order_id'] ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . '/dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <a href="<?= site_url($this->config->item('backend_url') . '/order') ?>">Orders</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    SI-<?= $order_data['order_id'] ?>
                </li>
            </ul>
        </div>
        <!-- END PAGE HEADER-->
        <!-- BEGIN PAGE CONTENT-->
        <div class="invoice">
            <div class="row invoice-logo">
                <div class="col-xs-6 invoice-logo-space">
                    <img src="<?= $this->config->item('uploads') ?>site_images/<?= $this->config->item('website_logo') ?>" class="img-responsive"/>
                </div>
                <div class="col-xs-6">
                    <p>
                        #SI-<?= $order_data['order_id'] ?> / <?= date('d M Y', $order_data['order_creation_time']) ?>
                    </p>
                </div>
            </div>
            <hr/>
            <div class="row">
                <div class="col-xs-4">
                    <h3>Client Detail:</h3>
                    <ul class="list-unstyled">
                        <li>
                            <?= $order_data['order_cus_name'] ?>
                        </li>
                        <li>
                            <?= $order_data['order_cus_email'] ?>
                        </li>
                        <li>
                            <?= $order_data['order_cus_phone'] ?>
                        </li>
                        <li>
                            <?= $order_data['order_cus_address'] ?>
                        </li>
                        <li>
                            <?= $order_data['order_cus_city'] ?>
                        </li>
                    </ul>
                </div>

                <div class="col-xs-4 invoice-payment">
                    <h3>Delivery Details:</h3>
                    <ul class="list-unstyled">
                        <li>
                            <?= $order_data['order_type'] ?>
                        </li>
                        <li>
                            <strong><?= $order_data['order_type'] ?> Location:</strong><?= $order_data['order_del_loc_name'] ?>
                        </li>
                        <li>
                            <strong><?= $order_data['order_type'] ?> Date:</strong><?= date('M d Y', $order_data['order_del_date']) ?>
                        </li>
                        <li>
                            <strong><?= $order_data['order_type'] ?> Date:</strong><?= date('H:m A', $order_data['order_del_time']) ?>
                        </li>
                        <li>
                            <strong>Payment Via:</strong> <?= $order_data['order_pay_type'] == 'cod' ? 'Cash On Delivery' : 'Paypal'; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th class="hidden-480">Quantity</th>
                                <th class="hidden-480">Unit</th>
                                <th class="hidden-480">People</th>
                                <th class="hidden-480">Price Cost</th>
                                <th>Total Price</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                if ($order_products) {
                    foreach ($order_products as $order_product) {
                        ?>
                        <tr>
                            <td>
                                <?= $order_product['order_prd_name'] ?>
                                <?php if ($order_product['order_prd_type'] == 'package') { ?>
                                    <a href="<?= site_url($this->config->item('backend_url') . '/order-package-products/' . $order_product['order_prd_id']) ?>" class="fancybox fancybox.iframe btn btn-default btn-sm" ><i class="fa fa-eye"></i></a>
                                <?php } ?>
                            </td>
                            <td><?= $order_product['order_prd_quantity'] ?></td>
                            <td><?= $order_product['order_prd_unit'] ?></td>
                            <td><?= $order_product['order_prd_people'] . ' People' ?></td>
                            <td><?= $order_product['order_prd_price'] ?></td>
                            <td><?= '$ ' . number_format($order_product['order_prd_tot_price'], 2, '.', ',') ?></td>
                        </tr>
                        <?php
                    }
                } else {
                    ?>
                    <tr>
                        <td colspan="6" class="text-center">No Item Added</td>
                    </tr>
                <?php } ?>
                            
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">

                <div class="col-xs-10 invoice-block">
                    <ul class="list-unstyled amounts">
                        <li>
                            <strong>Sub - Total amount:</strong> <?= ($order_data['order_prd_total']) ? '$ ' . number_format($order_data['order_prd_total'], 2, '.', ',') : '$ 0.00' ?>
                        </li>
                         <?php if ($order_data['order_cpn_discount']) { ?>
                        <li>
                            <strong>Discount<?= ($order_data['order_cpn_per']) ? '( ' . number_format($order_data['order_cpn_per'], 2, '.', ',') . '%)' : '' ?>:</strong> <?= ($order_data['order_cpn_discount']) ? '$ ' . number_format($order_data['order_cpn_discount'], 2, '.', ',') : '$ 0.00' ?>
                        </li>
                         <?php } ?>
                        <?php if ($order_data['order_gst'] && $order_data['order_gst_per']) { ?>
                        <li>
                            <strong>GST(<?= $order_data['order_gst_per'] ?>%):</strong> <?= ($order_data['order_gst']) ? '$ ' . number_format($order_data['order_gst'], 2, '.', ',') : '$ 0.00' ?>
                        </li>
                        <?php } ?>
                        <?php if ($order_data['order_pst'] && $order_data['order_pst_per']) { ?>
                        <li>
                            <strong>PST(<?= $order_data['order_pst_per'] ?>%):</strong> <?= ($order_data['order_pst']) ? '$ ' . number_format($order_data['order_pst'], 2, '.', ',') : '$ 0.00' ?>
                        </li>
                        <?php } ?>
                        <?php if ($order_data['order_hst'] && $order_data['order_hst_per']) { ?>
                        <li>
                            <strong>HST(<?= $order_data['order_hst_per'] ?>%):</strong> <?= ($order_data['order_hst']) ? '$ ' . number_format($order_data['order_hst'], 2, '.', ',') : '$ 0.00' ?>
                        </li>
                        <?php } ?>
                        <li>
                            <strong>Grand Total:</strong> $ <?php echo number_format($order_data['order_total'], 2, '.', '') ?>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>