<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $page_heading ?><small> <?php echo $page_heading ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $page_heading ?>                   
                </li>             
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-globe"></i><?php echo $page_heading ?>                   
                        </div>
                    </div>
                    <div class="portlet-body">
                        <form method="post">
                            <div class="table-toolbar">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="btn-group">
                                            <input type="submit" name="submit" value="Update" class="btn btn-default" />
                                            <a href="javascript:" class="btn green add_more" id="sample_editable_1_new">Add New Row <i class="fa fa-plus"></i></a>                                       
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Category</th>  
                                        <th>Product</th>  
                                        <th>Type</th>
                                        <th>Min. People</th>
                                        <th>Price</th>
                                        <th>Grp NO.</th>  
                                        <th>Grp Count</th>  
                                        <th>Upgradable</th>  
                                        <th>Status</th>                                          
                                        <?php if ($package_attribute_list) { ?>
                                            <th>Action</th> 
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody id="item_tbody">
                                    <?php
                                    foreach ($package_attribute_list as $package_attribute){
                                        ?>
                                        <tr class="odd gradeX item_tr">       
                                            <td>
                                                <select class="form-control category_id" name="category_id[]">
                                                    <option value="">Select Package Category</option>  
                                                    <?php foreach ($package_category_list as $package_category) { ?>                                                            
                                                        <option value="<?= $package_category['cat_id'] ?>" <?php if ($package_category['cat_id'] == $package_attribute->pkg_attr_cat_fk) { ?> selected <?php } ?>><?= $package_category['cat_name'] ?></option>              
                                                    <?php } ?>
                                                </select>
                                            </td>  
                                          <td>
                                                <select class="form-control product_id" name="product_id[]">
                                                    <option value="">Select Package Product</option>
                                                    <?php $package_product_list = $this->product->get_product_list(3, $package_attribute->pkg_attr_cat_fk);
                                                    foreach ($package_product_list as $package_product) { ?> 
                                                        <option value="<?= $package_product['prd_id'] ?>" <?php if ($package_product['prd_id'] == $package_attribute->pkg_attr_prd_fk) { ?> selected <?php } ?>><?= $package_product['prd_name'] ?></option>
                                                    <?php } ?>
                                                </select>
                                            </td>  
                                            <td>
                                                <select class="form-control" name="product_type[]" required>
                                                    <option value="default" <?php if ($package_attribute->pkg_attr_type != 'additional') { ?> selected <?php } ?>>Default</option>
                                                    <option value="additional" <?php if ($package_attribute->pkg_attr_type == 'additional') { ?> selected <?php } ?>>Additional</option>
                                                </select>
                                            </td>                            
                                            <td>
                                                <input type="text" name="product_min_people[]" value="<?= $package_attribute->pkg_attr_min_people ?>" class="form-control" required/>
                                            </td>  
                                            <td>
                                                <input type="text" name="product_price[]" value="<?= $package_attribute->pkg_attr_price ?>" class="form-control" required/>
                                            </td> 
                                            <td>
                                                <input type="text" name="group_number[]" value="<?= $package_attribute->pkg_attr_group_no ?>" class="form-control" required/>
                                            </td> 
                                            <td>
                                                <input type="text" name="group_count[]" value="<?= $package_attribute->pkg_attr_group_count ?>" class="form-control" required />
                                            </td> 
                                            <td>
                                                <select class="form-control" name="is_upgradable[]" required>
                                                    <option value="yes" <?php if ($package_attribute->pkg_attr_upgradable == 'yes') { ?> selected <?php } ?>>yes</option>
                                                    <option value="no" <?php if ($package_attribute->pkg_attr_upgradable != 'yes') { ?> selected <?php } ?>>No</option>
                                                </select>
                                            </td> 
                                            <td>
                                                <select class="form-control" name="status[]" required>
                                                    <option value="active" <?php if ($package_attribute->pkg_attr_status == 'active') { ?> selected <?php } ?>>Yes</option>
                                                    <option value="inactive" <?php if ($package_attribute->pkg_attr_status == 'inactive') { ?> selected <?php } ?>>No</option>
                                                </select>
                                            </td> 
                                            <td class="remove_td">
                                                <a href="javascript:" data-href="<?= site_url($this->config->item('backend_url').'/delete-package-attribute/'.$package_attribute->pkg_attr_id) ?>" class="btn btn-danger btn-rounded btn-condensed btn-sm remove_package_attribute"><span class="fa fa-times" title="delete"></span></a>
                                            </td> 
                                        </tr>
                                    <?php } ?>
                                    <?php if (sizeof($package_attribute_list) == 0) { ?>
                                        <tr class="odd gradeX item_tr">
                                            <td>
                                                <select class="form-control category_id" name="category_id[]" required>
                                                    <option value="">Select Package Category</option>  
                                                    <?php foreach ($package_category_list as $package_category) { ?>                                                            
                                                        <option value="<?= $package_category['cat_id'] ?>"><?= $package_category['cat_name'] ?></option>              
                                                    <?php } ?>
                                                </select>
                                            </td>  
                                            <td>
                                                <select class="form-control product_id" name="product_id[]" required>
                                                    <option value="">Select Category First</option>
                                                </select>
                                            </td>  
                                            <td>
                                                <select class="form-control" name="product_type[]">
                                                    <option value="default">Default</option>
                                                    <option value="additional">Additional</option>                                                
                                                </select>
                                            </td>  
                                            <td>
                                                <input type="text" name="product_min_people[]" class="form-control" required />
                                            </td>  
                                            <td>
                                                <input type="text" name="product_price[]" class="form-control" required/>
                                            </td> 
                                            <td>
                                                <input type="text" name="group_number[]" class="form-control" required />
                                            </td> 
                                            <td>
                                                <input type="text" name="group_count[]" class="form-control" required />
                                            </td> 
                                            <td>
                                                <select class="form-control" name="is_upgradable[]" required>
                                                    <option value="yes">Yes</option>
                                                    <option value="No">No</option>
                                                </select>
                                            </td>
                                            <td>
                                                <select class="form-control" name="status[]" required>
                                                    <option value="active">Yes</option>
                                                    <option value="inactive">No</option>
                                                </select>
                                            </td>                                                  
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
    .error { color:red!important;}
</style>
<script>
    $('body').delegate('.add_more', 'click', function () {
        $("#item_tbody tr:first").clone().find('input[type=text]').val('').end().find('.remove_td').html('').end().appendTo("#item_tbody");
        
    });
    $('body').delegate('.remove_package_attribute', 'click', function () {
        if ($('.item_tr').size() > 1) {
            $(this).parent().parent().remove();
            $.ajax({
                type: "POST",
                url: $(this).attr('data-href'),
                dataType: "json",
            });
        }
    });
    $('body').delegate('.category_id', 'change', function () {
        var category_id = $(this).val();
        var $this = $(this).parent().parent();
        if (category_id != '') {
            $.ajax({
                type: "POST",
                url: adminbaseurl + "/get-package-products",
                data: {
                    "category_id": category_id
                },
                dataType: "json",
                success: function (data) {
                    $this.find('.product_id').html('');
                    if (data.success) {
                        $this.find('.product_id').html('<option value="">Select Package Product</option>');
                        $.each(data.package_products, function (key, value) {
                            $this.find('.product_id').append('<option value="' + value.prd_id + '">' + value.prd_name + '</option>');
                        });
                    } else {
                        $this.find('.product_id').html('<option value="">No Record Found</option>');
                    }
                }
            });
        }
    });
//    $(document).ready(function () {
//        $('form#specification_form').submit(function () {
//            $('form#specification_form .error').remove();
//            var hasError = false;
//            $('.requiredField').each(function () {
//
//                if ($.trim($(this).val()) == '') {
//                    if ($(this).parent().parent().find('input[type=checkbox]').prop("checked") == true) {
//                        var labelText = $(this).prev('label').text();
//                        $(this).parent().append('<span class="error">Required!</span>');
//                        hasError = true;
//                    }
//                } else if ($(this).hasClass('unit_price') || $(this).hasClass('quantity')) {
//
//                    if (!$.isNumeric(($.trim($(this).val())))) {
//                        var labelText = $(this).prev('label').text();
//                        $(this).parent().append('<span class="error">Invalid</span>');
//                        hasError = true;
//                    }
//                }
//            });
//            if (!hasError) {
//                var formInput = $(this).serialize();
//                $('#specification_form').submit();
//            }
//            return false;
//        });
//    });
</script>
