<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $breadcumb ?><small> <?php echo $breadcumb ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $breadcumb ?>                   
                </li>             
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-globe"></i>Products List
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-toolbar">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="btn-group">
                                        <a href="<?= site_url($this->config->item('backend_url') . '/product/add/' . $cat_type_id) ?>" class="btn green" id="sample_editable_1_new">
                                            Add New <i class="fa fa-plus"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <table class="table table-striped table-bordered table-hover" id="sample_6">
                            <thead>
                                <tr>
                                    <th>Product Name</th>                                
                                    <th>Product Category</th>                                  
                                    <th>Product Image</th>        
                                    <th>Status</th>
                                    <th>Action</th>   
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($product_list as $product) {
                                    ?>
                                    <tr class="odd gradeX">                                       
                                        <td><?php echo (isset($product['prd_name'])) ? $product['prd_name'] : '-'; ?></td> 
                                        <td><?php echo (isset($product['cat_name'])) ? $product['cat_name'] : '-'; ?></td>                                
                                        <td><img src="<?= $this->config->item('uploads') ?>product_images/<?php echo $product['prd_image'] ?>" width="50px" height="50px"></td>
                                        <td>
                                            <?php if ($product['prd_status'] == 'active') { ?>
                                                <span class="label label-sm label-success">Active</span> 
                                            <?php } else if ($product['prd_status'] == 'inactive') { ?>
                                                <span class="label label-sm label-warning">Inactive</span>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <div class="col-md-6">
                                                <div class="btn-group">
                                                    <button class="btn btn-success dropdown-toggle" data-toggle="dropdown">Action <i class="fa fa-angle-down"></i>
                                                    </button>
                                                    <ul class="dropdown-menu pull-right">
                                                        <li>
                                                            <a href="<?= site_url($this->config->item('backend_url') . '/product/edit/' . $cat_type_id . '/' . $product['prd_id']) ?>">Edit</a>
                                                        </li>
                                                        <?php if ($product['prd_status'] == 'active') { ?>
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/inactivate-product/' . $product['prd_id']) ?>">Inactivate</a>
                                                            </li>
                                                        <?php } else if ($product['prd_status'] == 'inactive') { ?>
                                                            <li>
                                                                <a href="<?= site_url($this->config->item('backend_url') . '/activate-product/' . $product['prd_id']) ?>">Activate </a>
                                                            </li>
                                                        <?php } ?>
                                                        <li>
                                                            <a href="<?= site_url($this->config->item('backend_url') . '/delete-product/' . $product['prd_id']) ?>">Delete </a>
                                                        </li>
                                                        <li>
                                                            <a href="<?= site_url($this->config->item('backend_url') . '/product/product-attributes/' . $product['prd_id']) ?>">Manage Attributes</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>   
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>