<div class="page-content-wrapper">
    <div class="page-content">
        <h3 class="page-title">
            <?php echo $page_heading ?><small> <?php echo $page_heading ?></small>
        </h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <i class="fa fa-home"></i>
                    <a href="<?= site_url($this->config->item('backend_url') . 'dashboard') ?>">Home</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <?php echo $page_heading ?>                   
                </li>             
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box red-intense">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-globe"></i> <?php echo $page_heading ?>            
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-toolbar">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="btn-group">
                                        <a href="<?= site_url($this->config->item('backend_url') . '/user/export-inquiry') ?>" class="btn green" id="sample_editable_1_new">
                                            Export Inquiry
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <table class="table table-striped table-bordered table-hover" id="sample_6">
                            <thead>
                                <tr>
                                    <th>User Name</th>                                
                                    <th>User Email</th>     
                                    <th>User Phone</th>     
                                    <th>User Comment</th>     
                                    <th>Status</th>
                                    <th>Action</th>   
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($users_data as $user) {
                                    ?>
                                    <tr class="odd gradeX">                                       
                                        <td><?php echo (isset($user['user_name'])) ? $user['user_name'] : '-'; ?></td> 
                                        <td><?php echo (isset($user['user_email'])) ? $user['user_email'] : '-'; ?></td> 
                                        <td><?php echo (isset($user['user_phone'])) ? $user['user_phone'] : '-'; ?></td> 
                                        <td><?php echo (isset($user['user_comment'])) ? $user['user_comment'] : '-'; ?></td>
                                        <td>
                                            <?php if ($user['user_status'] == 'read') { ?>
                                                <span class="label label-sm label-success">Read</span> 
                                            <?php } else if ($user['user_status'] == 'unread') { ?>
                                                <span class="label label-sm label-warning">Unread</span>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <div class="col-md-6">
                                                <div class="btn-group">
                                                    <button class="btn btn-success dropdown-toggle" data-toggle="dropdown">Action <i class="fa fa-angle-down"></i></button>
                                                    <ul class="dropdown-menu pull-right">                                                
                                                        <li>
                                                            <a href="<?= site_url() . $this->config->item('backend_url') . '/user/inquiries/'.$user['user_id'] ?>">View</a>
                                                        </li>
                                                        <li>
                                                            <a href="<?= site_url() . $this->config->item('backend_url') . '/user/delete-user/'.$user['user_id'] ?>">Delete</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>   
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>