<div id="Main_Content">
    <div class="row">
        <div class="col-md-8">
            <h3 class="side-heading">Items Detail</h3>
            <table class="table order-table table-bordered">
                <tr>
                    <th>Item Name</th>
                    <th>Qty.</th>
                    <th>Size</th>
                    <th>People</th>
                    <th>Price</th>
                    <th align="right">Total Price</th>
                </tr>
                <?php
                if ($cart_products_data) {
                    foreach ($cart_products_data as $cart_product) {
                        ?>
                        <tr>
                            <td><?= $cart_product['cart_prd_name'] ?></td>
                            <td><?= $cart_product['cart_prd_quantity'] ?></td>
                            <td><?= $cart_product['cart_prd_unit'] ?></td>
                            <td><?= ($cart_product['cart_prd_people'] != 0) ? $cart_product['cart_prd_people'] . ' People' : '' ?></td>
                            <td><?= '$ ' . number_format($cart_product['cart_prd_price'], 2, '.', ',') ?></td>
                            <td align="left"><?= '$ ' . number_format($cart_product['cart_prd_tot_price'], 2, '.', ',') ?></td>
                        </tr>
                        <?php
                    }
                } else {
                    ?>
                    <tr>
                        <td colspan="5" class="text-center">No Item Added</td>
                    </tr>
                <?php } ?>
                <tr>
                    <th colspan="5" align="right">Subtotal</th>
                    <td width="100" align="left"><?= ($cart_data['cart_prd_total']) ? '$ ' . number_format($cart_data['cart_prd_total'], 2, '.', ',') : '$ 0.00' ?></td>
                </tr>
                <?php if ($cart_data['cart_cpn_discount']) { ?>
                    <tr>
                        <th colspan="5" align="right">Discount <?= ($cart_data['cart_cpn_per']) ? '( ' . number_format($cart_data['cart_cpn_per'], 2, '.', ',') . '%)' : '$ 0.00' ?></th>
                        <td width="100" align="left"><?= ($cart_data['cart_cpn_discount']) ? '$ ' . number_format($cart_data['cart_cpn_discount'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_gst'] && $cart_data['cart_gst_per']) { ?>
                    <tr>
                        <th colspan="5" align="right">GST (<?= $cart_data['cart_gst_per'] ?>%)</th>
                        <td width="100" align="left"><?= ($cart_data['cart_gst']) ? '$ ' . number_format($cart_data['cart_gst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_pst'] && $cart_data['cart_pst_per']) { ?>
                    <tr>
                        <th colspan="5" align="right">PST (<?= $cart_data['cart_pst_per'] ?>%)</th>
                        <td width="100" align="left"><?= ($cart_data['cart_pst']) ? '$ ' . number_format($cart_data['cart_pst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_hst'] && $cart_data['cart_hst_per']) { ?>
                    <tr>
                        <th colspan="5" align="right">HST (<?= $cart_data['cart_hst_per'] ?>%)</th>
                        <td width="100" align="left"><?= ($cart_data['cart_hst']) ? '$ ' . number_format($cart_data['cart_hst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_del_charges']) { ?>
                    <tr class="active">
                        <th colspan="5" align="right"><strong>Delivery Charges (<?= $cart_data['cart_del_loc_name'] ?>)</strong></th>
                        <td width="100" align="left"><strong>$ <?php echo number_format($cart_data['cart_del_charges'], 2, '.', '') ?></strong></td>
                    </tr>
                <?php } ?>
                <tr class="active">
                    <th colspan="5" align="right"><strong>Total Amount</strong></th>
                    <td width="100" align="left"><strong>$ <?php echo number_format($cart_data['cart_total'], 2, '.', '') ?></strong></td>
                </tr>
                </tbody>
            </table> 
            <div class="clearfix"></div>                
            <a href="<?= site_url('empty-cart') ?>" class="btn btn-primary">Cancel Order</a>
        </div>
        <div class="col-md-4">
            <h3 class="side-heading">Customer Detail</h3>
            <table class="table">
                <tr>
                    <th>Name :</th>
                    <td><?php echo $cart_data['cart_cus_name'] ?></td>
                </tr>
                <tr>
                    <th>Tel :</th>
                    <td><?php echo $cart_data['cart_cus_phone'] ?></td>
                </tr>
                <tr>
                    <th>Email :</th>
                    <td><?php echo $cart_data['cart_cus_email'] ?></td>
                </tr>
                <tr>
                    <th><?php echo $cart_data['cart_type'] ?> Location:</th>
                    <td><?php echo $cart_data['cart_del_loc_name'] ?></td>
                </tr>
                <tr>
                    <th>Address:</th>
                    <td><?php echo $cart_data['cart_cus_address'] ?></td>
                </tr>
                <tr>
                    <th>City :</th>
                    <td><?php echo $cart_data['cart_cus_city'] ?></td>
                </tr>
                <tr>
                    <th><?php echo ucfirst($cart_data['cart_type']) ?> date:</th>
                    <td><?php echo date('M d Y', $cart_data['cart_del_date']) ?></td>
                </tr>
                <tr>
                    <th><?php echo ucfirst($cart_data['cart_type']) ?> Time:</th>
                    <td><?php echo date('h:m A', $cart_data['cart_del_time']) ?></td>
                </tr>
                <tr>
                    <th>Payment Type :</th>
                    <td><?php echo ($cart_data['cart_pay_type'] == 'cod') ? 'Cash or Credit Card, ' . $this->config->item('website_cod_note') : 'Paypal'; ?></td>
                </tr>
                <tr>
                    <th>Comments :</th>
                    <td><?php echo $cart_data['cart_cus_comments'] ?></td>
                </tr>
            </table>
            <a href="<?= site_url('online-order') ?>" class="btn btn-default">Continue Shopping</a>
            <a href="<?= site_url('order-complete') ?>" class="btn btn-primary">Confirm Order</a>
            <hr class="clearfix">
        </div>
    </div>
</div>
