<div class="well_success text-success text-center bold">
    <div class="alert alert-success" role="alert">
        <?= $order_data['order_tracking_message'] ?>
    </div>
</div>
<div id="Main_Content">
    <div class="row">
        <div class="col-md-12">
            <h3 class="side-heading">Items Detail</h3>
            <table class="table order-table table-bordered">
                <tr>
                    <th>Item Name</th>
                    <th>Qty.</th>
                    <th>Size</th>
                    <th>People</th>
                    <th>Price</th>
                    <th align="right">Total Price</th>
                </tr>
                <?php
                if ($order_products) {
                    foreach ($order_products as $order_product) {
                        ?>
                        <tr>
                            <td><?= $order_product['order_prd_name'] ?></td>
                            <td><?= $order_product['order_prd_quantity'] ?></td>
                            <td><?= $order_product['order_prd_unit'] ?></td>
                            <td><?= ($order_product['order_prd_people'] != 0) ? $order_product['order_prd_people'] . ' People' : '' ?></td>
                            <td><?= $order_product['order_prd_price'] ?></td>
                            <td align="right"><?= '$ ' . number_format($order_product['order_prd_tot_price'], 2, '.', ',') ?></td>
                        </tr>
                        <?php
                    }
                } else {
                    ?>
                    <tr>
                        <td colspan="5" class="text-center">No Item Added</td>
                    </tr>
                <?php } ?>
                <tr>
                    <th colspan="5" align="right">Subtotal</th>
                    <td width="100" align="right"><?= ($order_data['order_prd_total']) ? '$ ' . number_format($order_data['order_prd_total'], 2, '.', ',') : '$ 0.00' ?></td>
                </tr>
                <?php if ($order_data['order_cpn_discount']) { ?>
                    <tr>
                        <th colspan="5" align="right">Discount <?= ($order_data['order_cpn_per']) ? '( ' . number_format($order_data['order_cpn_per'], 2, '.', ',') . '%)' : '$ 0.00' ?></th>
                        <td width="100" align="right"><?= ($order_data['order_cpn_discount']) ? '$ ' . number_format($order_data['order_cpn_discount'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($order_data['order_gst'] && $order_data['order_gst_per']) { ?>
                    <tr>
                        <th colspan="5" align="right">GST (<?= $order_data['order_gst_per'] ?>%)</th>
                        <td width="100" align="right"><?= ($order_data['order_gst']) ? '$ ' . number_format($order_data['order_gst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($order_data['order_pst'] && $order_data['order_pst_per']) { ?>
                    <tr>
                        <th colspan="5" align="right">PST (<?= $order_data['order_pst_per'] ?>%)</th>
                        <td width="100" align="right"><?= ($order_data['order_pst']) ? '$ ' . number_format($order_data['order_pst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($order_data['order_hst'] && $order_data['order_hst_per']) { ?>
                    <tr>
                        <th colspan="5" align="right">HST (<?= $order_data['order_hst_per'] ?>%)</th>
                        <td width="100" align="right"><?= ($order_data['order_hst']) ? '$ ' . number_format($order_data['order_hst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($order_data['order_del_charges']) { ?>
                    <tr class="active">
                        <th colspan="5" align="right"><strong>Delivery Charges (<?= $order_data['order_del_loc_name'] ?>)</strong></th>
                        <td width="100" align="left"><strong>$ <?php echo number_format($order_data['order_del_charges'], 2, '.', '') ?></strong></td>
                    </tr>
                <?php } ?>
                <tr class="active">
                    <th colspan="5" align="right"><strong>Total Amount</strong></th>
                    <td width="100" align="right"><strong>$ <?php echo number_format($order_data['order_total'], 2, '.', '') ?></strong></td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>