<aside class="sidebar">
    <?php
    $cart_data = $this->cart->get_cart_detail();
    $cart_products_data = $this->cart->get_cart_products();
    ?>
    <h3 class="side-heading">Cart Detail</h3>
    <div class="cart_added">
        <table class="table cartTable table-bordered">
            <tr>
                <th>Item Name</th>
                <th>Qty.</th>
                <th>Unit</th>
                <th>People</th>
                <th>Price</th>
                <th>Action</th>
            </tr>
            <?php
            if ($cart_products_data) {
                foreach ($cart_products_data as $cart_product) {
                    ?>
                    <tr>
                        <td><?= $cart_product['cart_prd_name'] ?></td>
                        <td><?= $cart_product['cart_prd_quantity'] ?></td>
                        <td><?= $cart_product['cart_prd_unit'] ?></td>
                        <td><?= $cart_product['cart_prd_people'] . ' People' ?></td>
                        <td><?= '$ '.number_format($cart_product['cart_prd_tot_price'], 2, '.', ',') ?></td>
                        <td>
                            <a href="javascript:;" data-cart-item-id="<?= $cart_items['cart_item_id'] ?>" class="btn btn-default btn-sm amount_decrease">-</a>
                            <a href="javascript:;" data-cart-item-id="<?= $cart_items['cart_item_id'] ?>" class="btn btn-default btn-sm amount_increase">+</a>
                            <a href="javascript:;" data-cart-item-id="<?= $cart_items['cart_item_id'] ?>" class="btn btn-default btn-sm delete_item"><i class="fa fa-trash-o"></i></a>
                        </td>
                    </tr>
                    <?php
                }
            } else {
                ?>
                <tr>
                    <td colspan="5" class="text-center">No Item Added</td>
                </tr>
            <?php } ?>
        </table>
        <table class="table cartTable table-bordered">
            <tbody>
                <tr>
                    <th>Subtotal</th>
                    <td width="100" align="right"><?= ($cart_data['cart_prd_total']) ? '$ ' . number_format($cart_data['cart_prd_total'], 2, '.', ',') : '$ 0.00' ?></td>
                </tr>
                <?php if ($cart_data['cart_cpn_discount']) { ?>
                    <tr>
                        <th>Discount <?= ($cart_data['cart_cpn_per']) ? '( ' . number_format($cart_data['cart_cpn_per'], 2, '.', ',') . '%)' : '' ?></th>
                        <td width="100" align="right"><?= ($cart_data['cart_cpn_discount']) ? '$ ' . number_format($cart_data['cart_cpn_discount'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_gst'] && $cart_data['cart_gst_per']) { ?>
                    <tr>
                        <th>GST (<?= $cart_data['cart_gst_per'] ?>%)</th>
                        <td width="100" align="right"><?= ($cart_data['cart_gst']) ? '$ ' . number_format($cart_data['cart_gst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_pst'] && $cart_data['cart_pst_per']) { ?>
                    <tr>
                        <th>PST (<?= $cart_data['cart_pst_per'] ?>%)</th>
                        <td width="100" align="right"><?= ($cart_data['cart_pst']) ? '$ ' . number_format($cart_data['cart_pst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_hst'] && $cart_data['cart_hst_per']) { ?>
                    <tr>
                        <th>HST (<?= $cart_data['cart_hst_per'] ?>%)</th>
                        <td width="100" align="right"><?= ($cart_data['cart_hst']) ? '$ ' . number_format($cart_data['cart_hst'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>
                <?php if ($cart_data['cart_del_charges']) { ?>
                    <tr>
                        <th>Delivery Charges (<?= $cart_data['cart_del_loc_name'] ?>)</th>
                        <td width="100" align="right"><?= ($cart_data['cart_del_charges']) ? '$ ' . number_format($cart_data['cart_del_charges'], 2, '.', ',') : '$ 0.00' ?></td>
                    </tr>
                <?php } ?>

<!--                              <tr>
<th>
<div class="input-group">
<input type="text" class="form-control" placeholder="Coupon Code">
<span class="input-group-btn">
<button class="btn btn-primary" type="button">Apply</button>
</span>
</div>
</th>
<td width="100" align="right"> - 5%</td>
</tr>-->
                <tr class="active">
                    <th><strong>Total</strong></th>
                    <td width="100" align="right"><strong><?= ($cart_data['cart_total']) ? '$ ' . number_format($cart_data['cart_total'], 2, '.', ',') : '$ 0.00' ?></strong></td>
                </tr>
            </tbody>
        </table>
    </div>
    <hr class="clearfix">
    <form action="<?= site_url('apply-cart-coupon') ?>" method="post" name="coupon_form">
        <div class="input-group">
            <input type="text" class="form-control" name="coupon_code" placeholder="Coupon Code" required>
            <span class="input-group-btn">
                <input class="btn btn-primary" name='apply_coupon' type="submit" value="Apply">
            </span>
        </div>
    </form>
    <hr class="clearfix">
    <a href="<?= site_url('empty-cart') ?>" class="btn btn-primary">Empty Cart</a>
    <a href="<?= site_url('checkout') ?>" class="btn btn-primary">Checkout</a>
    <hr class="clearfix">
    <?php
    $promo_banners = $this->common_model->get_banners(2);
    foreach ($promo_banners as $promo_banner) {
        ?>
        <a href="<?= $promo_banner['bnr_title'] ?>" class="Advertisement"><img src="<?= $this->config->item('uploads') ?>banner_images/<?= $promo_banner['bnr_image'] ?>" alt="<?= $promo_banner['bnr_title'] ?>"></a>
        <?php } ?>
</aside>
<?php if ($this->session->flashdata('cart_coupon_messages')) { ?>
    <script>
        bootbox.alert("<?php echo $this->session->flashdata('cart_coupon_messages') ?>");
    </script>
<?php } ?>