﻿// (c) ammap.com | SVG (in JSON format) map of India - High
// areas: {id:"IN-AN"},{id:"IN-AP"},{id:"IN-AR"},{id:"IN-AS"},{id:"IN-BR"},{id:"IN-CH"},{id:"IN-CT"},{id:"IN-DD"},{id:"IN-DL"},{id:"IN-DN"},{id:"IN-GA"},{id:"IN-GJ"},{id:"IN-HP"},{id:"IN-HR"},{id:"IN-JH"},{id:"IN-JK"},{id:"IN-KA"},{id:"IN-KL"},{id:"IN-LD"},{id:"IN-MH"},{id:"IN-ML"},{id:"IN-MN"},{id:"IN-MP"},{id:"IN-MZ"},{id:"IN-NL"},{id:"IN-OR"},{id:"IN-PY"},{id:"IN-PB"},{id:"IN-RJ"},{id:"IN-SK"},{id:"IN-TN"},{id:"IN-TR"},{id:"IN-UP"},{id:"IN-UT"},{id:"IN-WB"}
AmCharts.maps.indiaHigh={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"68.140539",
				"topLatitude":"35.503357",
				"rightLongitude":"97.383106",
				"bottomLatitude":"6.741450"
			}
		},
		"g":{
			"path":[
				{
					"id":"IN-AN",
					"title":"Andaman and Nicobar Islands",
					"d":"M511.39,665.49l-0.6,3.97l-1.1,0.49l-0.44,-0.27l0.01,-0.88l-0.62,0.33l-1.09,3.28l0.18,0.19l-0.21,0.23l-1.27,-0.22l-0.15,-2.86l0.53,-2.71l0.18,-3.43l0.41,-0.89l0.5,-0.19l0.31,-1.16l-0.16,-0.64l1.05,-1.64l1.28,-0.59l0.79,0.03l0.29,0.5l0.46,3.07L511.39,665.49zM508.6,672.37l0.63,0.98l0.68,3.21l-0.13,4.23l-1.07,1.89l-0.69,-0.68l-1.06,0.42l0.21,0.74l0.58,0.58l0.15,0.9l-0.41,0.31l-1.71,-0.26l-0.66,0.3l-0.47,-0.18l-0.45,-0.91l0.67,-6.84l-0.21,-2.61l1.58,-1.78l1.28,0.22L508.6,672.37zM506.56,684.73l1.45,0.61l0.05,0.47l-0.83,2.16l-1.12,1.49l-1.07,0.41l0.28,-2.21l0.46,-0.52l-0.72,-1.62l0.69,0.09l-0.09,-0.77L506.56,684.73zM504.26,687.54l0.12,0.28l0.89,-0.21l-0.33,2.18l0.94,3.6l-0.72,5.96l-0.9,2.57l-0.86,-0.46l-1.15,-1.87l-1.91,-5.24l0.53,-1.33l0.35,-0.22l0.65,0.76l0.51,-1.04l0.38,-4.37l0.63,-1.25l0.73,-0.45l0.25,0.34L504.26,687.54zM502.54,704.79l-0.75,-0.41l0.9,-2.88l0.84,0.62l0.44,2.05l-0.54,0.45L502.54,704.79zM499.71,722.13l-0.7,0.09l-2.09,-0.57l-0.26,-3.14l0.21,-1.99l1.62,-1.53l1.28,-0.77l0.67,0.7l0.95,3.45l-0.84,2.59L499.71,722.13zM505.7,750.95l-1.14,-0.03l-0.46,-0.75l0.08,-0.96l0.95,-1.08l0.96,1.08l0.13,0.96L505.7,750.95zM521.04,773.39l-1.06,0.97l-0.75,-2.99l0.01,-0.54l0.74,-1.11l0.68,-0.2l0.36,0.35l-0.28,2.05L521.04,773.39zM519.51,776.48l-0.14,0.38l-2.21,-0.3l-0.76,-0.86l0.14,-1.44l1.42,-0.44l1.2,1.51L519.51,776.48zM524.99,788.07l-1.86,1.59l-0.33,-0.07l-0.49,-1.17l0.44,-1.25l1.26,-0.46l0.3,-0.96l0.04,0.54l0.81,0.97L524.99,788.07zM528.52,798.68l-1.48,1.26l-0.34,-0.15l-0.94,-3.44l-0.97,-1.41l-1.43,-0.89l-0.08,-1.77l0.59,-1.34l2.8,-1.08l1.09,0.76l1.38,5.14L528.52,798.68z"
				},
				{
					"id":"IN-AP",
					"title":"Andhra Pradesh",
					"d":"M248.82,549.29l0.39,0.02l0,0l0.33,0.26l0,0l1.01,2.34l3.06,-0.5l1.56,0.69l0,0l2.06,1.98l0,0l1.67,2.18l0,0l0.3,1.99l-0.19,1.79l-0.29,0.4l0,0l2.35,1.78l0,0l1.86,1.08l0,0l1.09,5.75l0.88,0.69l0,0l0.68,-0.4l0,0l1.66,-1.3l2.74,0.88l4.69,0.08l0,0l1.81,-0.16l2.2,-0.85l0.97,-1.69l1.76,-0.8l1.56,-0.3l1.17,-1.2l2.34,-1.1l1.17,0.29l1.18,1.29l0.59,0.2l1.75,-1.99l0,-1.69l-0.78,-0.89l0.68,-1.39l0.67,-3.78l1.36,-1.75l0.59,-0.15l1.22,0.69l0.15,1.49l1.18,3.28l0.78,0.69l4.58,-4.2l2.15,1.38l2.39,-0.76l0.33,-2.84l-0.98,-1.29l-0.3,-1.49l2.04,-2.6l0.49,-0.1l0.88,0.49l1.27,-0.21l2.34,-1.31l0.78,-1l-0.69,-1l-1.12,-0.2l-0.25,-1.1l0.83,-0.8l1.81,0.89l1.56,-0.91l1.44,-1.7l-0.22,-0.8l1.12,-0.55l2.45,4.03l0.29,-1l0.68,0.3l0.29,0.6l-0.09,3.69l2.15,0.59l1.85,-0.61l1.76,0.89l1.66,-0.01l2.68,-0.76l2.58,-2.75l0.09,-1.2l3.12,-3.41l2.25,0.29l1.04,0.67l0,0l-0.18,0.41l0.5,0.63l0.46,-0.42l-0.1,0.72l-1.71,2.58l-0.83,0.57l-2.9,3.88l-8.57,10.08l-6.24,2.72l-3.92,2.67l-7.12,9.06l-1.5,0.94l-3.09,1.31l-2.59,1.69l-2.19,0.77l-3.33,1.73l-2.87,1.9l-2.32,2.22l-1.37,1.67l-0.96,2.31l0.53,1.09l1.88,0.64l0.08,-0.82l-0.47,3.5l-0.92,2.59l-2.11,1.57l-4.31,2.2l-5.37,2.01l-1.57,-0.51l-4.53,-0.71l-0.36,-0.37l-1.87,0.39l-1.5,1.12l-1.72,5.27l-0.28,2.04l-2.3,1.77l-0.78,0.99l0.27,1.2l-2.29,-1.69l0.13,-2.43l-0.09,-0.64l-0.43,-0.08l0.29,1.96l-0.18,0.89l-1.29,2.67l-0.4,-1.92l-0.59,-0.75l-1.9,-0.47l-2.62,0.47l-3.9,2.2l-1.8,1.59l-1.44,3.56l-2.37,4.55l-0.92,5.5l1.22,6.24l1.77,4.3l-0.41,4.36l-1,3.12l0.52,3.46l1.99,4.95l-0.42,2.72l1.75,4.47l-0.1,0.4l-1.2,-2.84l-2.01,-3.03l-1.27,0.62l-0.85,1.42l1.42,2.54l0,0l-1.51,-0.2l-1.24,1.07l-0.64,1.76l-4.14,3.79l-4.26,-2.76l-1.33,-0.17l-1.8,0.63l1.19,0.36l0.55,1.27l-0.44,0.66l-1.83,0.99l-1.77,0.22l-1.83,1.37l-1.77,0.88l-2.77,-1.1l-1.5,-0.28l-3.27,0.43l-2.39,1.59l-0.01,3.79l-3.22,4l-3.76,-1.38l-0.55,-1.65l0,0l2.45,-3.49l2.37,1.56l0.19,-0.43l-0.4,-0.62l-0.17,-2.41l1.62,-1.53l0.51,-1.72l0.32,-1.85l-0.33,-0.71l-0.72,0.83l-3.24,-1.42l0.12,-3.8l0.32,-1.61l-3.41,0.22l-2.78,-1.42l-0.46,-0.71l0.35,-1.23l0.59,-0.77l0.05,-1.76l-1.11,-0.6l-1.68,0.45l-0.74,-0.38l-0.05,-1.36l-2.82,0.32l0.14,1.7l-0.57,1.05l-2.76,0.44l-0.47,0.49l0.06,0.5l-3.66,0.43l0.08,-1.61l-0.64,-0.96l-4.92,-0.44l-0.33,2.1l-3.5,0.51l-0.45,-1.91l0.87,-0.86l0.54,-1.17l-1.08,-0.72l-0.67,-1.09l-1.15,-2.95l2.23,-0.54l0.28,0.44l-0.41,1.17l0.58,0.99l1.85,0.51l0.4,0.59l3.28,-0.51l1,2.54l0.99,0.41l0.71,-0.4l-0.36,-1.49l-1.05,-1l-0.48,-1.98l1.55,-0.98l1.61,0.32l0.22,-0.4l-0.39,-2.08l-1.82,-1.47l-0.41,1.21l-1.67,0.05l-1.36,-0.75l-1.24,-0.25l-0.65,0.06l-0.41,0.62l-0.2,1.61l-0.44,0.25l-3.09,-0.64l-1.47,-2.74l1.26,-0.81l0.74,-1.34l-0.31,-0.37l-1.92,0.05l-1.51,-1.25l-0.58,-1.56l0.46,-3.16l1.18,-0.55l0.38,-1.43l-0.02,-1.77l-2.38,-0.6l0.7,-2.17l0.45,-0.36l1.09,0.61l0.37,0.53l3.9,0.49l1.3,-0.61l0.98,-2.26l-0.32,-2.21l-2.03,-2.25l-1.52,-3.12l1.26,-2.8l0.87,-0.18l0.49,0.25l-0.66,-2.94l-1.23,-1.52l1.36,-1.87l1.37,-0.55l1.5,-0.21l3.13,0.6l2.62,0.1l-0.65,-4.44l0.2,-2.19l0.87,-0.56l1.05,0.01l0.13,-0.47l-0.41,-0.78l-1.21,-0.71l-3.21,-0.28l-1.59,-0.58l-0.51,-0.89l1.46,-0.49l1.07,-0.04l1,-0.79l1.03,-1.55l0.12,-4.42l-0.51,-1.58l0.09,-1.9l-0.54,-2.91l-0.82,-0.54l-0.22,-1.23l0.22,-0.7l0.94,-1.84l2.38,-2.8l2.32,-0.96l-1.83,-1.64l-2.27,-1.2l0.78,-4.39l2.04,-1.28l1.19,-1.59l0.06,-0.6l-0.95,-0.73l-0.95,-3.5l0.31,-2.23l0,0l0.31,-0.76l-0.59,-2.68l1.36,-2.2l2.29,0.18l-0.2,-1.9l-0.36,-0.82l0.25,-0.93l1.73,-2.22l0.9,-0.56l1.5,-0.06l0.67,-1.01l-2.11,-2.27l-0.49,-1.89l0.97,-1.3l0.97,-2.9l-0.39,-1.3l1.66,-0.71l0.78,0.3l1.47,1.89l1.37,-0.01l0.88,-0.45l-0.15,-3.4l2.73,-1.01l-0.35,-4.66l1.46,-1.31l0.08,-1.46l2.82,-0.14l6.51,1.26l1.01,0.55l-0.64,1.05l2.45,1.49l1.96,0.09l2.64,-1.01l1.66,0.49l0.69,1l4.73,1.88h0.77l0.22,-0.96l2.35,-1.06l1.45,0.28l2.71,2.32l0.82,1.61l-0.56,5.25l-1.61,1.39v1.47l1.33,-0.31l0.61,1.55l0.16,2.36l0.62,1.78l1.94,1.96l1.76,0.25l1.26,-0.2L248.82,549.29zM290.7,591.45l-1.82,-0.71l-0.36,0.65l0.76,0.59l1.43,-0.07L290.7,591.45z"
				},
				{
					"id":"IN-AR",
					"title":"Arunachal Pradesh",
					"d":"M593.1,348.38L599.55,343.97L599.95,342.8L599.53,341.6L598.64,340.58L599.3,337.45L598.44,337.19L597.45,336.19L597.09,336.24L596.74,335.66L595.71,335.68L595.26,334.87L594.04,334.04L593.23,334.31L592.07,335.28L591.2,334.77L587.68,334.03L586.9,332.81L585.11,331.81L583.67,331.85L582.09,332.92L581,332.92L580.48,333.57L580.3,334.48L579.82,334.63L579.04,333.49L578.18,333.66L577.87,333.23L577.03,333.03L578.78,331.65L578.61,330.51L578.3,330.23L578.9,329.61L579.96,329.27L579.85,328.83L580.47,328.89L581.73,327.58L581.32,326.64L583.17,326.08L584.25,324.88L584.1,324.09L581.56,320.12L581.42,319.52L581.79,318.54L581.28,318.06L580.56,318.5L578.74,318.63L576.76,320.76L575.22,321.68L574.6,320.84L574.68,318.11L573.97,317.57L575.15,317.31L576.11,315.94L578.78,315.14L579.66,313.36L579.03,312.74L577.63,313.87L576.62,313.88L575.38,312.15L575.33,311.16L574.65,310.13L573.37,308.57L573.05,308.56L570.74,310.43L569.9,310.33L567.45,311.52L567.29,311.37L564.19,313.54L563.88,313.45L562.24,314.89L562.32,316.37L561.87,316.21L560.43,318.52L559.52,318.58L557.11,317.91L556.57,318.03L556.23,317.58L553.87,316.67L550.74,316.11L548.16,315.08L546.96,315.53L546.81,314.09L545.17,312.26L543.87,311.58L542.76,313.01L542.51,313.97L541.64,314.36L539.36,314.34L538.17,315.19L537.91,315.81L536.91,316.08L535.4,317.66L533.71,321L531.02,323.2L529.8,327.09L527.68,326.59L526.57,326.72L525.97,327.1L525.08,326.89L523.35,327.59L521.02,327.33L520.37,326.85L519.87,327.07L519.8,327.45L519.5,327.23L517.29,328.26L516.81,328.81L516.64,330.08L514.49,332.92L514.95,333.63L514.94,334.66L514.62,335.21L510.8,335.58L510.54,335.77L510.76,336.52L510.07,337.26L509.48,336.58L507.76,338.01L506.51,338.63L506.22,337.92L504.05,339.42L503.4,340.74L504.34,341.65L504.72,342.85L503.28,344.91L501.96,345.44L501.05,346.74L500.71,346.82L499.84,346.27L498.88,347.15L498.12,346.76L497.4,346.91L497.34,347.34L495.86,347.7L494.96,345.88L494.83,346.77L492.1,346.91L489.85,348.73L488.43,348.85L487.88,349.18L487.67,348.92L487.06,349.03L485.95,348L482.53,348.04L482.46,349.15L481.32,350.45L481.35,351.48L481.99,353.3L482.9,354.43L484.85,355.71L488.69,355.19L489.42,354.7L491.38,357.6L491.89,358.89L490.46,361.3L489.86,361.76L489.75,363.29L489.91,363.8L491.01,364.77L491.62,366.09L491.87,367.21L491.22,368.61L491.22,368.61L493.29,368.75L498.76,367.65L502.77,365.95L506.18,367.89L509.92,367.77L513.29,368.05L516.22,367.38L516.9,366.29L518.79,366.39L519.72,367.1L523.74,366.27L524.85,365.73L526.83,364.1L527.03,363.24L526.84,362.42L527.32,361.6L530.82,357.79L536.05,353.83L535.83,352.57L536.38,352.26L540.31,352.13L542.36,351.75L546.23,350.52L549.15,348.89L557.6,345.49L558.39,345.26L560.27,345.99L562.87,345.14L565.56,343.35L571.54,343.08L571.37,343.94L570.33,345.43L567.55,348.56L567.46,349.35L567.99,351.63L568.77,352.43L569.87,352.91L569.68,355.57L570.07,356.44L571.49,355.59L572.27,355.91L572.73,356.77L570.98,359.58L570.19,359.73L569.48,359.34L566.96,359.71L565.07,360.48L563.66,360.31L563.11,359.76L562.05,359.95L560.88,362.4L559.78,363.18L555.51,365.02L555.5,365.73L555.04,365.41L551.87,367.65L551,367.72L549.44,367.24L548,369.5L545.78,371.43L544.43,372.05L542.86,372.27L541.36,373.04L540.17,373.73L539.22,374.89L539.22,374.89L539.21,375.23L539.21,375.23L539.22,374.91L545.67,375.79L549.15,377.16L552.46,379.54L552.46,379.54L552.46,377.6L554.08,374.39L555.99,373.02L556.31,372.95L556.47,373.62L560.24,372.2L561.52,369.9L561.89,369.63L563.54,369.66L564.87,367.94L567.64,365.56L569.82,364.91L570.84,363.78L572.23,361.32L573.64,360.29L575.54,359.43L580.37,358.63L581.81,358.68L584.38,357.22L586.52,357.23L588.48,358.24L589.72,361.43L592.11,362.55L593.37,363.48L594.92,363.62L595.4,362.68L590.16,355.12L589.81,351.84L590.75,350.4z"
				},
				{
					"id":"IN-AS",
					"title":"Assam",
					"d":"M491.22,368.61L493.29,368.75L498.76,367.65L502.77,365.95L506.18,367.89L509.92,367.77L513.29,368.05L516.22,367.38L516.9,366.29L518.79,366.39L519.72,367.1L523.74,366.27L524.85,365.73L526.83,364.1L527.03,363.24L526.84,362.42L527.32,361.6L530.82,357.79L536.05,353.83L535.83,352.57L536.38,352.26L540.31,352.13L542.36,351.75L546.23,350.52L549.15,348.89L557.6,345.49L558.39,345.26L560.27,345.99L562.87,345.14L565.56,343.35L571.54,343.08L571.37,343.94L570.33,345.43L567.55,348.56L567.46,349.35L567.99,351.63L568.77,352.43L569.87,352.91L569.68,355.57L570.07,356.44L571.49,355.59L572.27,355.91L572.73,356.77L570.98,359.58L570.19,359.73L569.48,359.34L566.96,359.71L565.07,360.48L563.66,360.31L563.11,359.76L562.05,359.95L560.88,362.4L559.78,363.18L555.51,365.02L555.5,365.73L555.04,365.41L551.87,367.65L551,367.72L549.44,367.24L548,369.5L545.78,371.43L544.43,372.05L542.86,372.27L541.36,373.04L540.17,373.73L539.22,374.89L539.22,374.89L539.21,375.51L539.21,375.51L538.97,376.13L538.97,376.13L538.57,376.83L538.57,376.83L537.77,377.84L537.77,377.84L537.29,378.3L536.83,377.52L536.83,377.52L536.6,376.82L536.6,376.82L536.14,375.88L535.18,377.19L534.21,379.83L531.35,383.07L530.62,385.01L530.62,385.01L530.46,385.55L530.46,385.55L529.87,388.96L529.87,388.96L530.09,390.35L530.09,390.35L530.4,390.82L530.4,390.82L529.85,391.44L529.85,391.44L528.66,392.04L528.66,392.04L526.14,392.88L525.83,392.26L526.01,390.01L526.01,390.01L525.3,390.01L525.3,390.01L524.2,390.23L523.8,391.16L520.05,396.31L518.31,397.22L516.48,398.99L517.8,401.23L518.66,401.55L519.04,402.01L519.12,402.71L519.12,402.71L518.71,404.32L518.71,404.32L518.62,405.09L519.4,405.56L519.4,405.56L518.59,405.97L517.75,407.19L515.61,413.3L514.14,415.59L512.98,416.21L511.75,417.58L512.07,418.8L511.92,420.01L510.93,424.57L510.62,424.73L510.62,424.73L507.06,425.28L506.67,424.97L506.27,423.38L505.18,422.18L505.03,423.47L502.57,428.07L499.64,430.47L498.79,430.62L498.55,430.25L498.42,428.39L495.83,428.37L495.83,428.37L493.96,428.45L494.96,425.65L494.64,423.45L494.17,422.69L492.44,421.67L492.44,421.67L493.41,420.86L494.65,416.82L494.94,415.44L494.65,413.4L495.39,413.14L497.55,414.43L498.51,414.42L499.64,413.79L499.57,412.88L498.2,411.78L498.01,410.72L498.01,410.72L500.91,408.32L503.63,406.85L506.02,406.22L505.71,403.71L504.24,401.98L502.71,401.77L501.28,399.88L502.13,398.35L498.11,394.13L494.54,394.85L492.96,395.94L493.12,389.41L494.84,387.21L492.9,386.93L488.65,388.2L485.96,386.7L485.35,386.63L483.76,387.18L480.81,388.36L479.18,391.52L476.15,392.31L474.43,394.39L473.52,394.71L473.14,394.41L472.96,392.65L469.83,392.54L469.49,392.2L469.58,390.78L464.08,389.62L460.81,389.89L459.12,388.53L456.67,388.18L451.52,389.46L449.41,391.01L447.4,394.39L448.67,397.58L446.79,398.89L445.46,399.4L445.46,399.4L445.7,396.42L444.57,392.45L445.42,390.55L445.03,388.44L443.05,384.87L442.06,384.79L441.32,384.11L441.32,384.11L443.07,381.8L444.38,380.88L444.86,378.28L444.73,372.79L444.27,372.32L444.27,372.32L451.57,371.21L452.13,370.79L452.27,369.88L452.96,369.03L456.49,367.83L460.09,370.08L463.05,370.82L470.05,370.45L471.49,369.98L473.78,370.05L475.34,370.69L476.74,370.1L477.59,368.56L479.32,368.65L480.17,370.07L483.71,370.17L486.23,368.75L490.19,369z"
				},
				{
					"id":"IN-BR",
					"title":"Bihar",
					"d":"M403.15,407.84L402.46,407.8L400.24,406.18L396.54,404.85L396.69,406.47L395.8,406.47L395.65,407.95L392.55,407.8L390.77,411.21L389.15,411.65L388.85,414.46L388.11,416.38L387.37,416.97L387.08,419.78L386.49,421.41L385.16,421.41L384.27,423.63L382.05,421.85L381.16,422.89L379.54,423.63L378.95,422L377.91,422L377.32,423.18L376.58,423.48L375.69,426.58L374.51,427.17L373.77,426.29L372.59,426.29L372.29,422.74L371.26,422.44L369.04,423.18L369.04,419.93L368,419.19L367.41,417.86L365.49,418.6L363.72,418.6L362.68,417.56L361.05,417.56L360.61,419.63L359.87,420.08L359.13,422.15L357.36,422.44L356.77,424.22L352.63,424.22L352.03,424.66L351.15,426.14L348.63,425.84L347.75,427.47L344.79,426.29L344.05,424.51L342.13,424.22L341.83,425.7L340.8,426.58L338.87,426.58L338.73,428.51L336.66,428.36L334.88,427.47L334.14,426.58L334.14,424.81L332.66,423.33L331.63,423.77L330.59,424.66L329.41,424.37L327.78,422.15L326.45,421.7L326.31,422.74L325.42,423.63L317.43,423.33L315.08,421.9L315.08,421.9L315.82,421.48L315.82,421.48L316.37,419.74L316.37,419.74L315.81,417.79L314.98,416.74L314.98,416.74L313.58,415.04L311.3,409.97L311.3,409.97L312.26,406.08L313.57,404.54L313.57,404.54L314.49,404.02L314.49,404.02L320.43,401.77L321.61,400.43L321.61,400.43L322.56,399.18L325.46,397.28L325.46,397.28L326.49,396.8L327.44,394.88L327.44,394.88L327.94,394.63L333.66,395.2L333.66,395.2L335.35,395.79L337.49,394.84L337.49,394.84L337.71,393.89L337.71,393.89L335.26,391.48L332.19,389.72L329.06,388.6L326.69,385.43L326.27,383.71L326.9,383.17L329.35,382.53L329.35,382.53L329.34,380.22L328.32,379.73L328.32,379.73L327.45,379.7L324.2,378.02L324.2,378.02L323.93,377.49L323.93,377.49L324,376.36L325.35,376.09L325.35,376.09L325.75,376.28L325.75,376.28L326.88,376.31L327.3,375.21L327.3,375.21L327.6,374.27L328.76,374.14L329.86,374.41L329.86,374.41L333.89,374.51L333.89,374.51L333.84,373.13L333.84,373.13L331.57,371.44L330.77,370.26L330.77,370.26L330.71,368.7L330.32,368.33L328.49,369.29L328.49,369.29L327.13,368.23L326.76,367.56L326.76,367.56L326.69,366.03L326.69,366.03L325.01,360.72L325.01,360.72L323.63,358.98L323.63,358.98L322.75,358.46L322.75,358.46L322.23,358.13L322.23,358.13L322.78,356.78L322.77,355.51L323.81,355.25L325.8,355.45L328.42,353.88L331.51,356.71L337.68,357.82L338.5,358.48L339.46,360.89L339.35,362.51L338.66,364.21L338.85,364.69L340.86,365.45L341.86,365.27L342.95,365.72L349.73,370.24L350.48,371.04L352.65,371.65L358.86,368.68L360.5,369.82L360.91,370.49L360.88,373.08L361.38,373.79L363.58,375.38L365.74,373.66L367.12,373.32L369.28,374.68L370.21,374.58L370.64,375.04L373.3,374.58L381.49,378.86L383.29,378.49L384.73,377.57L384.92,377.03L385.89,376.34L387.05,376.26L388.69,377.35L390.45,379.32L392.49,379.89L396.3,378.56L400.15,379.49L401.05,378.75L403.2,377.98L405.31,377.74L406.4,379.27L407.89,380.04L409.34,378.57L409.68,377.3L409.57,376.35L410.67,375.99L411.47,376.29L412.74,378.58L413.18,380.24L406.95,384.67L403.98,387.78L403.71,390.24L403.98,390.88L407.22,394.16L407.88,394.35L408.83,395.53L408.48,398.5L408.48,398.5L408.13,399.3L406.22,398.71L406.22,398.71L405.43,399.03L403.17,401.58L403.46,403.25L403.46,406.42z"
				},
				{
					"id":"IN-CH",
					"title":"Chandigarh",
					"d":"M178.54,277.52L178.21,279.82L178.21,279.82L177.43,280.31L176.11,279.59L175.43,278.54L175.95,277.83L176.79,277.33L177.96,277.7z"
				},
				{
					"id":"IN-CT",
					"title":"Chhattisgarh",
					"d":"M258.25,491.73L259.62,490.09L260.06,488.32L259.77,485.8L259.17,483.88L260.95,483.88L261.84,483.14L261.98,481.66L261.25,478.11L262.87,477.67L263.02,475.01L265.39,475.6L265.68,473.68L264.94,473.09L265.83,471.31L267.46,471.17L267.31,466.88L268.93,467.17L270.71,466.73L272.19,465.99L274.11,466.73L275,465.55L276.33,464.96L277.51,464.96L277.66,463.62L280.62,462.29L280.47,460.37L280.91,459.34L281.8,459.04L282.39,458.15L282.83,455.49L284.02,454.9L284.02,454.16L286.38,454.16L287.86,453.27L288.3,451.79L288.16,449.28L286.53,447.65L285.35,445.88L284.31,446.03L284.02,444.7L282.98,443.96L282.24,444.7L281.21,443.51L279.58,443.51L278.1,444.25L277.07,443.22L276.62,442.04L278.1,440.26L278.99,438.63L277.36,437.16L277.21,436.27L278.25,435.23L279.88,435.97L280.17,436.86L281.5,437.16L283.28,436.71L287.12,436.71L288.45,437.01L289.49,438.04L291.56,437.6L292.3,438.04L294.66,438.19L295.7,439.52L296.58,437.45L298.06,437.6L298.8,435.09L300.43,434.94L300.76,434.38L300.76,434.38L301.24,434.74L301.24,434.74L303.01,435.75L304.14,436L304.14,436L307.41,435.73L308.29,435.09L308.29,435.09L308.67,434.2L308.67,434.2L308.91,432.54L311.55,431.01L312.05,431.13L312.05,431.13L313.7,432.52L315.47,435.69L317.48,436.32L317.99,436.82L318.5,437.96L318.75,440.88L319.39,441.63L322.66,442.25L323.48,442L323.29,440.98L323.79,440.47L324.42,440.22L324.92,440.72L325.3,442.62L324.3,444.14L324.37,446.49L324.94,446.54L325.5,446.04L327.24,449.95L329.37,452.88L332.36,453.72L333.32,453.52L334.08,453.71L334.46,454.34L334.69,455.91L333.57,456.52L332.48,457.87L331.92,459.55L330.22,461.26L328.92,461.33L328.42,461.69L326.92,463.54L327.39,466.31L327.39,466.31L327.39,466.31L327.39,466.31L326.73,467.63L326.05,468.18L326.05,468.18L324.3,468.26L323.18,469.58L321.5,470.87L321.5,470.87L320.36,470.69L319.88,471.05L318.63,473.02L317.82,475.63L318.35,477.03L318.35,477.03L318.86,477.69L318.86,479.22L317.85,480.43L317.85,480.43L317.46,480.1L316.77,480.68L316.77,480.68L316.66,483.79L316.66,483.79L316.21,484.37L315.67,484.24L315.14,484.72L313.92,486.79L314.22,487.72L315.11,488.52L315.11,488.52L315.28,489.81L315.28,489.81L314.88,490.87L314.88,490.87L312.59,490.46L311.04,494.54L311.04,494.54L309.67,495.77L301.4,494.84L299.83,495.32L299.83,495.32L297.31,499.54L297.31,499.54L296.97,501.82L296.97,501.82L296.75,502.32L295.25,502.29L295.25,502.29L294.82,501.74L293.49,501.38L293.49,501.38L293.45,502.3L293.45,502.3L294.45,509.54L295.13,511.71L295.13,511.71L295.59,513.61L295.59,513.61L295.74,514.39L295.33,515.66L295.33,515.66L295.02,517.83L295.02,517.83L295.22,519.28L295.58,519.58L299.33,521.22L301.01,520.5L301.64,520.95L301.96,523.99L301.96,523.99L299.69,525.7L299.69,525.7L299.05,525.21L299.12,524.32L299.12,524.32L297.94,523.99L295.54,524.24L294.87,524.71L294.87,524.71L294.35,524.59L293.85,524.02L291.8,520.93L291.8,520.93L291.14,521L291.14,521L290.91,521.4L287.33,520.63L287.33,520.63L286.14,519.43L286.14,519.43L286.12,518.88L285.53,518.81L283.76,520.08L283.3,520.88L283.3,521.85L283.85,522.97L283.85,522.97L285.65,524.04L285.65,524.04L287.65,525.69L287.75,527.45L287.75,527.45L287.75,531.86L290.84,533.87L290.53,537.47L291.36,540.81L291.36,540.81L292.17,543.94L292.07,544.88L290.64,547.38L288.74,549.01L287.06,549.58L285.41,550.77L285.41,550.77L285.69,552.4L282.08,556.89L282.08,556.89L279.46,559.09L278.75,559.16L277.76,560.03L277.71,562.22L276.81,565.52L276.81,565.52L276.15,567.05L276.15,567.05L275.34,567.69L274.66,569.01L269.97,568.93L267.23,568.05L265.57,569.34L265.57,569.34L264.89,569.74L264.89,569.74L264.01,569.05L262.92,563.3L262.92,563.3L261.06,562.22L261.06,562.22L258.71,560.44L258.71,560.44L259,560.04L259.2,558.25L258.9,556.27L258.9,556.27L257.23,554.09L257.23,554.09L255.18,552.1L255.18,552.1L253.61,551.41L250.55,551.91L249.54,549.57L249.54,549.57L249.21,549.31L249.21,549.31L248.82,549.29L248.43,548.32L249.88,547.5L249.88,547.5L250.65,546.88L249.13,544.88L249.13,544.88L248.94,543.46L249.59,542.41L249.59,542.41L250.13,541.41L250.13,541.41L250.17,539.96L251.54,537.77L251.54,537.77L253.26,535.93L253.26,535.93L254.57,534.83L255.22,534.62L255.22,534.62L255.79,536.24L258.7,538.36L262.07,535.74L263.44,532.83L263.29,532.31L263.29,532.31L260.73,530.55L258.19,529.93L258.22,529.35L258.8,528.71L258.63,528.08L258.63,528.08L255.21,525.25L255.21,525.25L254.53,525.67L254.74,526.44L254.32,526.74L253.71,526.62L253.71,526.62L252.62,526.1L254.46,522.91L254.46,522.91L255.59,522.43L255.82,521.74L255.82,521.74L256.13,518.14L256.13,518.14L254.13,518.47L254.13,518.47L253.44,518.84L252.88,518.32L252.88,518.32L252.83,516.25L254.87,514.97L256.95,514.32L257.25,513.63L257.46,508.9L257.46,508.9L256.93,508.35L256.93,508.35L256.22,508.27L255.56,508.65L254.9,508.32L254.67,507.8L254.67,507.8L255.18,507.07L255.18,507.07L256.32,506.47L255.57,501.01L255.27,500.56L255.27,500.56L254.3,500.81L254.3,500.81L253.75,499.1L253.65,496.29L253.93,495.46L255.99,494.13L255.99,494.13L258.45,491.79L258.45,491.79z"
				},
				{
					"id":"IN-DD",
					"title":"Daman and Diu",
					"d":"M96.69,511.41L98.07,512.04L98.07,512.04L98.46,513.96L96.96,514.19L95.29,513.87L96.01,513.25L96.21,511.91z"
				},
				{
					"id":"IN-DL",
					"title":"Delhi",
					"d":"M185.56,323.01L186.02,323.59L186.02,323.59L186.34,326.63L186.34,326.63L186.86,328.19L186.86,328.19L188.28,330.27L188.28,330.27L189.09,330.92L189.09,330.92L187.22,331.5L186.99,332.77L185.72,332.96L184.33,331.09L182.42,330.11L181.45,330.64L179.46,330.97L178.56,329.46L179.67,328.2L180.18,328.1L180.88,326.95L180.9,323.86L183.55,322.48z"
				},
				{
					"id":"IN-DN",
					"title":"Dadra and Nagar Haveli",
					"d":"M103.07,517.02l1.75,1.25l0,0l0,0l0,0l-0.11,0.72l0,0l-0.43,0.18l-0.61,1.32l-2.7,-0.24l-0.61,-0.26l-0.96,-1.05l-0.09,-1.23l0,0l1.43,-2.05l1.52,-1l0.51,-0.01l0,0l0,0l0,0l0.66,1.01L103.07,517.02zM100.33,515.02l-0.5,0.27l-0.07,-0.32L100.33,515.02z"
				},
				{
					"id":"IN-GA",
					"title":"Goa",
					"d":"M124.76,613.17L123.7,614.29L124.07,614.86L124.75,614.89L125.03,614.25L126.79,614.81L127.02,617.21L126.7,618.55L126.94,619.86L127.83,621.17L127.91,622.42L126.7,622.85L127.27,625.34L126.81,629.13L126,629.69L125.08,629.49L122.3,631.24L122.3,631.24L119.37,627.05L119.23,625.01L118.29,622.07L117.47,621.03L116.34,620.56L115.89,620.01L118.53,619.99L119.4,620.72L119.19,620.02L117.02,619.04L115.99,618.93L115.41,618.13L113.72,613.53L114.01,613.17L114.01,613.17L115.41,613.1L116.37,612.58L117.24,611.58L119.34,613.84L119.52,615.04L120.13,615.89L121,616.14L122.48,615.35L122.13,614.84L122.3,614.32L123.51,612.84L124.25,612.62z"
				},
				{
					"id":"IN-GJ",
					"title":"Gujarat",
					"d":"M81.29,418.58l0.61,1.19l2.42,-0.13l0,0l0.4,0.49l-0.39,1.01l0,0l0,0l0,0l3.32,1.07l2.72,0.07l2.42,1.17l0,0l0.61,1.29l0,0l1.21,0.79l3.52,-0.24l0.7,-0.81l0.6,-1.71l2.41,-0.33l0,0l0,0l0,0l0.82,3.79l-1.4,2.62l0.31,1.3l0,0l0,0l0,0l3.03,3.06l0.6,0.19l1.8,-2.12l0.91,0.99l0,0l0,0l0,0l0.52,3.09l-0.5,0.5l-0.6,0.11l-0.4,1l0.21,1.1l0.41,0.49l0,0l0,0l0,0l2.62,1.37l0,0l1.02,1.98l1.31,0.09l0,0l0.81,1.18l-0.49,2.4l0,0l0,0l0,0l1.91,0.78l1.11,-0.31l0.91,0.19l0,0l1.31,1.57l0,0l1.11,0.69l0.1,-0.5l0.7,-0.11l1.81,0.97l1.31,1.27l0,0l0.21,1.69l0,0l2.21,-0.22l0,0l1.12,1.97l0,0l1.01,0.58l0.34,1.34l0,0l0,0l0,0l1.89,-0.5l0,0l0.15,0.89l-2.51,4.96l-0.7,0.28l-1,-0.25l0,0l-0.99,0.41l-1.27,1.27l-2.96,0.69l-0.25,1.23l1.68,1.61l1.94,-0.52l1.15,0.67l-0.15,0.51l-2.59,1.17l0,0l-0.4,-0.29l0,0l-0.48,-0.78l-0.51,-0.09l0,0l-0.18,2.18l0,0l0.23,1.37l0.83,0.48l0.68,2.83l0,0l-0.36,0.83l0,0l-0.56,0.4l-0.08,0.58l1.1,3.48l-1.61,0.48l-3.46,1.84l-0.02,2.08l0.88,2.22l-2.18,0.73l0.79,2.31l0.44,0.53l0,0l0,0l0,0l0.48,0.09l0.26,-0.49l3,-0.95l3.57,0.42l2,-0.37l0,0l0,0l0,0l-0.13,1.11l-0.74,0.67l-1.48,0.28l-2.44,-0.07l-2,1.35l-0.35,0.36l-0.38,2.18l-3.17,2.37l-1.83,0.81l-0.76,-0.02l-1.29,-0.77l1.36,2.21l0,0l0,0l0,0l0.88,0.44l0.52,0.09l0.35,-0.27l1.22,0.44l0,0l0,0l0,0l1.58,2.38l0.97,2.69l-0.13,1.64l-2.34,3.11l-1.35,0.72l-1.57,0.19l-3.75,-2.71l0,0l-0.3,-0.35l0,0l-1,1.42l1.22,1.85l-1.38,4.25l-0.38,3.53l-2.74,1.78l-0.69,-0.43l0,0l0,0l0,0l0.11,-0.72l0,0l0,0l0,0l-1.75,-1.25l0.36,-1.36l-0.66,-1.02l0,0l0,0l0,0l-0.51,0.01l-1.52,1l-1.43,2.05l-1.7,-0.78l-0.91,1.77l-0.43,0.27l-0.78,0.09l-1.36,-0.44l0,0l0,0l0,0l0.48,-3.33l0.63,-1.32l1.73,0.24l1.5,-0.23l-0.39,-1.93l0,0l-1.38,-0.63l0,0l0.63,-0.98l1.05,-5.8l-0.26,-0.85l-0.74,0.09l-0.79,-0.73l0.11,-4.85l-0.95,-1.32l-1.73,0.95l-1.96,-0.07l-0.28,-0.46l0.29,-0.51l1.79,-1.56l-1.43,-1.26l-0.6,0.15l-1.04,-2.69l3.79,-1.95l-0.71,-0.24l-2.53,1.25l0.81,-1.67l3.82,-3.06l1.72,-0.21l4.43,-2.01l0.2,-0.5l-1.4,0.4l-2.51,1.28l-3.33,0.24l-0.64,-0.32l-2.57,0.01l-1.47,0.46l-0.41,-0.4l0.5,-1.33l0.33,-2.27l1.2,-1.77l0.49,-0.29l0.6,0.2l0.57,-0.46l0.35,-0.85l-2.05,0.66l-1.72,1.09l-0.76,-1.41l0.72,-3.58l0.9,-1.33l0.73,-0.22l1.3,0.64l1.47,0.28l1.27,-1.53l0.73,0.03l0.78,0.47l0.61,-0.13l-0.04,-1.14l-1.98,-0.02l-0.68,0.38l-4.13,-0.68l-2.37,1.27l-1.62,-0.53l-0.28,-1.04l-2.59,0.03l-1.94,0.36l0.35,0.65l2.62,0.55l0.52,1.67l-0.47,1.97l-0.77,1.01l-1.82,1.02l-1.04,-0.07l-1.78,0.74l1.58,0.44l0.64,-0.18l0.33,1.97l-1.64,0.18L79.16,481l-0.13,1.36l0.63,0.41l2.96,-0.33l0.99,1.21l-0.03,0.63l0.78,0.35l0.77,1.72l-1.05,3.32l-2.76,3.33l0.09,2.25l-2.15,1.52l-8.93,3.49l-2.59,2.2l-9.81,3.75l-2.84,0.14l-6.2,-2.57l-3.98,-2.49l-5.5,-4.73l-3.4,-3.98l-2.19,-3.07l-2.88,-2.96l-1.9,-1.26l-9.02,-8.88l-2.84,-3.63l-0.64,-1.37l-0.05,-0.79l0.88,-2.06l0.4,-0.56l1.34,-0.81l1.65,1.71l0.51,1l-0.13,1.04l1.03,0.81l1.45,-0.17l8.4,-2.73l3.49,-1.32l3.44,-2.01l2.17,0.29l0.53,-0.16l4.05,-7.47l1.5,-1.62l0.77,0.02l0.5,-0.31l0.51,-1.49l-0.37,-1.25l-0.57,-0.62l-1.38,0.82l-0.27,0.49l0.14,1.09l-0.29,1.72l-1.13,0.13l-2.29,-0.52l-7.91,2.24l-1.88,1.21l-0.82,1.3l-10.15,-2.16l-11.42,-6.83l-2.38,-2.68l-2.26,-3.57l-0.59,-1.84l0.09,-2.13l6.41,-4.63l0.42,-0.63l-2.7,0.82l-3.29,1.77l-1.34,1.12l-0.56,1.5l-0.57,0.56l-1.52,0.12l-1.58,-0.25l-0.7,-0.4l1.12,-1.2l0.2,-4.19l1.62,-1.99l0.04,-0.41l0.04,0.32l0.76,0.32l0.11,-0.89l0.6,-0.53l0.4,0.04l0.19,0.52l0.75,-0.81l0.25,0.3l1.13,-0.47l0.37,1.4l0.43,-0.06l0.27,-0.79l0.19,0.41l-0.21,0.14l4.15,0.03l0.31,-7.2l0.58,-0.36l0.7,-0.19l0.44,2.24l0.82,0.28l0.71,-1.41l0.52,-0.4l0.48,0.88l0.62,0.26l1.9,-0.97l2.19,0.76l2.27,-0.93l1.06,0.24l1.43,-0.17l1.43,0.42l2.04,-0.51l2.52,2.39l5.68,0.11l1.3,-0.61l1.13,-2.17l5.16,-1.4l4.2,-1.5l0.76,0.44l-0.82,1.25l0.31,0.77l-0.31,0.37l0.32,0.18l-0.28,0.74l1.66,0.61l3.09,0.05l1.81,-0.77l-0.18,-0.75l1.53,-1.24l0.79,-0.32l0.3,0.31l0.7,-0.01l1.74,-1.22l-0.26,-0.66l-2.29,-0.25l0.16,-1.8l-0.35,-0.42l0.05,-1.3l0.41,-0.7l1.54,-0.9l0.95,0.58l2.42,0.67l4.92,-1.47l1.71,0.28l1.81,0.78l6.93,-1.29L81.29,418.58zM100.33,515.02l-0.58,-0.05l0.33,0.32L100.33,515.02z"
				},
				{
					"id":"IN-HP",
					"title":"Himachal Pradesh",
					"d":"M210.73,235.72L211.5,236.45L211.29,237.26L212.11,238L212.94,238.18L211.82,239.78L211.86,241.43L211.31,242.34L213.36,242.25L214.46,243.01L214.48,243.88L214.08,244.46L214.55,245.34L215.59,245.7L215.79,246.32L217.3,248.1L218.12,248.29L217.26,250.53L217.11,252.19L216.55,252.68L216.48,253.25L216.73,253.8L217.17,253.96L216.89,254.5L217.37,255.69L218.29,255.74L218.44,256.51L219.35,257.53L218.66,258.46L217.1,259.31L216.8,259.85L217,260.65L217.66,260.51L218.62,261.42L218.56,262.25L218.23,262.65L219.27,263.13L219.54,263.77L219.31,264.35L219.91,264.76L220.34,265.77L221.06,266.01L221.06,266.01L222.53,268.55L222.66,269.79L219.85,269.89L219.24,269.28L218.82,267.65L216.41,267.74L212.26,267.31L209.97,266.24L208.76,265.98L203.37,268.77L201.69,268.58L200.76,269.07L198.97,271.14L197.58,273.61L196.92,278.51L198.62,282.74L198.64,283.92L193.42,286.06L193.76,286.9L193.76,286.9L193.76,286.9L193.76,286.9L190.03,286.35L187.61,285.49L184.61,283.49L184.31,282.91L185.17,282.06L185.19,280.22L184.12,279.27L181.74,278.16L179.65,275.09L178.17,274.92L177.52,274.51L177.52,274.51L174.22,272.12L173.95,271.39L174.45,267.8L172.76,266.08L170.76,264.88L170.04,263.37L168.4,263.42L167.53,264.86L165.32,264.92L164.81,261.98L161.45,255.74L160.39,253.1L160.74,252.59L161.25,252.44L160.48,250.83L159.01,249.05L156.92,247.54L155.01,246.59L154.1,243.32L154.63,242.22L158.92,240.59L159.99,239.65L160.57,238.5L159.76,237.14L158.23,235.59L158.23,235.59L158.98,233.9L159.8,233.57L159.62,230.59L159.29,229.35L158.22,227.49L157.06,226.35L157.71,225.92L158.79,225.81L160.53,226.9L166.55,223L167.05,222.48L167.42,221.15L169.94,219.79L176.32,220.05L178.62,221.1L180.85,223.51L184.54,226.44L189.55,228.17L196.68,224.23L198.82,226.73L200.75,229.76L202.3,233.99L203.32,234.27L204.79,232.72L205.72,232.23L206.96,232.48L208.78,231.13L208.93,230.44L210.04,230.26L210.23,232.72L208.57,235.2L208.23,237.04L208.78,237.54L210.12,236.02z"
				},
				{
					"id":"IN-HR",
					"title":"Haryana",
					"d":"M193.76,286.9L193.77,287.99L193.77,287.99L192.57,291.47L191.88,292.28L189.31,293.73L189.31,293.73L187.61,295.07L185.88,297.24L185.88,297.24L185.84,298.93L185.28,300.53L184.38,300.67L184.38,300.67L184.25,307.47L184.86,309.84L184.86,309.84L184.38,310.74L184.38,310.74L184.47,316.8L184.47,316.8L185.77,319.77L185.86,320.59L185.86,320.59L185.56,323.01L185.56,323.01L185.56,323.01L185.56,323.01L183.55,322.48L180.9,323.86L180.88,326.95L180.18,328.1L179.67,328.2L178.56,329.46L179.46,330.97L181.45,330.64L182.42,330.11L184.33,331.09L185.72,332.96L186.99,332.77L187.22,331.5L189.09,330.92L189.09,330.92L191.28,332.65L191.91,333.62L192.54,336.72L192.54,336.72L191.33,340.22L191.33,340.22L191.4,341.64L192.07,342.1L192.34,342.92L192.34,342.92L191.27,344.36L188.79,346.28L188.79,346.28L188.5,346.28L188.5,346.28L187.93,346.9L186.82,347.21L186.37,346.7L185.39,346.65L181.78,348.95L181.56,349.94L180.34,350.31L179.93,350.11L179.65,349.29L180.19,346.23L180.24,342.18L181.07,339.24L178.95,337.34L177.97,337.76L174.74,340.42L174.72,341.48L172.81,343.54L170.7,341.58L170.34,340.02L171.28,340.03L171.14,339.55L170.75,339.18L168.42,338.77L168.49,341.05L167.92,342.02L167.34,341.93L166.53,341.08L165.03,341.25L164.56,342.23L165.45,345.6L164.46,346.57L160.92,346.26L160.17,343.99L159.86,340.36L161.79,338.79L162.42,338.76L162.77,339.25L163.18,339.1L161.36,336.12L159.64,334.26L157.46,333.22L155.22,331.29L152.04,327.49L150.45,321.21L151.23,320.61L151.41,319.8L151.15,319.3L148.66,317.81L148.56,315.42L148.85,314.99L148.87,313.43L148.36,313.27L145.21,313.77L141.99,313.6L139.32,312.43L139.16,311.27L138.58,310.31L137.27,309.82L136.74,309.82L135.91,310.65L132.13,311.16L130.94,308.49L131.97,308.08L132.63,306.84L131.75,306.16L131.94,303.75L132.51,302.03L132.35,301.27L130.62,301.87L129.68,301.8L129.35,301.18L129.56,300.02L130.5,299.54L130.71,296.93L130.71,296.93L132.43,297.68L133.38,297.73L134.65,296.67L136.99,296L139.01,297.07L139.4,297.76L140.73,298.87L141.88,298.75L144.75,299.69L145.47,301.72L144.14,303.65L145.57,306.42L147.03,305.95L146.8,304.79L147.42,303.59L150.13,300.46L152.76,301.85L155.85,300.3L157.08,300.07L158.15,300.32L158.92,301.76L160.44,302.29L162.42,301.94L166.34,299.13L165.83,296.06L166.33,293.49L166.78,292.92L168.07,293.52L172.32,294.12L174.21,292.6L174.71,291.35L173.85,290.22L176.07,287.65L176.23,286.24L177.11,285.88L178.65,286.05L179.04,286.72L179.06,287.63L179.48,287.91L179.84,287.63L180.18,282.22L179.93,281.57L179.15,281.12L178.21,279.82L178.21,279.82L178.54,277.52L178.54,277.52L178.4,276.66L177.72,276.42L177.14,274.92L177.52,274.51L177.52,274.51L178.17,274.92L179.65,275.09L181.74,278.16L184.12,279.27L185.19,280.22L185.17,282.06L184.31,282.91L184.61,283.49L187.61,285.49L190.03,286.35z"
				},
				{
					"id":"IN-JH",
					"title":"Jharkhand",
					"d":"M403.15,407.84L403.04,408.32L404.55,409.77L404.55,409.77L404.93,410.36L404.93,410.36L405.25,411.01L405.23,414.66L405.97,418.61L405.17,420.16L405.17,420.16L404.65,420.65L402.91,424.83L402.91,424.83L402.08,426.51L402.08,426.51L400.45,427.94L401.18,429.19L401.18,429.19L401.15,429.71L397.08,430.93L397.08,430.93L397.07,432.72L396.65,433.42L396.65,433.42L396.33,433.73L393.41,432.46L393.41,432.46L392.01,432.44L392.01,432.44L392.03,433.1L392.45,433.37L392.45,433.37L392.88,434.12L392.88,434.12L393.1,435.39L392.16,437.13L389.65,437.97L387.18,436.77L387.18,436.77L386.79,436.6L386.79,436.6L385.29,436.03L383.41,437.59L383.41,437.59L383.51,438.39L383.51,438.39L383.68,440.43L382.09,440.79L381.94,440.29L381.25,439.94L381.25,439.94L378.39,440.54L378.39,440.54L375.54,442.2L374.51,443.2L374.1,444.31L374.1,444.31L374.04,445.31L374.04,445.31L372.67,446.68L369.62,445.08L369.77,443.2L369.32,442.82L367.43,442.87L365.28,445.25L363.22,449.03L363.02,450.07L363.94,451.94L363.94,451.94L364.89,452.37L365.43,452.12L365.43,452.12L366.98,452.17L370.24,455.25L370.24,455.25L371.26,455.87L372.95,455.7L372.95,455.7L375.09,455.65L377.98,456.03L377.74,456.63L376.17,457.48L375.44,459.69L375.5,460.27L375.5,460.27L377.18,461.76L377.18,461.76L377.7,461.56L379.46,462.48L379.46,462.48L382.65,465.03L382.65,465.03L385.22,470.86L385.22,470.86L384.89,471.68L383.66,471.5L381.98,472.22L380.69,473.16L380.69,473.16L379.44,471.43L378.13,470.64L378.13,470.64L375.7,470.25L375.7,470.25L375.24,470.44L374.45,470.19L374.45,470.19L373.86,469.79L373.86,469.79L372.21,467.53L370.7,466.94L370.7,466.94L368.73,466.55L368.47,466.02L368.47,466.02L367.95,465.35L367.35,465.16L367.35,465.16L365.58,466.1L365.58,466.1L365.25,466.37L366.04,467.1L366.83,468.49L366.89,473.16L366.56,475.15L364.52,478.36L364.52,478.36L363.4,478.16L363.4,478.16L362.15,477.84L360.97,476.18L358.21,475.73L358.21,475.73L357.52,475.5L357.52,475.5L354.47,473.75L354.47,473.75L351.9,475.29L351.9,475.29L350.95,477.16L350.95,477.16L346.85,474.19L347.64,471.85L347.64,471.85L348.1,469.92L347.77,466.79L347.18,466.66L347.18,466.66L344.45,468.17L343.73,467.61L338.77,467.76L335.81,468.38L335.81,468.38L335.78,469.08L334.96,469.72L333.38,469.86L333.38,469.86L332.39,469.79L329.5,468.81L327.39,466.31L327.39,466.31L326.92,463.54L328.42,461.69L328.92,461.33L330.22,461.26L331.92,459.55L332.48,457.87L333.57,456.52L334.69,455.91L334.46,454.34L334.08,453.71L333.32,453.52L332.36,453.72L329.37,452.88L327.24,449.95L325.5,446.04L324.94,446.54L324.37,446.49L324.3,444.14L325.3,442.62L324.92,440.72L324.42,440.22L323.79,440.47L323.29,440.98L323.48,442L322.66,442.25L319.39,441.63L318.75,440.88L318.5,437.96L317.99,436.82L317.48,436.32L315.47,435.69L313.7,432.52L312.05,431.13L312.05,431.13L314.45,425.46L313.69,424.35L313.39,422.74L315.08,421.9L315.08,421.9L317.43,423.33L325.42,423.63L326.31,422.74L326.45,421.7L327.78,422.15L329.41,424.37L330.59,424.66L331.63,423.77L332.66,423.33L334.14,424.81L334.14,426.58L334.88,427.47L336.66,428.36L338.73,428.51L338.87,426.58L340.8,426.58L341.83,425.7L342.13,424.22L344.05,424.51L344.79,426.29L347.75,427.47L348.63,425.84L351.15,426.14L352.03,424.66L352.63,424.22L356.77,424.22L357.36,422.44L359.13,422.15L359.87,420.08L360.61,419.63L361.05,417.56L362.68,417.56L363.72,418.6L365.49,418.6L367.41,417.86L368,419.19L369.04,419.93L369.04,423.18L371.26,422.44L372.29,422.74L372.59,426.29L373.77,426.29L374.51,427.17L375.69,426.58L376.58,423.48L377.32,423.18L377.91,422L378.95,422L379.54,423.63L381.16,422.89L382.05,421.85L384.27,423.63L385.16,421.41L386.49,421.41L387.08,419.78L387.37,416.97L388.11,416.38L388.85,414.46L389.15,411.65L390.77,411.21L392.55,407.8L395.65,407.95L395.8,406.47L396.69,406.47L396.54,404.85L400.24,406.18L402.46,407.8z"
				},
				{
					"id":"IN-JK",
					"title":"Jammu and Kashmir",
					"d":"M198.68,162.25L199.15,162.27L199.48,163.33L200.24,164.1L200.82,163.78L201.3,162.95L202.1,162.61L203.92,162.48L204.55,162.87L204.29,163.4L202.24,164.94L202.13,166.08L203.17,169.74L204.84,171.41L204.7,172.01L204,172.74L206.09,177.75L206.55,180.62L207.39,182.38L208.46,183.21L210.47,183.54L211.02,184.66L213.98,184.45L215.84,186.49L217.28,187.31L219.22,189.35L221.23,190.31L222.43,191.36L222.68,192.45L221.92,194.2L220.53,195.47L217.26,197.22L216.79,197.8L216.91,198.33L217.9,198.69L218.1,199.09L216.98,200.45L216.9,201.49L217.19,202.75L218.38,205.23L216.8,207.7L217.96,210.31L219.19,212.26L222.58,215.59L224.01,216.74L226.83,216.82L226.55,219.41L225.03,220.65L224.84,221.44L226.36,224.03L227.59,225.5L228.16,225.5L227.5,227.52L228.26,228.65L228.26,230.22L227.59,231.01L227.5,231.79L227.97,232.35L228.07,233.14L227.21,234.71L227.13,235.74L227.69,237.51L227.4,238.06L226.74,238.29L225.31,237.99L224.96,239.31L223.82,239.03L222.69,239.49L222.35,240.01L221.06,239.42L220.24,238.28L219.45,238.02L218.23,236.6L217.97,234.57L218.31,233.83L217.97,231.88L217.6,231.46L215.72,232.59L215.13,233.62L213.48,233.49L212.26,234.44L211.59,234.28L210.76,234.85L210.73,235.72L210.73,235.72L210.12,236.02L208.78,237.54L208.23,237.04L208.57,235.2L210.23,232.72L210.04,230.26L208.93,230.44L208.78,231.13L206.96,232.48L205.72,232.23L204.79,232.72L203.32,234.27L202.3,233.99L200.75,229.76L198.82,226.73L196.68,224.23L189.55,228.17L184.54,226.44L180.85,223.51L178.62,221.1L176.32,220.05L169.94,219.79L167.42,221.15L167.05,222.48L166.55,223L160.53,226.9L158.79,225.81L157.71,225.92L157.06,226.35L158.22,227.49L159.29,229.35L159.62,230.59L159.8,233.57L158.98,233.9L158.23,235.59L158.23,235.59L157.81,236.25L155.78,237.35L155.66,237.96L155.09,238.58L152.71,239.23L151.85,240.2L151.65,241.49L151.1,241.97L150.53,241.73L150.67,240.63L150.11,239.99L147.13,239.96L147.13,239.96L145.49,238.65L144.75,238.5L144.61,238.04L143.6,238.28L142.44,236.69L141.49,236.4L140.32,237.47L139.38,236.99L138.68,237.03L138.21,236.56L137.36,236.3L135.78,236.69L134.55,236.57L134.21,236.12L134.19,235.28L133.61,234.75L133.4,233.52L134.1,232.38L133.56,230.91L134.53,227.97L133.4,228.38L133.39,229.13L132.83,229.96L131.13,230.37L129.79,229.39L128.72,226.41L126.75,226.02L127.47,224.48L127.4,223.67L125.46,222.88L124.44,223.01L123.84,221.46L122.52,220.06L120.52,219.24L120.64,217.76L122.34,217.47L123.73,215.61L124.06,212.95L123.88,212.31L122.19,210.13L121.33,210.26L120.81,210.03L119.33,206.46L121.57,204L123.17,203.76L124.73,202.85L125.58,201.43L125.62,200.21L125.33,199.24L124.63,198.63L123.54,198.62L122.76,198.22L120.35,199.02L118.14,198.77L117.83,198.35L118.26,196.56L119.74,194.35L119.74,193.04L118.16,190.69L116.98,191.23L116.27,190.77L115.58,190.94L115.37,190.7L115.65,189.3L118.15,187.33L117.9,186.85L118.08,186.07L119.16,185.41L118.73,183.6L119.03,182.83L119.41,182.34L120.49,182.02L121.23,182.63L123.13,182.48L124.39,181.35L125.96,180.56L126.53,179.77L127.23,180.03L127.93,179.69L132.13,180.52L134,182.24L134.65,182.43L137.37,182.82L138.91,182.68L141.13,183.71L143.66,183.19L145.87,183.57L146.2,183.76L146.12,184.47L148.49,185.92L151.13,186.3L153.37,186.27L156.12,186.83L158.05,185.37L159.59,184.62L160.16,183.97L161.09,184L162.01,183L162.79,182.85L163.76,183.58L164.5,183.67L166.6,182.65L167.75,181.47L169.18,181.37L170.99,179.91L172.79,180.81L175.25,180.78L176.51,178.78L176.64,176.62L177.9,176.4L179.11,175.48L181.17,176.4L181.73,176.31L182.15,173.83L183.18,174.19L185,173.43L195.13,165.62z"
				},
				{
					"id":"IN-KA",
					"title":"Karnataka",
					"d":"M193.81,558.79L193.5,561.03L194.45,564.52L195.4,565.25L195.33,565.86L194.14,567.45L192.1,568.73L191.33,573.11L193.59,574.31L195.42,575.96L193.09,576.92L190.71,579.71L189.77,581.55L189.55,582.25L189.78,583.49L190.59,584.02L191.14,586.93L191.05,588.83L191.55,590.41L191.44,594.83L190.4,596.38L189.4,597.17L188.33,597.21L186.87,597.7L187.38,598.59L188.97,599.17L192.18,599.45L193.39,600.16L193.8,600.94L193.67,601.41L192.62,601.4L191.75,601.96L191.55,604.15L192.2,608.59L189.58,608.49L186.45,607.88L184.94,608.09L183.57,608.64L182.21,610.51L183.45,612.03L184.11,614.97L183.61,614.72L182.74,614.9L181.49,617.7L183.01,620.82L185.04,623.08L185.36,625.29L184.38,627.55L183.08,628.17L179.18,627.68L178.82,627.15L177.72,626.53L177.27,626.89L176.57,629.06L178.95,629.66L178.97,631.44L178.59,632.86L177.41,633.42L176.95,636.58L177.53,638.13L179.04,639.38L180.96,639.33L181.26,639.71L180.53,641.05L179.27,641.87L180.73,644.6L183.82,645.24L184.26,644.99L184.45,643.38L184.86,642.77L185.51,642.71L186.75,642.96L188.1,643.71L189.77,643.66L190.19,642.46L192,643.92L192.39,646L192.17,646.4L190.56,646.08L189.01,647.07L189.49,649.05L190.53,650.05L190.89,651.53L190.18,651.93L189.19,651.52L188.19,648.98L184.9,649.49L184.51,648.9L182.65,648.39L182.07,647.4L182.48,646.22L182.21,645.79L179.98,646.33L181.13,649.28L181.8,650.37L182.88,651.09L182.35,652.26L181.47,653.12L181.92,655.03L185.42,654.51L185.75,652.41L190.67,652.85L191.31,653.82L191.24,655.43L194.9,654.99L194.84,654.5L195.31,654.01L198.07,653.57L198.63,652.52L198.49,650.81L201.31,650.5L201.36,651.86L202.1,652.24L203.78,651.79L204.89,652.38L204.84,654.15L204.25,654.92L203.9,656.15L204.36,656.87L207.13,658.28L210.54,658.06L210.22,659.67L210.1,663.46L213.34,664.88L214.06,664.05L214.39,664.77L214.07,666.62L213.56,668.34L211.93,669.87L212.1,672.27L212.5,672.89L212.31,673.32L209.94,671.76L207.49,675.26L207.49,675.26L204.94,674.26L201.21,674.01L200.85,673.54L201.09,672.96L200.46,672.83L198.47,673.78L198.77,674.11L198.18,675.79L197.02,677.27L194.75,677.12L193.97,679.29L194.38,681.21L195.04,680.84L194.62,683.57L192.9,685.32L191.82,685.65L191.8,687.09L194.56,687.05L196.76,687.48L197.49,688.61L197.5,689.25L195.11,692.33L192.83,692.96L192.31,692.85L191.49,693.55L191.21,694.84L191.59,695.38L190.95,696.46L187.3,695.37L184.67,695.95L182.47,695.2L179.92,695.64L179.12,697.15L178.67,699.93L177.13,699.43L174.44,699.68L173.18,699.18L172.55,697.95L171.79,697.29L170.38,698.17L170.38,698.17L166.84,694.94L164.47,693.99L163.99,694.07L163.64,691.55L161.56,692.5L158.15,691.98L157.54,691.25L157.19,690.12L155.19,689.33L152.53,687.66L150.33,684.84L149.45,685.09L148.33,682.79L148.25,681.72L144.42,677.96L142.42,676.98L140.26,674.89L139.59,674.73L137.77,675.59L137.77,675.59L137.41,673.69L136.98,673.46L136.06,669.29L132.93,653.02L130.44,648.52L129.47,644.32L127.92,640.07L128.35,639.92L128.68,639.33L127.36,637.65L127.1,638.53L126.45,638.55L125.78,635.19L125.3,634.29L123.84,633.89L122.23,632.92L122.3,631.24L122.3,631.24L125.08,629.49L126,629.69L126.81,629.13L127.27,625.34L126.7,622.85L127.91,622.42L127.83,621.17L126.94,619.86L126.7,618.55L127.02,617.21L126.79,614.81L125.03,614.25L124.75,614.89L124.07,614.86L123.7,614.29L124.76,613.17L124.76,613.17L126.31,612.62L127.58,612.94L129.04,612.2L129.2,611.61L128.8,610.52L129.12,609.64L130.61,608.84L131.75,605.47L132.02,602.85L131.71,602.41L128.75,601.14L128.32,600.14L128.54,599.39L128.82,599.76L129.04,599.2L128.53,597.82L127.1,597.41L127.49,596L131.21,594.77L132.94,595.28L134.92,594.54L135.86,593.23L137.36,591.98L140.21,591.25L140.1,589.62L140.73,587.71L142,587.62L143.88,588.2L145.67,590L146.1,590.09L147.59,588.97L147.54,587.78L148.84,586.55L150.73,586.55L151.11,587.12L153.94,587.23L154.56,586.96L154.81,584.61L154.55,581.66L153,578.25L153.85,577.1L154.58,577.09L157.03,578.1L157.7,577.19L158.68,577.1L158.99,578.43L159.82,579.04L162.1,578.59L165.17,578.46L168.98,579.42L169.83,578.32L169.14,578.04L168.18,573.31L169.5,573.12L171.39,571.68L171.38,570.83L172.51,569.74L174.4,570.31L175.38,571.42L180.08,566.51L180.8,563.74L180.22,562.12L180.26,561.39L181.55,560.75L183.16,562.08L183.91,562.11L184.35,561.75L184.94,559.91L186.64,556.59L187.95,555.75L189.31,555.46L190.28,556.64L189.69,557.66L189.59,558.43L191.36,559.31L191.86,559.34L192.8,558.73z"
				},
				{
					"id":"IN-KL",
					"title":"Kerala",
					"d":"M170.38,698.17l-0.13,0.64l-1.21,0.76l-1.96,0.62l-0.37,-0.29l-0.33,0.49l-0.13,1.92l2.66,0.56l2.58,1.18l1.13,1.06l-0.63,1.43l-1.46,0.87l-0.49,0.61l4.36,0.07l1.5,-0.99l0.52,0.43l0.35,3.33l-1.46,0.99l-0.71,1.68l1.75,0.77l2,0.28l1.46,1.87l-0.58,2.21l-0.87,1.8l-0.25,3.43l0.29,2.77l1.54,1.22l1.25,0.36l1.21,-0.62l0.87,-1.19l2.31,-0.95l0.62,0.1l1.46,2.38l-1.06,3.71l0.25,2.24l-0.46,3.54l-1.08,3.48l2,0.5l1.83,-0.33l0.87,1.3l-1.33,3.54l-1.35,1.34l-0.6,2.93l-1.08,0.84l-0.75,1.43l0.47,1.29l1.62,2.03l-0.06,0.54l-1.54,2.45l0.7,1.55l1.17,1.54l0.1,0.61l-0.04,0.54l-1.17,0.92l-0.86,2.23l-1.6,1.91l0,0l-2.63,-2.18l-6.08,-7.86l-1.9,-1.96l-0.09,-1.24l0.71,-0.71l1.12,0.1l0.07,-0.77l-2.15,0.25l-0.51,0.55l-1.88,-3.68l-2.6,-6.62l-1.46,-10.29l0.89,1.04l-0.56,0.13l0.53,1.52l0.82,1.27l0.63,-0.14l0.45,2.82l-0.53,2.35l0.81,0.47l1.72,0.13l0.46,-0.68l-1.53,-1.4l-0.83,-5.43l-0.55,-1.07l-1.63,-1.18l-0.77,-2.94l-0.58,-0.37l0.52,2.99l-0.67,-1.06l-0.82,-3.15l-4.92,-11.77l-1.28,-4.67l-3.65,-9.56l-1.35,-0.63l-1.83,-4.78l-3.1,-3.34l-2.11,-3.07l-1.65,-0.05l-1.36,-4.13l-5.58,-11.42l0,0l1.82,-0.86l0.67,0.16l2.16,2.09l2,0.98l3.83,3.76l0.08,1.07l1.12,2.3l0.87,-0.25l2.21,2.82l2.66,1.67l2,0.79l0.35,1.13l0.6,0.73l3.41,0.52l2.08,-0.95l0.35,2.52l0.48,-0.08l2.37,0.95L170.38,698.17zM151.57,696.63l0.32,0.14l-0.35,-0.74L151.57,696.63z"
				},
				{
					"id":"IN-LD",
					"title":"Lakshadweep",
					"d":"M95.16,708.23l-0.03,0.07l-0.12,-0.14l0.14,-0.8l0.21,-0.42L95.16,708.23zM82.88,715.94l-0.19,0.11l0.1,-0.55l0.1,-0.19l0.32,-0.47l0.06,0.15l-0.07,0.32L82.88,715.94zM92.27,721.41l-0.08,0.07l-0.14,-0.01l0.53,-0.47l-0.04,0.14L92.27,721.41zM112.95,731.46l-0.19,0.32l-0.12,-0.33l0.26,-0.58l0.08,0.25L112.95,731.46zM100.71,768.95l-0.37,0.12l-0.22,-0.31l1.2,-0.99l0.06,0.15l-0.18,0.58l-0.15,0.24L100.71,768.95z"
				},
				{
					"id":"IN-MH",
					"title":"Maharashtra",
					"d":"M248.82,549.29L248.19,549.7L246.93,549.9L245.17,549.65L243.23,547.69L242.61,545.91L242.45,543.55L241.84,542.01L240.51,542.32L240.51,540.85L242.12,539.46L242.68,534.21L241.86,532.6L239.14,530.28L237.69,530L235.34,531.07L235.12,532.03L234.36,532.03L229.62,530.14L228.94,529.14L227.28,528.65L224.64,529.66L222.69,529.57L220.24,528.08L220.88,527.03L219.87,526.48L213.36,525.21L210.54,525.35L210.47,526.82L209,528.13L209.36,532.78L206.62,533.8L206.78,537.2L205.9,537.65L204.53,537.66L203.06,535.76L202.28,535.47L200.62,536.17L201.01,537.47L200.04,540.37L199.07,541.67L199.56,543.57L201.67,545.84L201.01,546.85L199.51,546.91L198.6,547.47L196.87,549.69L196.62,550.62L196.98,551.43L197.18,553.34L194.89,553.16L193.53,555.35L194.12,558.03L193.81,558.79L193.81,558.79L192.8,558.73L191.86,559.34L191.36,559.31L189.59,558.43L189.69,557.66L190.28,556.64L189.31,555.46L187.95,555.75L186.64,556.59L184.94,559.91L184.35,561.75L183.91,562.11L183.16,562.08L181.55,560.75L180.26,561.39L180.22,562.12L180.8,563.74L180.08,566.51L175.38,571.42L174.4,570.31L172.51,569.74L171.38,570.83L171.39,571.68L169.5,573.12L168.18,573.31L169.14,578.04L169.83,578.32L168.98,579.42L165.17,578.46L162.1,578.59L159.82,579.04L158.99,578.43L158.68,577.1L157.7,577.19L157.03,578.1L154.58,577.09L153.85,577.1L153,578.25L154.55,581.66L154.81,584.61L154.56,586.96L153.94,587.23L151.11,587.12L150.73,586.55L148.84,586.55L147.54,587.78L147.59,588.97L146.1,590.09L145.67,590L143.88,588.2L142,587.62L140.73,587.71L140.1,589.62L140.21,591.25L137.36,591.98L135.86,593.23L134.92,594.54L132.94,595.28L131.21,594.77L127.49,596L127.1,597.41L128.53,597.82L129.04,599.2L128.82,599.76L128.54,599.39L128.32,600.14L128.75,601.14L131.71,602.41L132.02,602.85L131.75,605.47L130.61,608.84L129.12,609.64L128.8,610.52L129.2,611.61L129.04,612.2L127.58,612.94L126.31,612.62L124.76,613.17L124.76,613.17L124.25,612.62L123.51,612.84L122.3,614.32L122.13,614.84L122.48,615.35L121,616.14L120.13,615.89L119.52,615.04L119.34,613.84L117.24,611.58L116.37,612.58L115.41,613.1L114.01,613.17L114.01,613.17L112.92,612.8L113.04,612L112.25,610.17L109.67,607.46L108.89,606.04L108.08,602.3L106.4,596.96L106.66,596.38L107.1,596.4L106.12,594.39L105.24,589.14L104.9,586.03L105.28,585.29L105.34,584.26L103.37,575.95L102.11,572.53L101.95,569.56L99.94,564.82L99.12,560.75L99.03,558.15L97.53,555.67L97.44,554.38L97.71,553.48L96.71,550.44L96.83,547.51L98.21,546.99L99.12,547.84L99.45,548.99L99.56,547.64L97.9,544.9L100.82,543.02L99.08,541.42L98.32,541.8L96.08,545.01L95.05,544.29L96.1,542.14L95.93,539.5L95.31,539.88L94.92,538.11L95.17,536.42L96.63,536.23L99.56,537.64L100.06,538.65L100.58,538.57L100.38,537.68L98.91,536.43L95.64,536.03L94.65,535.07L93.71,530.37L93.55,526.61L93.08,525.96L92.82,524.29L92.86,523.25L93.53,521.9L94.12,518.61L94.12,518.61L94.12,518.61L94.12,518.61L95.48,519.06L96.27,518.96L96.7,518.7L97.61,516.93L99.3,517.7L99.3,517.7L99.39,518.93L100.35,519.98L100.96,520.24L103.66,520.49L104.27,519.16L104.7,518.98L104.7,518.98L104.71,518.98L104.71,518.98L104.71,518.98L104.71,518.98L105.4,519.42L108.14,517.64L108.52,514.11L109.9,509.87L108.68,508.02L109.67,506.6L109.67,506.6L109.98,506.95L109.98,506.95L113.73,509.66L115.3,509.47L116.64,508.76L118.98,505.65L119.11,504.01L118.14,501.32L116.56,498.94L116.56,498.94L116.56,498.94L116.56,498.94L115.34,498.5L114.99,498.77L114.47,498.68L113.6,498.24L113.6,498.24L113.6,498.24L113.6,498.24L112.24,496.04L113.53,496.81L114.29,496.82L116.12,496.01L119.29,493.64L119.67,491.46L120.02,491.1L122.02,489.76L124.46,489.83L125.94,489.55L126.68,488.88L126.8,487.77L126.8,487.77L126.8,487.77L126.8,487.77L124.8,488.13L121.22,487.71L118.22,488.67L117.96,489.16L117.48,489.07L117.48,489.07L117.48,489.07L117.48,489.07L117.05,488.54L116.25,486.24L118.43,485.51L117.55,483.29L117.57,481.21L121.03,479.38L122.63,478.9L123.99,479.52L125.82,479.25L127.12,478.33L127.12,478.33L128.33,477.29L128.33,477.29L130.96,476.73L130.96,476.73L129.85,477.28L129.26,480.5L130.04,481.45L130.04,481.45L131.88,483.25L131.88,483.25L134.35,483.94L134.35,483.94L135.49,484.07L135.49,484.07L136.76,483.92L139.55,484.57L141.38,486.03L142.39,487.77L142.39,487.77L144.01,488.95L147.21,489.73L147.21,489.73L151.06,489.76L151.06,489.76L157.63,490.16L157.63,490.16L159.41,490.46L159.41,490.46L160.32,490.06L162.4,490.54L162.81,490.99L163.59,494.36L163.5,494.96L162.93,495.16L163.26,495.92L164.27,496.93L167.01,497.35L167.01,497.35L168.71,496.69L168.71,496.69L169.95,496.19L170.54,495.03L171.96,494.68L173,494.91L173.56,494.2L173.82,492.18L173.64,491.36L176.56,488.74L176.56,488.74L176.79,488.24L176.79,488.24L176.51,486.17L176.51,486.17L177.07,485.67L178.06,485.54L178.06,485.54L179.38,485.59L181.85,483.68L181.85,483.68L182.89,482.57L184.44,482.49L184.44,482.49L185.25,482.72L185.5,483.27L186.03,483.57L187.66,482.94L191.3,482.48L191.3,482.48L192.05,483.07L192.96,484.66L193.57,487.35L192.34,487.3L192.34,487.3L190.62,486.98L190.62,486.98L190.11,487.25L191.38,490.27L191.93,490.7L193.07,491.08L196.35,491.18L196.85,490.95L196.85,490.95L199.09,490.35L200.23,490.98L200.23,490.98L201.65,490.67L201.65,490.67L205.43,488.56L206.25,487.12L208.48,486.49L208.48,486.49L209.27,486.32L209.27,486.32L210.49,486.09L211.04,486.5L211.04,486.5L215.99,489.03L215.99,489.03L218.68,488.98L218.68,488.98L221.52,488.5L221.95,488.05L221.95,488.05L221.69,487.26L222.18,486.34L222.18,486.34L222.59,486.01L225.35,485.78L227.99,484.7L228.02,484.07L228.02,484.07L228.6,483.06L231.04,484.67L231.04,484.67L232.36,484.44L232.36,484.44L233.73,484.11L234.11,484.52L234.39,485.2L234.11,485.55L234.03,486.84L235.32,487.67L236.87,487.37L236.87,487.37L237.4,486.94L237.4,486.94L238.67,485.9L238.67,485.9L240.32,486.18L241.03,486.76L241.03,486.76L241.99,487.74L241.99,487.74L242.52,487.84L242.52,487.84L244.67,487.47L244.67,487.47L246.51,486.25L246.51,486.25L247.81,485.04L248.67,484.74L249.58,485.07L253.3,490.63L253.3,490.63L257.79,491.59L257.79,491.59L258.45,491.79L258.45,491.79L255.99,494.13L255.99,494.13L253.93,495.46L253.65,496.29L253.75,499.1L254.3,500.81L254.3,500.81L255.27,500.56L255.27,500.56L255.57,501.01L256.32,506.47L255.18,507.07L255.18,507.07L254.67,507.8L254.67,507.8L254.9,508.32L255.56,508.65L256.22,508.27L256.93,508.35L256.93,508.35L257.46,508.9L257.46,508.9L257.25,513.63L256.95,514.32L254.87,514.97L252.84,516.25L252.88,518.32L252.88,518.32L253.44,518.84L254.13,518.47L254.13,518.47L256.13,518.14L256.13,518.14L255.82,521.74L255.82,521.74L255.59,522.43L254.46,522.91L254.46,522.91L252.62,526.1L253.71,526.62L253.71,526.62L254.32,526.74L254.74,526.44L254.53,525.67L255.21,525.25L255.21,525.25L258.63,528.08L258.63,528.08L258.8,528.71L258.22,529.35L258.19,529.93L260.73,530.55L263.29,532.31L263.29,532.31L263.44,532.83L262.07,535.74L258.7,538.36L255.79,536.24L255.22,534.62L255.22,534.62L254.57,534.83L253.26,535.93L253.26,535.93L251.54,537.77L251.54,537.77L250.17,539.96L250.13,541.41L250.13,541.41L249.59,542.41L249.59,542.41L248.94,543.46L249.13,544.88L249.13,544.88L250.65,546.88L249.88,547.5L249.88,547.5L248.43,548.32z"
				},
				{
					"id":"IN-ML",
					"title":"Meghalaya",
					"d":"M498.01,410.72L496.37,409.24L491.91,407.18L490.35,406.8L478.93,407.9L474.4,406.39L470.52,406.68L468.36,407.39L465.77,407.68L459.38,407.1L457.69,407.65L456.38,407.56L451.98,406.21L447.82,404.37L446.71,404.07L445.45,404.51L444.74,402.78L445.46,399.4L445.46,399.4L446.79,398.89L448.67,397.58L447.4,394.39L449.41,391.01L451.52,389.46L456.67,388.18L459.12,388.53L460.81,389.89L464.08,389.62L469.58,390.78L469.49,392.2L469.83,392.54L472.96,392.65L473.14,394.41L473.52,394.71L474.43,394.39L476.15,392.31L479.18,391.52L480.81,388.36L483.76,387.18L485.35,386.63L485.96,386.7L488.65,388.2L492.9,386.93L494.84,387.21L493.12,389.41L492.96,395.94L494.54,394.85L498.11,394.13L502.13,398.35L501.28,399.88L502.71,401.77L504.24,401.98L505.71,403.71L506.02,406.22L503.63,406.85L500.91,408.32z"
				},
				{
					"id":"IN-MN",
					"title":"Manipur",
					"d":"M544.16,401.38L543.48,401.97L542.54,404.52L542.45,406.32L543.24,407.19L545.39,407.88L545.65,408.26L545.67,410.31L543.27,416.42L540.27,420.43L537.03,427.06L535.1,433.21L533.62,436.77L533.35,436.94L532.52,435.99L531.23,435.24L528.74,434.44L526.95,434.9L525.79,433.45L524.22,433.11L522.96,433.08L522.24,434.09L520.33,434.29L519.78,434.1L518.03,431.51L517.61,431.42L516.99,431.85L516.79,432.65L516.79,432.65L514.86,432.26L512.6,432.39L509.78,431.03L510.48,428.48L510.62,424.73L510.62,424.73L510.93,424.57L511.92,420.01L512.07,418.8L511.75,417.58L512.98,416.21L514.14,415.59L515.61,413.3L517.75,407.19L518.59,405.97L519.4,405.56L519.4,405.56L519.95,405.41L519.95,405.41L521.36,406.04L521.58,407.42L521.58,407.42L522.14,407.04L524.06,403.52L524.06,403.52L525.01,402.83L526.13,400.76L525.47,400.02L525.6,399.44L525.6,399.44L526.15,399.21L526.15,399.21L527.88,398.99L527.88,398.99L530.87,398.94L530.87,398.94L532.82,399.88L535.57,400.21L538.17,399.92L539.69,397.77L541.67,396.32L541.67,396.32L542.22,395.94L542.22,395.94L542.93,396.1L542.91,397.49L542.91,397.49L542.19,399.33L542.19,399.33L542.33,400.34z"
				},
				{
					"id":"IN-MP",
					"title":"Madhya Pradesh",
					"d":"M210.19,369.67L213.28,371.02L213.28,371.02L214.46,371.23L215.09,370.68L215.09,370.68L216.23,370.32L216.23,370.32L217.67,370.55L221.55,372.62L222.5,373.78L224.42,377.73L224.42,377.73L225.18,378.38L225.18,378.38L225.56,379.28L225.19,382.91L224.06,384.21L223.31,384.47L222.18,385.9L221.93,386.68L222.31,387.32L222.31,388.23L222.31,388.23L220.56,393.14L218.18,394.96L216.92,397.28L215.16,398.58L215.16,398.58L212.27,398.59L211.52,400.4L210.52,401.69L209.63,401.56L209.01,402.72L210.15,406.05L211.16,407.08L211.16,407.08L210.79,408.75L210.79,408.75L209.54,412.08L207.4,413.63L207.4,413.63L206.3,414.67L206.3,414.67L206.86,416.9L207.69,418.12L207.69,418.12L207.84,422.94L207.84,422.94L207.3,423.64L209.95,424.86L210.08,425.88L210.08,425.88L211.47,426.51L211.47,426.51L212.6,425.1L214.11,425.6L215.75,427.51L215.75,427.51L216.38,428.27L216.38,428.27L218.27,429.15L218.27,429.15L219.03,429.15L219.03,429.15L220.03,428.63L220.78,426.97L222.79,425.69L223.04,425.05L222.91,423.9L221.39,420.47L221.39,420.47L220.89,419.83L220.89,419.83L218.63,420.74L218.63,420.74L217.74,419.85L217.49,418.95L217.61,417.55L217.61,417.55L217.73,414.61L217.73,414.61L216.84,413.84L216.08,412.44L216.08,412.44L214.81,408.09L214.56,405.91L213.67,404.76L213.42,403.86L213.54,403.34L216.56,401.4L216.56,401.4L217.06,401.78L217.06,401.78L216.31,402.62L217.44,403.45L218.2,403.58L218.7,402.16L218.7,402.16L219.2,400.49L220.83,398.81L222.09,399.45L222.48,402.27L222.48,402.27L220.46,402.8L220.46,402.8L219.96,403.96L219.96,403.96L220.73,407.8L220.73,407.8L222.24,406.51L222.74,405.23L223.49,404.84L223.49,404.84L223.75,407.79L224.13,408.3L226.65,409.06L229.42,408.53L229.42,408.53L230.17,406.99L230.04,406.35L230.04,406.35L229.79,405.71L229.09,405.39L228.4,405.46L228.4,405.46L228.02,404.82L228.27,404.17L228.27,404.17L229.78,403.91L232.31,406.21L230.8,408.27L232.06,409.42L233.2,409.54L233.95,408L234.7,407.74L239.99,409.63L240.62,408.09L240.36,406.94L240.36,406.94L240.49,406.43L241.12,405.91L244.26,403.84L248.03,402.41L248.03,402.41L248.91,402.28L248.91,402.28L249.69,403.02L249.69,403.02L251.54,405.51L251.91,407.1L250.49,407.83L248.43,409.98L248.68,410.88L249.06,411.39L249.56,411.51L249.56,411.51L252.08,411.24L252.08,411.24L254.09,409.95L257.87,410.06L257.87,410.06L258.88,410.06L258.88,410.06L257.74,409.17L257.36,408.4L257.36,408.4L260.13,407.23L261.26,407.48L261.26,407.48L260.76,409.67L259.26,412.62L259.26,412.62L259.64,413L260.39,413L261.53,412.48L261.53,412.48L261.9,412.22L264.55,412.47L265.56,413.49L267.7,413.09L268.75,407.64L270.45,407.83L271.58,408.33L272.47,408.2L272.47,408.2L273.34,407.04L275.23,407.03L275.62,409.85L278.89,411.38L280.4,411.11L280.4,411.11L281.54,410.98L281.54,410.98L281.67,413.54L282.55,414.69L283.56,415.06L283.56,415.06L287.21,415.69L290.12,418.87L290.12,418.87L290,420.02L290,420.02L290.75,420.4L291.63,420.27L291.63,420.27L291.62,417.46L293.01,418.09L293.01,418.09L294.27,418.72L296.54,418.07L296.54,418.07L297.04,417.81L297.61,418L297.61,418L298.68,419.21L298.68,419.21L298.93,419.72L298.93,419.72L298.93,420.23L298.93,420.23L297.68,421L297.68,421L298.07,424.83L298.57,425.21L298.57,425.21L298.7,427.12L298.39,429.73L298.39,429.73L297.95,429.92L297.26,429.61L297.26,429.61L297.58,430.69L300.23,433.98L300.23,433.98L300.76,434.38L300.76,434.38L300.43,434.94L298.8,435.09L298.06,437.6L296.58,437.45L295.7,439.52L294.66,438.19L292.3,438.04L291.56,437.6L289.49,438.04L288.45,437.01L287.12,436.71L283.28,436.71L281.5,437.16L280.17,436.86L279.88,435.97L278.25,435.23L277.21,436.27L277.36,437.16L278.99,438.63L278.1,440.26L276.62,442.04L277.07,443.22L278.1,444.25L279.58,443.51L281.21,443.51L282.24,444.7L282.98,443.96L284.02,444.7L284.31,446.03L285.35,445.88L286.53,447.65L288.16,449.28L288.3,451.79L287.86,453.27L286.38,454.16L284.02,454.16L284.02,454.9L282.83,455.49L282.39,458.15L281.8,459.04L280.91,459.34L280.47,460.37L280.62,462.29L277.66,463.62L277.51,464.96L276.33,464.96L275,465.55L274.11,466.73L272.19,465.99L270.71,466.73L268.93,467.17L267.31,466.88L267.46,471.17L265.83,471.31L264.94,473.09L265.68,473.68L265.39,475.6L263.02,475.01L262.87,477.67L261.25,478.11L261.98,481.66L261.84,483.14L260.95,483.88L259.17,483.88L259.77,485.8L260.06,488.32L259.62,490.09L258.25,491.73L258.25,491.73L257.79,491.59L257.79,491.59L253.3,490.63L253.3,490.63L249.58,485.07L248.67,484.74L247.81,485.04L246.51,486.25L246.51,486.25L244.67,487.47L244.67,487.47L242.52,487.84L242.52,487.84L241.99,487.74L241.99,487.74L241.03,486.76L241.03,486.76L240.32,486.18L238.67,485.9L238.67,485.9L237.4,486.94L237.4,486.94L236.87,487.37L236.87,487.37L235.32,487.67L234.03,486.84L234.11,485.55L234.39,485.2L234.11,484.52L233.73,484.11L232.36,484.44L232.36,484.44L231.04,484.67L231.04,484.67L228.6,483.06L228.02,484.07L228.02,484.07L227.99,484.7L225.35,485.78L222.59,486.01L222.18,486.34L222.18,486.34L221.69,487.26L221.95,488.05L221.95,488.05L221.52,488.5L218.68,488.98L218.68,488.98L215.99,489.03L215.99,489.03L211.04,486.5L211.04,486.5L210.49,486.09L209.27,486.32L209.27,486.32L208.48,486.49L208.48,486.49L206.25,487.12L205.43,488.56L201.65,490.67L201.65,490.67L200.23,490.98L200.23,490.98L199.09,490.35L196.85,490.95L196.85,490.95L196.35,491.18L193.07,491.08L191.93,490.7L191.38,490.27L190.11,487.25L190.62,486.98L190.62,486.98L192.34,487.3L192.34,487.3L193.57,487.35L192.96,484.66L192.05,483.07L191.3,482.48L191.3,482.48L187.66,482.94L186.03,483.57L185.5,483.27L185.25,482.72L184.44,482.49L184.44,482.49L182.89,482.57L181.85,483.68L181.85,483.68L179.38,485.59L178.06,485.54L178.06,485.54L177.07,485.67L176.51,486.17L176.51,486.17L176.79,488.24L176.79,488.24L176.56,488.74L176.56,488.74L173.64,491.36L173.82,492.18L173.56,494.2L173,494.91L171.96,494.68L170.54,495.03L169.96,496.19L168.71,496.69L168.71,496.69L167.01,497.35L167.01,497.35L164.27,496.93L163.26,495.92L162.93,495.16L163.5,494.96L163.59,494.36L162.81,490.99L162.4,490.54L160.32,490.06L159.41,490.46L159.41,490.46L157.63,490.16L157.63,490.16L151.06,489.76L151.06,489.76L147.21,489.73L147.21,489.73L144.01,488.96L142.39,487.77L142.39,487.77L141.38,486.03L139.55,484.57L136.76,483.92L135.49,484.07L135.49,484.07L134.35,483.94L134.35,483.94L131.88,483.25L131.88,483.25L130.04,481.45L130.04,481.45L129.26,480.5L129.85,477.28L130.96,476.73L130.96,476.73L128.33,477.29L128.33,477.29L127.12,478.33L127.12,478.33L125.82,479.25L123.99,479.52L122.63,478.89L121.53,475.41L121.6,474.83L122.16,474.43L122.16,474.43L122.52,473.59L122.52,473.59L121.84,470.76L121,470.27L120.78,468.91L120.78,468.91L120.96,466.73L120.96,466.73L121.46,466.81L121.95,467.6L121.95,467.6L122.35,467.89L122.35,467.89L124.94,466.73L125.09,466.22L123.94,465.55L122,466.07L120.31,464.46L120.57,463.23L123.53,462.54L124.8,461.27L125.79,460.86L125.79,460.86L126.79,461.12L127.49,460.83L129.99,455.88L129.84,454.99L129.84,454.99L127.95,455.49L127.95,455.49L127.95,455.49L127.95,455.49L127.14,452.46L127.13,451.78L127.56,451.09L128.29,450.73L129.63,451.23L131.18,450.92L131.18,450.92L133.12,449.71L133.12,449.71L131.81,449.38L131.31,448.54L131.31,448.54L131.47,446.81L131.47,446.81L132.72,444.9L136.11,442.86L137.87,442.6L139.13,441.2L139.13,441.2L140.13,437.77L139.87,436.63L139.87,436.63L139.49,434.73L139.49,434.73L139.99,433.71L139.99,433.71L141.11,431.42L140.99,430.65L139.98,429.9L139.98,429.9L139.47,429.13L139.59,427.73L138.83,426.34L136.82,426.6L136.44,425.96L139.07,422.13L139.07,422.13L137.06,421.37L137.06,421.37L136.18,420.87L137.93,417.66L137.93,417.66L138.81,416.25L139.57,417.66L139.57,417.66L140.2,418.04L140.2,418.04L141.08,418.03L141.83,417.52L142.21,416.49L142.21,416.49L142.33,415.73L142.08,414.96L142.08,414.96L141.19,415.09L139.93,414.58L139.93,414.58L139.18,413.82L138.54,411.78L138.54,411.78L138.54,411.01L139.04,410.49L139.04,410.49L139.93,411.51L139.93,411.51L141.06,412.53L142.7,413.29L144.59,413.03L144.96,411.62L144.96,411.62L145.84,409.56L146.21,409.3L146.21,409.3L148.48,408.91L149.42,409.35L148.99,410.7L148.48,411.09L148.48,411.09L147.85,410.96L147.48,411.22L147.99,413.01L147.99,413.01L148.62,413.39L150.25,413.26L150.63,413.51L149.63,414.16L149.63,414.16L148.49,414.8L147.36,413.53L146.48,415.07L146.36,415.83L146.36,415.83L146.61,416.34L148.12,416.85L151.52,417.34L156.68,416.3L156.68,416.3L158.32,416.29L158.32,416.29L158.95,417.31L158.7,418.08L158.83,419.23L158.83,419.23L159.08,419.86L159.96,419.73L160.47,420.5L160.22,421.65L160.22,421.65L158.97,423.18L158.21,423.06L157.33,423.32L156.83,424.21L156.83,424.21L157.72,427.9L157.73,431.72L157.73,431.72L157.23,433.12L156.6,433.51L156.6,433.51L155.97,433.38L155.59,432.75L152.45,433.14L152.45,433.14L150.69,434.8L150.69,434.8L151.7,435.18L151.7,435.18L153.84,437.46L155.48,438.59L156.24,438.08L156.36,436.68L157.87,435.91L157.87,435.91L159.63,435.65L160.89,435.14L161.39,434.37L161.89,432.21L161.89,432.21L163.9,430.93L164.52,429.4L164.52,429.4L165.21,426.86L166.28,427.61L169.43,427.85L169.43,427.85L173.33,428.59L174.08,427.45L175.34,427.06L175.34,427.06L176.47,427.05L176.73,427.94L176.1,428.71L176.36,429.85L178.12,430.86L179.76,430.6L179.76,430.6L180.38,429.71L180.38,429.2L180,427.93L179.12,426.66L178.72,421.3L179.1,421.05L179.1,421.05L180.74,421.42L180.99,422.57L181.5,423.21L182.38,422.95L182.38,422.95L183.07,420.59L183.07,420.59L182.87,419.33L182.87,419.33L182.37,417.99L180.72,416.66L180.72,416.66L179.47,416.95L179.47,416.95L178.55,416.56L178.83,415.04L180.34,414.91L180.84,414.39L180.84,414.39L180.46,412.35L180.46,412.35L180.08,411.71L179.95,410.56L179.95,410.56L180.58,409.66L182.09,410.03L186.62,408.73L186.62,408.73L188,408.47L189.01,409.23L189.01,409.23L190.14,408.2L191.02,406.66L191.02,406.66L190.12,402.04L189.49,401.4L188.61,401.53L188.11,402.05L187.11,403.98L187.11,403.98L184.46,403.48L184.46,403.48L182.58,404.26L182.58,404.26L178.8,403.89L178.8,403.89L178.04,403.77L175.52,402.37L174.14,401.21L173.63,400.45L173.25,397.87L173.25,397.87L173.87,396.71L173.87,396.71L174.11,392.72L173.73,391.17L173.73,391.17L175.24,390.78L175.24,390.78L177.57,389.3L177.57,389.3L177.89,388.19L177.89,388.19L183.73,384.03L183.73,384.03L185.92,383.03L185.92,383.03L187.59,381.81L188.97,380.14L188.97,380.14L189.62,380.17L189.62,380.17L190.65,379.97L198.52,375.79L198.52,375.79L198.83,375.45L198.83,375.45L200.19,373.42L203.98,371.89L204.27,370.62L206.41,369.65L206.41,369.65L206.82,369.63L206.82,369.63L207.41,369.91L207.41,369.91L208.1,368.94L208.1,368.94L209.6,368.88z"
				},
				{
					"id":"IN-MZ",
					"title":"Mizoram",
					"d":"M510.62,424.73L510.48,428.48L509.78,431.03L512.6,432.39L514.86,432.26L516.79,432.65L516.79,432.65L516.82,433.88L517.27,434.49L517.95,436.84L518.74,440.98L518.26,446.3L517.7,447.76L518.03,450.57L517.23,454.12L516.33,455.31L515.14,455.55L514.71,455.3L514.37,454.56L513.86,454.39L512.93,454.66L512.65,455.39L512.94,456.74L511.97,462.02L512.51,466.09L512.98,467.52L513.68,468.05L514.13,471.95L513.26,473.65L512.72,473.69L511.53,473.12L511.03,473.28L509.88,476.71L508.52,477.67L507.71,477.48L507.24,476.62L505.94,475.38L504.04,474.38L503.42,477.23L501.88,478.17L501.55,476.33L501.8,473.92L501.42,470.68L500.31,465.61L500.02,461.76L499.34,461.28L497.25,457.05L496.73,450.62L497.49,449.36L496.18,445.57L495.49,440.31L495.06,439.71L495.06,439.71L495.36,436.92L495.85,436.56L496.28,433.6L496.23,430.05L495.83,428.37L495.83,428.37L498.42,428.39L498.55,430.25L498.79,430.62L499.64,430.47L502.57,428.07L505.03,423.47L505.18,422.18L506.27,423.38L506.67,424.97L507.06,425.28z"
				},
				{
					"id":"IN-NL",
					"title":"Nagaland",
					"d":"M539.21,375.51L539.21,375.51L538.97,376.13L538.97,376.13L538.57,376.83L538.57,376.83L537.77,377.84L537.77,377.84L537.29,378.3L536.83,377.52L536.83,377.52L536.6,376.82L536.6,376.82L536.14,375.88L535.18,377.19L534.21,379.83L531.35,383.07L530.62,385.01L530.62,385.01L530.46,385.55L530.46,385.55L529.87,388.96L529.87,388.96L530.09,390.35L530.09,390.35L530.4,390.82L530.4,390.82L529.85,391.44L529.85,391.44L528.66,392.04L528.66,392.04L526.14,392.88L525.83,392.26L526.01,390.01L526.01,390.01L525.3,390.01L525.3,390.01L524.2,390.23L523.8,391.16L520.05,396.31L518.31,397.22L516.48,398.99L517.8,401.23L518.66,401.55L519.04,402.01L519.12,402.71L519.12,402.71L518.71,404.32L518.71,404.32L518.62,405.09L519.4,405.56L519.4,405.56L519.95,405.41L519.95,405.41L521.36,406.04L521.58,407.42L521.58,407.42L522.14,407.04L524.06,403.52L524.06,403.52L525.01,402.83L526.13,400.76L525.47,400.02L525.6,399.44L525.6,399.44L526.15,399.21L526.15,399.21L527.88,398.99L527.88,398.99L530.87,398.94L530.87,398.94L532.82,399.88L535.57,400.21L538.17,399.92L539.69,397.77L541.67,396.32L541.67,396.32L542.22,395.94L542.22,395.94L542.93,396.1L542.91,397.49L542.91,397.49L542.19,399.33L542.19,399.33L542.33,400.34L544.16,401.38L544.16,401.38L544.68,400.52L545.77,399.87L546.87,399.75L548.75,397.97L551.03,394.49L552.48,389.64L554.49,387.58L554.7,386.92L553.43,385.28L552.75,383.09L552.46,379.54L552.46,379.54L549.15,377.16L545.67,375.79L539.22,374.91L539.21,375.23z"
				},
				{
					"id":"IN-OR",
					"title":"Odisha",
					"d":"M380.69,473.16L380.98,473.99L383.58,475.07L385.94,475.39L387.12,476.32L387.25,477.78L386.78,479.11L387.65,480.24L388.7,480.23L388.83,478.9L390.01,477.9L391.62,478.32L391.46,479.95L392.58,481.28L394.48,482L395.53,481.99L396.19,482.72L396.83,486.31L396.83,486.31L393.71,487.41L391.21,487.68L389.31,488.55L387.1,490.36L384.5,493.57L383.59,495.45L383.59,497.46L384.56,500.38L386.18,503.7L386.16,504.4L384.73,504.96L385.71,506.29L387.48,506.8L383.03,509.77L381.95,510.8L381.37,511.61L381.17,512.95L381.37,513.44L382.9,512.05L382.89,513.14L381.02,515.34L379.81,516.19L376.45,517.64L375.08,521.81L374.18,521.91L372.38,520.18L370.47,519.86L371.47,520.98L373.73,522.23L372.02,523.42L369.68,524.27L358.93,527.39L355.18,528.85L354.77,528.12L355.39,527.7L357.19,527.29L357.72,525.05L356.88,524.07L355.34,523.58L353.17,525.19L352.63,525.98L350.82,527.11L349.42,529.61L348.87,530.09L348.49,532.16L349.22,532.21L349.78,531.41L349.86,530.75L350.69,530.14L351.04,529.08L352.26,529.25L353.73,528.5L354.29,528.83L353.77,529.88L351.93,530.21L352.13,530.59L352.69,530.78L349.65,532.77L343.47,538.19L341.62,540.58L340.31,540.45L340.31,540.45L339.27,539.78L337.02,539.49L333.9,542.9L333.81,544.1L331.23,546.85L328.54,547.61L326.88,547.62L325.12,546.73L323.27,547.33L321.11,546.74L321.2,543.05L320.91,542.45L320.22,542.16L319.93,543.16L317.48,539.12L316.36,539.68L316.58,540.48L315.14,542.18L313.58,543.08L311.77,542.19L310.94,543L311.19,544.09L312.32,544.29L313,545.28L312.22,546.28L309.88,547.59L308.61,547.79L307.73,547.3L307.24,547.4L305.2,550L305.49,551.49L306.47,552.78L306.14,555.62L303.74,556.38L301.59,554.99L297.01,559.19L296.23,558.5L295.05,555.22L294.9,553.73L293.67,553.04L293.09,553.19L291.72,554.93L291.05,558.72L290.37,560.11L291.15,561L291.16,562.69L289.4,564.68L288.81,564.48L287.64,563.2L286.47,562.91L284.12,564.01L282.95,565.2L281.39,565.51L279.63,566.31L278.66,568L276.46,568.85L274.66,569.01L274.66,569.01L275.34,567.69L276.15,567.05L276.15,567.05L276.81,565.52L276.81,565.52L277.71,562.22L277.76,560.03L278.75,559.16L279.46,559.09L282.08,556.89L282.08,556.89L285.69,552.4L285.41,550.77L285.41,550.77L287.06,549.58L288.74,549.01L290.64,547.38L292.07,544.88L292.17,543.94L291.36,540.81L291.36,540.81L290.53,537.47L290.84,533.87L287.75,531.86L287.75,527.45L287.75,527.45L287.65,525.69L285.65,524.04L285.65,524.04L283.85,522.97L283.85,522.97L283.3,521.85L283.3,520.88L283.76,520.08L285.53,518.81L286.12,518.88L286.14,519.43L286.14,519.43L287.33,520.63L287.33,520.63L290.91,521.4L291.14,521L291.14,521L291.8,520.93L291.8,520.93L293.85,524.02L294.35,524.59L294.87,524.71L294.87,524.71L295.54,524.24L297.94,523.99L299.12,524.32L299.12,524.32L299.05,525.21L299.69,525.7L299.69,525.7L301.96,523.99L301.96,523.99L301.64,520.95L301.01,520.5L299.33,521.22L295.58,519.58L295.22,519.28L295.02,517.83L295.02,517.83L295.33,515.66L295.33,515.66L295.74,514.39L295.59,513.61L295.59,513.61L295.13,511.71L295.13,511.71L294.45,509.54L293.45,502.3L293.45,502.3L293.49,501.38L293.49,501.38L294.82,501.74L295.25,502.29L295.25,502.29L296.75,502.32L296.97,501.82L296.97,501.82L297.31,499.54L297.31,499.54L299.83,495.32L299.83,495.32L301.4,494.84L309.67,495.77L311.04,494.54L311.04,494.54L312.59,490.46L314.88,490.87L314.88,490.87L315.28,489.81L315.28,489.81L315.11,488.52L315.11,488.52L314.22,487.72L313.92,486.79L315.14,484.72L315.67,484.24L316.21,484.37L316.66,483.79L316.66,483.79L316.77,480.68L316.77,480.68L317.45,480.1L317.85,480.43L317.85,480.43L318.86,479.22L318.86,477.69L318.35,477.03L318.35,477.03L317.82,475.63L318.63,473.02L319.88,471.05L320.36,470.69L321.5,470.87L321.5,470.87L323.18,469.58L324.3,468.26L326.05,468.18L326.05,468.18L326.73,467.63L327.39,466.31L327.39,466.31L327.39,466.31L327.39,466.31L329.5,468.81L332.39,469.79L333.38,469.86L333.38,469.86L334.96,469.72L335.78,469.08L335.81,468.38L335.81,468.38L338.77,467.76L343.73,467.61L344.45,468.17L347.18,466.66L347.18,466.66L347.77,466.79L348.1,469.92L347.64,471.85L347.64,471.85L346.85,474.19L350.95,477.16L350.95,477.16L351.9,475.29L351.9,475.29L354.47,473.75L354.47,473.75L357.52,475.5L357.52,475.5L358.21,475.73L358.21,475.73L360.97,476.18L362.15,477.84L363.4,478.16L363.4,478.16L364.52,478.36L364.52,478.36L366.56,475.15L366.89,473.16L366.83,468.49L366.04,467.1L365.25,466.37L365.58,466.1L365.58,466.1L367.35,465.16L367.35,465.16L367.94,465.35L368.47,466.02L368.47,466.02L368.73,466.55L370.7,466.94L370.7,466.94L372.21,467.53L373.86,469.79L373.86,469.79L374.45,470.19L374.45,470.19L375.24,470.44L375.7,470.25L375.7,470.25L378.13,470.64L378.13,470.64L379.44,471.43z"
				},
				{
					"id":"IN-PY",
					"title":"Puducherry",
					"d":"M290.24,592.02l-0.97,-0.05l-0.76,-0.59l0.36,-0.65l1.82,0.71l0.01,0.46L290.24,592.02zM240.68,690.55l-0.24,1.01l0,0l-0.46,-0.2l0.03,-0.47l0.35,-0.41L240.68,690.55zM236.99,691.45l-0.31,0.2l-0.23,-0.45l0.67,-0.47L236.99,691.45zM235.91,692.03l-0.43,-1.03l0.47,-0.19L235.91,692.03zM240.15,692.62l-0.61,1.9l0,0l-1.53,-0.08l-1.31,-0.77l0.54,-1.42l0.78,-0.85l1.49,0.63L240.15,692.62zM236.26,694.63l-0.69,0.03l-0.39,-0.68l1.11,0.03L236.26,694.63zM239.32,695.14l-0.37,1.24l0,0l-1.33,-0.53l0.21,-0.86L239.32,695.14zM236.95,695.54l-0.55,0.14l-0.03,-0.49l0.47,-0.03L236.95,695.54zM151.94,696.47l-0.04,0.3l-0.32,-0.14l-0.04,-0.59L151.94,696.47zM240.31,712.4l-0.24,3.54l0,0l-2.2,-1.78l-0.31,-0.71l0.61,-1.11l1.09,-0.48L240.31,712.4z"
				},
				{
					"id":"IN-PB",
					"title":"Punjab",
					"d":"M177.52,274.51L177.14,274.92L177.72,276.42L178.4,276.66L178.54,277.52L178.54,277.52L177.96,277.7L176.79,277.33L175.95,277.83L175.43,278.54L176.11,279.59L177.43,280.31L178.21,279.82L178.21,279.82L179.15,281.12L179.93,281.57L180.18,282.22L179.84,287.63L179.48,287.91L179.06,287.63L179.04,286.72L178.65,286.05L177.11,285.88L176.23,286.24L176.07,287.65L173.85,290.22L174.71,291.35L174.21,292.6L172.32,294.12L168.07,293.52L166.78,292.92L166.33,293.49L165.83,296.06L166.34,299.13L162.42,301.94L160.44,302.29L158.92,301.76L158.15,300.32L157.08,300.07L155.85,300.3L152.76,301.85L150.13,300.46L147.42,303.59L146.8,304.79L147.03,305.95L145.57,306.42L144.14,303.65L145.47,301.72L144.75,299.69L141.88,298.75L140.73,298.87L139.4,297.76L139.01,297.07L136.99,296L134.65,296.67L133.38,297.73L132.43,297.68L130.71,296.93L130.71,296.93L129.43,296.71L128.42,297.33L123.36,296.86L118.64,296.78L116.99,296.38L116.98,295.7L118.26,294.2L119.1,292.12L119.1,292.12L119.53,291.32L119.36,289.75L117.58,287.07L118.24,286.08L118.74,285.98L118.9,284.98L119.46,285.11L119.89,284.09L120.92,283.25L121.59,283.63L121.82,283.41L121.96,283.04L121.62,282.81L122.13,282.32L122.09,281.43L122.46,281.6L122.65,280.97L123.32,280.96L124.99,278.9L126.01,278.64L125.6,277.75L126.33,277.4L126.09,277L126.71,275.86L127.26,275.69L127.67,275.9L127.72,274.96L128.76,274.47L128.86,273.99L129.88,273.04L130.41,273.01L131.27,272.38L131.14,271.93L131.68,270.62L132.54,271.19L133,271.11L134.02,270.76L134.47,269.95L134.12,269.12L133.58,269.01L133.18,269.34L132.98,268.96L132.38,269.05L132.39,270.15L132.24,269.96L131.55,270.19L131.37,269.33L130.58,268.93L130.51,267.9L130.94,266.32L130.71,265.73L131.1,265.1L131.55,265.11L132.42,262.75L133.06,262.12L133.4,261.25L132.96,260.81L133.08,260.61L131.83,260.25L132.02,259.78L132.61,259.47L132.55,258.66L130.84,254.94L130.85,254.41L131.55,254.21L131.39,253.66L131.64,252.4L132.13,252.04L132.54,251.02L133,251.14L133.76,250.25L134.65,250.09L134.78,249.29L135.32,249.79L135.57,249.43L136.83,249.36L137.02,248.34L137.58,248.06L137.47,247.79L137.97,247.71L138.13,247.06L138.64,247.09L139.22,246.7L140.84,247.59L142.63,246.85L143.13,246.29L143.71,246.28L144.12,246.64L144.54,246.26L144.75,245.47L145.31,245.57L145.42,246.24L145.65,246.18L146.32,245.56L146.55,244.86L147.19,244.44L147.25,243.63L147.58,243.35L147.19,243.1L147.85,243.03L148.19,242.62L148.27,241.8L147.72,241.32L147.65,240.5L147.13,239.96L147.13,239.96L150.11,239.99L150.67,240.63L150.53,241.73L151.1,241.97L151.65,241.49L151.85,240.2L152.71,239.23L155.09,238.58L155.66,237.96L155.78,237.35L157.81,236.25L158.23,235.59L158.23,235.59L159.76,237.14L160.57,238.5L159.99,239.65L158.92,240.59L154.63,242.22L154.1,243.32L155.01,246.59L156.92,247.54L159.01,249.05L160.48,250.83L161.25,252.44L160.74,252.59L160.39,253.1L161.45,255.74L164.81,261.98L165.32,264.92L167.53,264.86L168.4,263.42L170.04,263.37L170.76,264.88L172.76,266.08L174.45,267.8L173.95,271.39L174.22,272.12z"
				},
				{
					"id":"IN-RJ",
					"title":"Rajasthan",
					"d":"M119.1,292.12L118.26,294.2L116.98,295.7L116.99,296.38L118.64,296.78L123.36,296.86L128.42,297.33L129.43,296.71L130.71,296.93L130.71,296.93L130.5,299.54L129.56,300.02L129.35,301.18L129.68,301.8L130.62,301.87L132.35,301.27L132.51,302.03L131.94,303.75L131.75,306.16L132.63,306.84L131.97,308.08L130.94,308.49L132.13,311.16L135.91,310.65L136.74,309.82L137.27,309.82L138.58,310.31L139.16,311.27L139.32,312.43L141.99,313.6L145.21,313.77L148.36,313.27L148.87,313.43L148.85,314.99L148.56,315.42L148.66,317.81L151.15,319.3L151.41,319.8L151.23,320.61L150.45,321.21L152.04,327.49L155.22,331.29L157.46,333.22L159.64,334.26L161.36,336.12L163.18,339.1L162.77,339.25L162.42,338.76L161.79,338.79L159.86,340.36L160.17,343.99L160.92,346.26L164.46,346.57L165.45,345.6L164.56,342.23L165.03,341.25L166.53,341.08L167.34,341.93L167.92,342.02L168.49,341.05L168.42,338.77L170.75,339.18L171.14,339.55L171.28,340.03L170.34,340.02L170.7,341.58L172.81,343.54L174.72,341.48L174.74,340.42L177.97,337.76L178.95,337.34L181.07,339.24L180.24,342.18L180.19,346.23L179.65,349.29L179.93,350.11L180.34,350.31L181.56,349.94L181.78,348.95L185.39,346.65L186.37,346.7L186.82,347.21L187.93,346.9L188.5,346.28L188.5,346.28L188.15,347.65L188.25,348.56L189.6,353.29L191.1,356.76L191.1,356.76L193.05,357.86L193.05,357.86L195.55,360.3L195.49,361.96L195.49,361.96L194.19,363.39L192.78,363.65L192.78,363.65L192.18,364.11L193.61,365.21L195.24,365.66L196.1,365.2L197.21,365.46L197.27,366.31L195.88,366.83L195.88,366.83L192.32,368.26L192.32,368.26L191.13,368.84L190.65,370.46L190.64,371.24L190.99,371.79L190.99,371.79L191.82,371.5L196.78,368.19L196.78,368.19L197.05,367.8L199.08,367.92L199.08,367.92L202.36,368.5L204.93,367.33L204.93,367.33L207.55,367.46L207.55,367.46L207.68,368.04L207.21,368.62L207.21,368.62L206.41,369.34L206.82,369.63L206.82,369.63L206.82,369.63L206.82,369.63L206.41,369.65L206.41,369.65L204.27,370.62L203.98,371.89L200.19,373.42L198.83,375.45L198.83,375.45L198.52,375.79L198.52,375.79L190.65,379.97L189.62,380.17L189.62,380.17L188.97,380.14L188.97,380.14L187.59,381.81L185.92,383.03L185.92,383.03L183.73,384.03L183.73,384.03L177.89,388.19L177.89,388.19L177.57,389.3L177.57,389.3L175.24,390.78L175.24,390.78L173.73,391.17L173.73,391.17L174.11,392.72L173.87,396.71L173.87,396.71L173.25,397.87L173.25,397.87L173.63,400.45L174.14,401.21L175.52,402.37L178.05,403.77L178.8,403.89L178.8,403.89L182.58,404.26L182.58,404.26L184.46,403.48L184.46,403.48L187.11,403.98L187.11,403.98L188.11,402.05L188.61,401.53L189.49,401.4L190.12,402.04L191.02,406.66L191.02,406.66L190.14,408.2L189.01,409.23L189.01,409.23L188,408.47L186.62,408.73L186.62,408.73L182.09,410.03L180.58,409.66L179.95,410.56L179.95,410.56L180.08,411.71L180.46,412.35L180.46,412.35L180.84,414.39L180.84,414.39L180.34,414.91L178.83,415.04L178.55,416.56L179.47,416.95L179.47,416.95L180.72,416.66L180.72,416.66L182.37,417.99L182.87,419.33L182.87,419.33L183.07,420.59L183.07,420.59L182.38,422.95L182.38,422.95L181.5,423.21L180.99,422.57L180.74,421.42L179.1,421.05L179.1,421.05L178.72,421.3L179.12,426.66L180,427.93L180.38,429.2L180.38,429.71L179.76,430.6L179.76,430.6L178.12,430.86L176.36,429.85L176.1,428.71L176.73,427.94L176.47,427.05L175.34,427.06L175.34,427.06L174.08,427.45L173.33,428.59L169.43,427.85L169.43,427.85L166.28,427.61L165.21,426.86L164.52,429.4L164.52,429.4L163.9,430.93L161.89,432.21L161.89,432.21L161.39,434.37L160.89,435.14L159.63,435.65L157.87,435.91L157.87,435.91L156.36,436.68L156.24,438.08L155.48,438.59L153.85,437.46L151.7,435.18L151.7,435.18L150.69,434.8L150.69,434.8L152.45,433.14L152.45,433.14L155.59,432.75L155.97,433.38L156.6,433.51L156.6,433.51L157.23,433.12L157.73,431.72L157.73,431.72L157.72,427.9L156.83,424.21L156.83,424.21L157.33,423.32L158.21,423.06L158.97,423.18L160.22,421.65L160.22,421.65L160.47,420.5L159.96,419.73L159.08,419.86L158.83,419.23L158.83,419.23L158.7,418.08L158.95,417.31L158.32,416.29L158.32,416.29L156.68,416.3L156.68,416.3L151.52,417.34L148.12,416.85L146.61,416.34L146.36,415.83L146.36,415.83L146.48,415.07L147.36,413.53L148.49,414.8L149.63,414.16L149.63,414.16L150.63,413.51L150.25,413.26L148.62,413.39L147.99,413.01L147.99,413.01L147.48,411.22L147.85,410.96L148.48,411.09L148.48,411.09L148.99,410.7L149.42,409.35L148.48,408.91L146.21,409.3L146.21,409.3L145.84,409.56L144.96,411.62L144.96,411.62L144.59,413.03L142.7,413.29L141.06,412.53L139.93,411.51L139.93,411.51L139.04,410.49L139.04,410.49L138.54,411.01L138.54,411.78L138.54,411.78L139.18,413.82L139.93,414.58L139.93,414.58L141.19,415.09L142.08,414.96L142.08,414.96L142.33,415.73L142.21,416.49L142.21,416.49L141.83,417.52L141.08,418.03L140.2,418.04L140.2,418.04L139.57,417.66L139.57,417.66L138.81,416.25L137.93,417.66L137.93,417.66L136.18,420.87L137.06,421.37L137.06,421.37L139.07,422.13L139.07,422.13L136.44,425.96L136.82,426.6L138.83,426.34L139.59,427.73L139.47,429.13L139.98,429.9L139.98,429.9L140.99,430.65L141.11,431.42L139.99,433.71L139.99,433.71L139.49,434.73L139.49,434.73L139.87,436.63L139.87,436.63L140.13,437.77L139.13,441.2L139.13,441.2L137.87,442.6L136.11,442.86L132.72,444.9L131.47,446.81L131.47,446.81L131.31,448.54L131.31,448.54L131.81,449.38L133.12,449.71L133.12,449.71L131.18,450.92L131.18,450.92L129.63,451.23L128.29,450.73L127.56,451.09L127.13,451.78L127.61,454.15L126.6,453.57L126.6,453.57L125.49,451.6L125.49,451.6L123.28,451.82L123.28,451.82L123.07,450.13L123.07,450.13L121.75,448.86L119.94,447.88L119.23,447.99L119.14,448.49L118.03,447.81L118.03,447.81L116.71,446.24L116.71,446.24L115.81,446.04L114.7,446.36L112.79,445.58L112.79,445.58L112.79,445.58L112.79,445.58L113.28,443.19L112.47,442.01L112.47,442.01L111.16,441.92L110.15,439.94L110.15,439.94L107.53,438.57L107.53,438.57L107.53,438.57L107.53,438.57L107.12,438.08L106.92,436.99L107.32,435.99L107.92,435.88L108.42,435.37L107.9,432.28L107.9,432.28L107.9,432.28L107.9,432.28L106.99,431.29L105.19,433.41L104.58,433.22L101.56,430.16L101.56,430.16L101.56,430.16L101.56,430.16L101.25,428.86L102.65,426.24L101.82,422.44L101.82,422.44L101.82,422.44L101.82,422.44L99.41,422.77L98.81,424.48L98.11,425.29L94.59,425.53L93.38,424.75L93.38,424.75L92.77,423.45L92.77,423.45L90.35,422.28L87.64,422.21L84.32,421.15L84.32,421.15L84.32,421.15L84.32,421.15L84.71,420.14L84.31,419.65L84.31,419.65L81.89,419.77L81.29,418.58L81.29,418.58L79.37,417.99L72.44,419.28L70.62,418.5L68.91,418.22L63.99,419.69L61.57,419.02L60.63,418.44L60.87,418.21L60.17,417.5L59.15,415.05L57.55,412.5L56.5,407.78L53.88,405.06L53.42,403.79L52.06,401.94L52.27,399.36L52.03,399.21L52.13,396.11L51.82,395.29L50.72,394.89L48.64,395.64L45.93,395.77L44.67,395.39L44,395.1L40.67,390.45L40.02,388.93L40.1,386.46L41.42,384L41.73,382.79L42,376.5L41.6,375.76L39.51,374.78L34.36,374.94L33.52,374.45L32.46,373.27L28.13,371.36L27.6,369.79L28.14,365.63L29.67,361.54L31.97,359.25L33.14,358.52L38.49,352.85L40.36,347.99L41.37,346.44L45.67,342.42L48.61,341.78L49.86,342.31L51.81,344.41L51.94,346.26L53.39,348.88L54.34,349.3L56.29,349.57L64.27,346.26L67.08,345.71L72.18,345.63L77.08,343.59L77.82,339.67L79.1,337.82L82.97,334.32L85.38,327.19L87.08,324.88L93.78,320.89L98.51,318.74L99.71,315.94L101.54,313.56L105.27,306.34L107.86,297.29L112.25,295.4L115.86,294.36L119.34,291.56z"
				},
				{
					"id":"IN-SK",
					"title":"Sikkim",
					"d":"M420.51,340.01L421.16,340.89L422.37,340.86L424.57,342.38L424.64,344.18L425.15,344.37L425.48,345.48L425.55,346.33L425.01,346.84L425.14,348.38L424.68,349.29L424.83,349.6L424.52,350.58L424.09,350.87L423.22,352.6L423.17,353.16L423.51,355.43L423.89,356.06L426.3,358.34L425.76,359.26L424.11,359.77L423.12,361.39L422.93,362.22L422.93,362.22L419.58,361.69L416.45,364.07L407.7,362.15L407.7,362.15L408.64,353.37L409.95,351.56L411.32,347.63L411.34,346.09L410.41,345.7L409.98,344.75L410.31,343.78L411.35,343.91L411.57,343.55L412.26,343.43L412.48,343.79L413.89,343.14L415.48,343.11L418.05,341.58L418.54,341.71L418.81,341.04L420.29,339.9z"
				},
				{
					"id":"IN-TN",
					"title":"Tamil Nadu",
					"d":"M245.77,660l2.92,0.72l1.5,1.39l0.29,1.18l-0.56,3.55l-1.19,4.59l-0.15,3.79l-1.97,6.26l-5.94,9.07l0,0l-0.32,-0.06l-0.35,0.41l-0.03,0.47l0.46,0.2l0,0l-0.29,1.07l0,0l-0.64,-0.58l-1.49,-0.63l-0.78,0.85l-0.54,1.42l1.31,0.77l1.53,0.08l0,0l-0.22,0.61l0,0l-1.48,-0.15l-0.21,0.86l1.33,0.53l0,0l-0.73,4.24l0.66,2.64l0.96,1.79l0.47,4.08l-0.01,3.27l0,0l-1.06,-0.53l-1.09,0.48l-0.61,1.11l0.31,0.71l2.2,1.78l0,0l0.48,8.96l-0.13,2.07l-1.44,0.34l-0.82,-0.68l-1.32,-0.06l1.36,0.46l0.37,0.4l-1.16,-0.05l-6.52,-1.08l-1.42,0.79l-1.69,2.01l-0.01,2.06l0.37,0.77l-0.19,0.6l-5.5,7.3l-0.79,1.36l-0.7,2.57l0.66,1.33l1.4,1.61l2.35,0.81l2.14,0.02l2.13,0.57l2.35,2.15l-0.69,-0.18l-1.24,-1.07l-1.18,-0.54l-6.7,-0.55l-11.45,3.64l-3.7,2.79l-0.76,1.19l-0.36,0.83l-0.93,7.88l-1.39,2.38l-1.34,0.57l-4.29,2.93l-4.29,1.38l-0.88,1.17l-4.86,-1.26l-4.23,-3.33l0,0l1.6,-1.91l0.86,-2.23l1.17,-0.92l0.04,-0.54l-0.1,-0.61l-1.17,-1.54l-0.7,-1.55l1.54,-2.45l0.06,-0.54l-1.62,-2.03l-0.47,-1.29l0.75,-1.43l1.08,-0.84l0.6,-2.93l1.35,-1.34l1.33,-3.54l-0.87,-1.3l-1.83,0.33l-2,-0.5l1.08,-3.48l0.46,-3.54l-0.25,-2.24l1.06,-3.71l-1.46,-2.38l-0.62,-0.1l-2.31,0.95l-0.87,1.19l-1.21,0.62l-1.25,-0.36l-1.54,-1.22l-0.29,-2.77l0.25,-3.43l0.87,-1.8l0.58,-2.21l-1.46,-1.87l-2,-0.28l-1.75,-0.77l0.71,-1.68l1.46,-0.99l-0.35,-3.33l-0.52,-0.43l-1.5,0.99l-4.36,-0.07l0.49,-0.61l1.46,-0.87l0.63,-1.43l-1.13,-1.06l-2.58,-1.18l-2.66,-0.56l0.13,-1.92l0.33,-0.49l0.37,0.29l1.96,-0.62l1.21,-0.76l0.13,-0.64l0,0l1.41,-0.88l0.77,0.66l0.63,1.23l1.26,0.5l2.69,-0.25l1.54,0.5l0.45,-2.77l0.8,-1.52l2.55,-0.44l2.19,0.75l2.64,-0.58l3.65,1.09l0.64,-1.08l-0.38,-0.53l0.28,-1.29l0.83,-0.7l0.52,0.11l2.28,-0.64l2.38,-3.07l-0.01,-0.64l-0.73,-1.13l-2.2,-0.43l-2.76,0.04l0.02,-1.44l1.08,-0.33l1.72,-1.75l0.42,-2.73l-0.67,0.37l-0.41,-1.92l0.78,-2.17l2.27,0.14l1.17,-1.48l0.59,-1.67l-0.3,-0.33l2,-0.96l0.62,0.14l-0.24,0.58l0.36,0.47l3.74,0.25l2.55,0.99l0,0l0.55,1.65l3.76,1.38l3.22,-4l0.01,-3.79l2.39,-1.59l3.27,-0.43l1.5,0.28l2.77,1.1l1.77,-0.88l1.83,-1.37l1.77,-0.22l1.83,-0.99l0.44,-0.66l-0.55,-1.27l-1.19,-0.36l1.8,-0.63l1.33,0.17l4.26,2.76l4.14,-3.79l0.64,-1.76l1.24,-1.07L245.77,660zM236.45,691.21l0.23,0.45l0.31,-0.2l0.13,-0.71L236.45,691.21zM235.48,691l0.31,1.14l0.16,-1.33L235.48,691zM235.19,693.97l0.39,0.68l0.39,0.06l0.3,-0.08l0.03,-0.63L235.19,693.97zM236.37,695.18l0.03,0.49l0.55,-0.14l-0.11,-0.38L236.37,695.18z"
				},
				{
					"id":"IN-TR",
					"title":"Tripura",
					"d":"M495.83,428.37L496.23,430.05L496.28,433.6L495.85,436.56L495.36,436.92L495.06,439.71L495.06,439.71L493.71,440L493.14,439.32L490.93,441.25L490.22,441.35L488.7,439.53L488.29,440.58L488.86,444.47L487.95,445.88L486.37,446.59L485.11,448.77L484.79,450.05L485.82,453.7L485.01,454.88L483.91,455.82L481.58,456.93L480.56,456.02L478.77,450.81L477.77,449.89L477.29,449.8L476.82,450.84L477.23,454.15L476.72,454.22L476.35,453.9L475.86,452.94L474.26,445.67L473.32,444.36L472.35,441.67L472.25,439.57L472.44,439.14L473.43,438.9L474.19,437.02L473.89,435.64L474.54,434.15L476.87,431.1L477.66,431.01L480.24,431.51L484.46,430L487.14,430.07L487.63,429.5L488.14,427.14L487.93,426.13L488.45,425.64L489.15,426.29L491.95,424.73L492.27,424.29L492.44,421.67L492.44,421.67L494.17,422.69L494.64,423.45L494.96,425.65L493.96,428.45z"
				},
				{
					"id":"IN-UP",
					"title":"Uttar Pradesh",
					"d":"M335.93,391.95L333.08,390.19L329.06,388.6L326.69,385.43L326.27,383.71L326.9,383.17L329.35,382.53L329.35,382.53L329.34,380.22L328.32,379.73L328.32,379.73L327.45,379.7L324.2,378.02L324.2,378.02L323.93,377.49L323.93,377.49L324,376.36L325.35,376.09L325.35,376.09L325.75,376.28L325.75,376.28L326.88,376.31L327.3,375.21L327.3,375.21L327.6,374.27L328.76,374.14L329.86,374.41L329.86,374.41L333.89,374.51L333.89,374.51L333.84,373.13L333.84,373.13L331.57,371.44L330.77,370.26L330.77,370.26L330.71,368.7L330.32,368.33L328.49,369.29L328.49,369.29L327.13,368.23L326.76,367.56L326.76,367.56L326.69,366.03L326.69,366.03L325.01,360.72L325.01,360.72L323.63,358.98L323.63,358.98L322.75,358.46L322.75,358.46L322.23,358.13L322.23,358.13L322.5,357.54L317.36,354.85L313.47,354.76L312.62,357.01L311.91,357.76L311.25,357.9L310.5,357.71L310.05,356.67L308.51,355.36L305.48,355.3L300.1,354.06L299.09,349.75L298.75,349.27L294.19,350.16L293.18,350.05L287.42,345.74L285.26,344.49L283.74,344.61L282.34,345.96L279.87,344.67L278.77,343.63L273.67,340.65L271.53,338.76L269.97,338.81L267.82,334.11L264.49,333.27L262.42,332.28L254.44,326.71L253.71,327.41L253.81,328.21L253.02,328.93L251.28,328.12L248.47,325.26L246.6,324.28L246.6,324.28L245.75,325.2L245.16,326.75L244.15,327.02L243.08,326.81L242.9,326.08L242.37,325.61L241.66,325.61L241.24,325L240.18,325.27L240.41,323.25L239.05,323.18L237.21,323.72L231.94,323.39L231.17,321.97L228.21,320.96L226.31,319.88L225.54,319.82L225.54,318.74L224.77,317.19L222.87,317.05L221.04,317.46L220.44,317.32L220.21,315.97L219.44,315.97L218.67,315.36L217.24,313.54L217.24,312.86L217.54,312.26L219.67,311.71L220.5,310.84L218.31,309.89L212.44,305.55L211.14,303.04L209.6,301.82L208.71,301.55L207.64,302.57L205.98,302.5L205.45,302.91L205.45,303.79L205.03,304.26L203.61,304.6L202.78,306.71L202.01,306.77L200.12,305.48L200.41,303.11L198.34,303.79L196.21,303.79L195.85,303.04L195.85,301.34L194.84,299.85L195.14,298.56L196.74,296.72L197.86,293.25L197.86,292.36L200,291.61L195.43,290.04L193.63,288.48L193.63,288.48L192.57,291.47L191.88,292.28L189.31,293.73L189.31,293.73L187.61,295.07L185.88,297.24L185.88,297.24L185.84,298.93L185.28,300.53L184.38,300.67L184.38,300.67L184.25,307.47L184.86,309.84L184.86,309.84L184.38,310.74L184.38,310.74L184.47,316.8L184.47,316.8L185.77,319.77L185.86,320.59L185.86,320.59L185.56,323.01L185.56,323.01L186.02,323.59L186.02,323.59L186.34,326.63L186.34,326.63L186.86,328.19L186.86,328.19L188.28,330.27L188.28,330.27L189.09,330.92L189.09,330.92L191.28,332.65L191.91,333.62L192.54,336.72L192.54,336.72L191.33,340.22L191.33,340.22L191.4,341.64L192.07,342.1L192.34,342.92L192.34,342.92L191.27,344.36L188.79,346.28L188.79,346.28L188.5,346.28L188.5,346.28L188.15,347.65L188.25,348.56L189.6,353.29L191.1,356.76L191.1,356.76L193.05,357.86L193.05,357.86L195.55,360.3L195.49,361.96L195.49,361.96L194.19,363.39L192.78,363.65L192.78,363.65L192.18,364.11L193.61,365.21L195.24,365.66L196.1,365.2L197.21,365.46L197.27,366.31L195.88,366.83L195.88,366.83L192.32,368.26L192.32,368.26L191.13,368.84L190.65,370.46L190.64,371.24L190.99,371.79L190.99,371.79L191.82,371.5L196.78,368.19L196.78,368.19L197.05,367.8L199.08,367.92L199.08,367.92L202.36,368.5L204.93,367.33L204.93,367.33L207.55,367.46L207.55,367.46L207.68,368.04L207.21,368.62L207.21,368.62L206.41,369.34L206.82,369.63L206.82,369.63L207.41,369.91L207.41,369.91L208.1,368.94L208.1,368.94L209.6,368.88L210.19,369.67L210.19,369.67L213.28,371.02L213.28,371.02L214.46,371.23L215.09,370.68L215.09,370.68L216.23,370.32L216.23,370.32L217.67,370.55L221.55,372.62L222.5,373.78L224.42,377.73L224.42,377.73L225.18,378.38L225.18,378.38L225.56,379.28L225.19,382.91L224.06,384.21L223.31,384.47L222.18,385.9L221.93,386.68L222.31,387.32L222.31,388.23L222.31,388.23L220.56,393.14L218.18,394.96L216.92,397.28L215.16,398.58L215.16,398.58L212.27,398.59L211.52,400.4L210.52,401.69L209.63,401.56L209.01,402.72L210.15,406.06L211.16,407.08L211.16,407.08L210.79,408.75L210.79,408.75L209.54,412.08L207.4,413.63L207.4,413.63L206.3,414.67L206.3,414.67L206.86,416.9L207.69,418.12L207.69,418.12L207.84,422.94L207.84,422.94L207.3,423.64L209.95,424.86L210.08,425.88L210.08,425.88L211.47,426.51L211.47,426.51L212.6,425.1L214.11,425.6L215.75,427.51L215.75,427.51L216.38,428.27L216.38,428.27L218.27,429.15L218.27,429.15L219.03,429.15L219.03,429.15L220.03,428.63L220.78,426.97L222.79,425.69L223.04,425.05L222.91,423.91L221.39,420.47L221.39,420.47L220.89,419.83L220.89,419.83L218.63,420.74L218.63,420.74L217.74,419.85L217.49,418.95L217.61,417.55L217.61,417.55L217.73,414.61L217.73,414.61L216.84,413.84L216.08,412.44L216.08,412.44L214.81,408.09L214.56,405.91L213.67,404.76L213.42,403.86L213.54,403.34L216.56,401.4L216.56,401.4L217.06,401.78L217.06,401.78L216.31,402.62L217.44,403.45L218.2,403.58L218.7,402.16L218.7,402.16L219.2,400.49L220.83,398.81L222.09,399.45L222.48,402.27L222.48,402.27L220.46,402.8L220.46,402.8L219.96,403.96L219.96,403.96L220.73,407.8L220.73,407.8L222.24,406.51L222.74,405.23L223.49,404.84L223.49,404.84L223.75,407.79L224.13,408.3L226.65,409.06L229.42,408.53L229.42,408.53L230.17,406.99L230.04,406.35L230.04,406.35L229.79,405.71L229.09,405.39L228.4,405.46L228.4,405.46L228.02,404.82L228.27,404.17L228.27,404.17L229.78,403.91L232.31,406.21L230.8,408.27L232.06,409.42L233.2,409.54L233.95,408L234.7,407.74L239.99,409.63L240.62,408.09L240.36,406.94L240.36,406.94L240.49,406.43L241.12,405.91L244.26,403.84L248.03,402.41L248.03,402.41L248.91,402.28L248.91,402.28L249.69,403.02L249.69,403.02L251.54,405.51L251.91,407.1L250.49,407.83L248.43,409.98L248.68,410.88L249.06,411.39L249.56,411.51L249.56,411.51L252.08,411.24L252.08,411.24L254.09,409.95L257.87,410.06L257.87,410.06L258.88,410.06L258.88,410.06L257.74,409.17L257.36,408.4L257.36,408.4L260.13,407.23L261.26,407.48L261.26,407.48L260.76,409.67L259.26,412.62L259.26,412.62L259.64,413L260.39,413L261.53,412.48L261.53,412.48L261.9,412.22L264.55,412.47L265.56,413.49L267.7,413.09L268.75,407.64L270.45,407.83L271.58,408.33L272.47,408.2L272.47,408.2L273.34,407.04L275.23,407.03L275.62,409.85L278.89,411.38L280.4,411.11L280.4,411.11L281.54,410.98L281.54,410.98L281.67,413.54L282.55,414.69L283.56,415.06L283.56,415.06L287.21,415.69L290.12,418.87L290.12,418.87L290,420.02L290,420.02L290.75,420.4L291.63,420.27L291.63,420.27L291.62,417.46L293.01,418.09L293.01,418.09L294.27,418.72L296.54,418.07L296.54,418.07L297.04,417.81L297.61,418L297.61,418L298.68,419.21L298.68,419.21L298.93,419.72L298.93,419.72L298.93,420.23L298.93,420.23L297.68,421L297.68,421L298.07,424.83L298.57,425.21L298.57,425.21L298.7,427.12L298.39,429.73L298.39,429.73L297.95,429.92L297.26,429.61L297.26,429.61L297.58,430.69L300.23,433.98L300.23,433.98L301.24,434.74L301.24,434.74L303.01,435.75L304.14,436L304.14,436L307.41,435.73L308.29,435.09L308.29,435.09L308.67,434.2L308.67,434.2L308.91,432.54L311.55,431.01L312.05,431.13L312.72,429.86L314.45,425.46L313.69,424.35L313.39,422.74L315.82,421.48L315.82,421.48L316.37,419.74L316.37,419.74L315.81,417.79L314.98,416.74L314.98,416.74L313.58,415.04L311.3,409.97L311.3,409.97L312.26,406.08L313.57,404.54L313.57,404.54L314.49,404.02L314.49,404.02L320.43,401.77L321.61,400.43L321.61,400.43L322.56,399.18L325.46,397.28L325.46,397.28L326.49,396.8L327.44,394.88L327.44,394.88L327.94,394.63L333.66,395.2L333.66,395.2L335.35,395.79L337.49,394.84L337.49,394.84L337.71,393.89L337.71,393.89L337.43,393.39z"
				},
				{
					"id":"IN-UT",
					"title":"Uttarakhand",
					"d":"M244.59,323.34L244.52,321.14L247.37,316.38L249.24,314.58L249.61,312.16L249.19,311.89L248.22,309.49L249.29,308.08L250.43,307.18L251.71,305.3L251.88,304.39L251.22,303.43L251.03,302.04L251.86,300.97L253.24,300.67L254.36,299.58L255.55,297.11L257.26,296.62L261.27,292.6L262.68,291.65L264.37,291.1L264.25,289.95L263.73,289.54L259.98,288.37L259.25,287.82L258.46,286.52L255.32,284.41L254.95,284.38L254.73,284.88L254.14,285.19L253.38,284.36L252.02,283.97L251.55,283.37L250.89,283.47L249.6,282.51L248.53,282.33L248.26,282.56L247.76,282.23L247.68,281.39L247.41,281.19L247.62,280.67L247.04,280.08L247.84,279.43L248.2,278.47L247.93,277.84L247.24,277.85L246.56,276.68L245.45,277.47L244.24,275.94L243.7,275.88L242.51,274.95L241.59,274.79L241.23,274.09L240.76,273.88L240.36,272.73L239.33,272.76L238.04,272.07L237.28,272.62L236.23,272.57L236.14,272.93L234.86,273.58L233.71,272.85L233.85,272.44L233.47,272.38L233.1,271.3L231.29,271.33L230.65,269.41L229.51,269.14L228.96,268.67L228.41,266.73L227.61,266.17L227.91,265.15L225.46,261.75L223.8,261L222.64,263.54L221.28,264.31L221.06,266.01L221.06,266.01L222.53,268.55L222.66,269.79L219.85,269.89L219.24,269.28L218.82,267.65L216.41,267.74L212.26,267.31L209.97,266.24L208.76,265.98L203.37,268.77L201.69,268.58L200.76,269.07L198.97,271.14L197.58,273.61L196.92,278.51L198.62,282.74L198.64,283.92L193.42,286.06L193.76,286.9L193.76,286.9L193.77,287.99L193.77,287.99L193.63,288.48L193.63,288.48L195.43,290.04L200,291.61L197.86,292.36L197.86,293.25L196.74,296.72L195.14,298.56L194.84,299.85L195.85,301.34L195.85,303.04L196.21,303.79L198.34,303.79L200.41,303.11L200.12,305.48L202.01,306.77L202.78,306.71L203.61,304.6L205.03,304.26L205.45,303.79L205.45,302.91L205.98,302.5L207.64,302.57L208.71,301.55L209.6,301.82L211.14,303.04L212.44,305.55L218.31,309.89L220.5,310.84L219.67,311.71L217.54,312.26L217.24,312.86L217.24,313.54L218.67,315.36L219.44,315.97L220.21,315.97L220.44,317.32L221.04,317.46L222.87,317.05L224.77,317.19L225.54,318.74L225.54,319.82L226.31,319.88L228.21,320.96L231.17,321.97L231.94,323.39L237.21,323.72L239.05,323.18L240.41,323.25L240.18,325.27L241.24,325L241.66,325.61L242.37,325.61L242.9,326.08L243.08,326.81L244.15,327.02L245.16,326.75L245.75,325.2L246.6,324.28z"
				},
				{
					"id":"IN-WB",
					"title":"West Bengal",
					"d":"M422.93,362.22l0.81,0.13l1.42,1.11l0.66,2.71l1.11,0.14l1.86,1.07l0.95,0.84l0.45,1.21l0.41,0.2l1.94,0.2l1.62,-0.83l1.38,-0.2l2.35,1.36l0.91,-0.27l1.28,0.44l1.11,0.68l-0.41,0.86l0.42,0.23l3.08,0.2l0,0l0.46,0.46l0.13,5.5l-0.48,2.59l-1.31,0.92l-1.76,2.31l0,0l-0.31,-0.93l-0.67,0.06l-0.81,1.7l0.83,1.9l-1.11,1.21l-0.9,0.23l-3.79,-0.44l-3.79,-2.93l-1.32,-5.27l-2.55,-1.31l-0.74,1.15l0.26,0.79l0.94,0.43l1.54,1.46l-0.48,0.9l-3.35,-0.11l-2.49,-1.21l-0.65,-0.91l-0.47,-1.98l-1.52,-1.15l-0.7,0.13l-2.92,-2.03l-0.35,-1.64l-0.78,1.04l-0.81,2.23l0.43,0.65l0.31,-0.71l2.26,0.58l0.85,2.12l-2.6,0.96L414.8,382l-0.17,1.42l-3.4,1.58l-1.79,5.34l0.31,1.81l0.69,1.13l0.4,0.13l1.86,-0.79l0.41,0.2l3.61,3.33l0.09,1.58l2.11,1.92l3.26,0.36l1.05,-0.66l0.68,0.16l0.83,1.12l-0.39,1.28l0.45,0.9l0.64,0.73l1.23,0.57l1.19,-0.03l0.35,0.41l-1.55,2.84l-4.68,-0.7l-4.55,-0.1l-0.59,0.25l0.15,2.57l-1.32,3.04l-1.2,1.6l-1.27,-0.43l-1.17,-1.42l-1.62,0.78l0.44,0.6l0.09,0.93l-2.52,3.67l1.41,3.67l0.36,0.34l4.83,2.12l2.91,2.1l2.97,0.54l0.34,-0.36l0.68,0.09l1.02,2.01l-1.05,1.52l0.01,1.48l1.1,0.93l-0.41,2.74l-2.73,1.33l-0.51,2.05l-0.22,2.67l0.39,0.95l3.52,3l0.6,-0.52l0,0.93l-1.52,3.11l0.3,1.42l1.59,0.45l0.47,-0.35l3.18,0.81l-2.22,2.53l-0.24,2.75l1.36,2.19l1.31,12.04l0.29,1.06l1.35,1.85l0.43,1.08l-0.59,0.62l-0.22,-0.31l-0.35,0.9l0.54,1.79l-0.11,1.66l-1.08,0.63l1.69,5.43l-0.08,0.68l-1.53,0.53l-1.82,-0.72l-1.4,0.11l-1.52,1.62l-0.87,0.1l-0.5,-0.26l-0.59,-2.72l0.27,-3.44l0.56,-2.65l0.85,-0.92l-0.27,-0.85l-0.81,-0.4l0.3,0.86l-0.89,1.98l-1,-0.18l-0.23,-0.45l0.7,-1.22l-0.43,-1.75l0.38,-1.11l0.47,-0.48l-0.06,-0.63l-0.75,0.8l-0.55,1.38l0.26,1.29l-0.6,1.13l0.14,1.13l-0.94,2.6l0.16,1.1l0.79,-0.2l0.49,0.55l-0.54,3.13l-0.6,1.09l-0.7,0.75l-0.83,0.12l-0.3,-0.73l0.59,-0.83l0.28,-1.4l0.13,-3.86l-0.65,-2.56l-0.59,1.31l0.04,4.71l-0.47,1.38l-0.98,0.61l-1.98,-0.59l-0.22,-3.64l-0.7,-0.45l0.89,5.04l-0.97,0.4l-1.15,-1.34l-0.42,-1.49l0.46,-0.76l0.07,-1.75l-1.07,-1.88l-0.22,-1.77l1.41,-2.11l0.13,-0.5l-0.4,-1.65l-0.6,-0.69l-3.33,-1.14l-0.81,-1.26l-0.68,-2.76l-0.59,-0.07l0.77,3.06l0.78,1.29l0.4,0.4l2.64,0.59l0.83,1.04l-0.09,0.91l-1.68,1.55l-2.43,4.08l-2.81,2.52l-3.09,1.61l-4.06,0.75l0,0l-0.64,-3.59l-0.66,-0.73l-1.05,0l-1.9,-0.72l-1.12,-1.32l0.17,-1.63l-1.61,-0.42l-1.18,1l-0.13,1.33l-1.05,0l-0.87,-1.13l0.48,-1.33l-0.13,-1.46l-1.18,-0.92l-2.37,-0.32l-2.6,-1.08l-0.29,-0.83l0,0l1.29,-0.94l1.68,-0.72l1.22,0.19l0.33,-0.82l0,0l-2.57,-5.82l0,0l-3.19,-2.55l0,0l-1.76,-0.93l-0.52,0.21l0,0l-1.68,-1.49l0,0l-0.07,-0.58l0.74,-2.21l1.57,-0.85l0.24,-0.6l-2.89,-0.38l-2.13,0.05l0,0l-1.69,0.17l-1.02,-0.62l0,0l-3.27,-3.07l-1.55,-0.05l0,0l-0.54,0.25l-0.95,-0.43l0,0l-0.92,-1.87l0.2,-1.04l2.06,-3.77l2.15,-2.39l1.89,-0.04l0.44,0.38l-0.15,1.88l3.05,1.61l1.36,-1.37l0,0l0.07,-1l0,0l0.41,-1.11l1.02,-1l2.85,-1.66l0,0l2.86,-0.6l0,0l0.69,0.35l0.15,0.5l1.59,-0.36l-0.17,-2.04l0,0l-0.1,-0.8l0,0l1.88,-1.56l1.49,0.57l0,0l0.4,0.17l0,0l2.47,1.2l2.51,-0.84l0.94,-1.74l-0.22,-1.28l0,0l-0.43,-0.75l0,0l-0.42,-0.27l-0.01,-0.65l0,0l1.39,0.01l0,0l2.92,1.28l0.32,-0.31l0,0l0.42,-0.71l0.01,-1.78l0,0l4.07,-1.23l0.03,-0.52l0,0l-0.72,-1.25l1.63,-1.43l0,0l0.83,-1.68l0,0l1.74,-4.18l0.51,-0.49l0,0l0.8,-1.54l-0.74,-3.95l0.02,-3.65l-0.32,-0.65l0,0l-0.38,-0.59l0,0l-1.5,-1.45l0.42,-1.9l0,-3.17l-0.37,-1.21l0.3,-0.91l2.05,-2.11l0.79,-0.32l0,0l1.91,0.59l0.34,-0.8l0,0l0.35,-2.96l-0.18,-0.44l-0.76,-0.74l-0.67,-0.2l-3.24,-3.28l-0.27,-0.64l0.27,-2.46l2.97,-3.11l6.23,-4.43l-0.43,-1.66l-1.27,-2.29l-0.8,-0.3l-1.1,0.36l1.45,-3.09l0.45,-2.16l-0.42,-2.66l-1.14,-2.46l-0.94,-1.07l-0.77,-0.42l-0.83,-1.44l0.32,-0.9l0,0l8.75,1.92l3.13,-2.38L422.93,362.22zM410.87,483.8l-0.68,2.32l-1.67,-0.34l0.04,-1.86l1.57,-3.39l0.34,0.21l0.38,1.18L410.87,483.8z"
				}
			]
		}
	}
};