<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Banner extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/banner_model', 'banner');
        $this->load->library('form_validation');
    }

    public function index($banner_type_id) {
        $data['banner_list'] = $this->banner->get_banner_list($banner_type_id);
        $data['breadcumb'] = 'Manage Banner';
        $data['banner_type_id'] = $banner_type_id;
        $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('backend_folder_name') . '/banner/banner_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add($banner_type_id) {
        if (!empty($_POST)) {
            if ($_FILES["bnr_image"]['name'] == '')
                $this->form_validation->set_rules('bnr_image', 'Banner Image', 'trim|required');
            $this->form_validation->set_rules('bnr_title', 'Banner Title', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["bnr_image"]['name']) {
                    @mkdir($this->config->item('uploads') . "banner_images/", 0777, true);
                    @chmod($this->config->item('uploads') . "banner_images/", 0777);
                    $temp = TRUE;
                    $config['upload_path'] = './assets/uploads/banner_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('bnr_image')) {
                        $error_msg = $this->upload->display_errors();
                        $temp = FALSE;
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                if ($temp) {
                    $this->banner->add($banner_type_id, $detail['upload_data']['file_name']);
                    $this->session->set_flashdata('BannerSuccess', 'Banner Has Been Added Successfully');
                    redirect($this->config->item('backend_url') . '/banner/' . $banner_type_id);
                    exit;
                } else {
                    $this->session->set_flashdata('BannerSuccess', $error_msg);
                }
            } else {
                $data['bnr_title'] = $this->input->post('bnr_title');
                $data['bnr_link'] = $this->input->post('bnr_link');
                $data['bnr_text'] = $this->input->post('bnr_text');
                $data['bnr_image'] = $this->input->post('bnr_image');
            }
        }

        $data['breadcumb'] = 'Add Banner';
        $data['banner_type_id'] = $banner_type_id;
        $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('backend_folder_name') . '/banner/banner_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($banner_type_id, $bannerId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('bnr_title', 'Banner Title', 'trim|required');
            if ($this->form_validation->run()) {
                $temp = TRUE;
                if ($_FILES["bnr_image"]['name']) {
                    @mkdir($this->config->item('uploads') . "banner_images/", 0777, true);
                    @chmod($this->config->item('uploads') . "banner_images/", 0777);
                    $config['upload_path'] ='./assets/uploads/banner_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('bnr_image')) {
                        $error_msg = $this->upload->display_errors();
                        $temp = FALSE;
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                if ($temp) {
                    $this->banner->update($bannerId, $detail['upload_data']['file_name']);
                    $this->session->set_flashdata('BannerSuccess', 'Banner Has Been Updated Successfully');
                    redirect($this->config->item('backend_url') . '/banner/' . $banner_type_id);
                    exit;
                } else {
                    $this->session->set_flashdata('BannerSuccess', $error_msg);
                }
            } else {
                $data['bnr_title'] = $this->input->post('bnr_title');
                $data['bnr_link'] = $this->input->post('bnr_link');
                $data['bnr_text'] = $this->input->post('bnr_text');
                $data['bnr_image'] = $this->input->post('bnr_image');
            }
        } else {
            $lists = $this->common_model->get_single_row_from_any_table('bnr_id', $bannerId, $this->banner->banner_table);
            $data['bnr_title'] = $lists->bnr_title;
            $data['bnr_link'] = $lists->bnr_link;
            $data['bnr_text'] = $lists->bnr_text;
            $data['bnr_image'] = $lists->bnr_image;
        }
        $data['breadcumb'] = 'Edit Banner';
        $data['banner_type_id'] = $banner_type_id;
        $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('backend_folder_name') . '/banner/banner_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($banner_type_id, $bannerId, $status) {
        if ($banner_type_id != '' && $bannerId != '' && $status != '') {
            $this->banner->update_status($bannerId, $status);
            $this->session->set_flashdata('BannerSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/banner/' . $banner_type_id);
            exit;
        }
    }

}