<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Blog_Comment extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/blog_comment_model', 'comment');
        $this->load->model($this->config->item('backend_folder_name') . '/blog_model', 'blog');
        $this->load->library('form_validation');
    }

    public function index($blogId) {
        $data['comment_list'] = $this->comment->blog_comment_list($blogId);
        $data['breadcum'] = "Manage Blog Comment";
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/blog/blog_comment_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function view($commentId) {
        $this->comment->update_read_status($commentId, 'read');
        $data['blogcmt_data'] = $this->common_model->get_single_row_from_any_table('blog_comment_id', $commentId, 'tbl_blog_comments');
        $data['breadcumb'] = 'View Blog Comment';
        $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
        $this->load->view($this->config->item('backend_folder_name') . '/blog/blog_comment_view');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($commentId, $blogId, $status) {
        if ($commentId != '') {
            $this->comment->update_status($commentId, $status);
            $this->session->set_flashdata('CommentSuccess', 'Status Of This Record Has Been Changed Successfully');
            redirect($this->config->item('backend_url') . '/blog/comment/' . $blogId);
            exit;
        }
    }

}
