<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Category extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/category_model', 'category');
        $this->load->library('form_validation');
    }

    public function index($cat_type_id) {
        $data['category_list'] = $this->category->get_category_list($cat_type_id);
        $data['breadcumb'] = 'Manage Category';
        $data['cat_type_id'] = $cat_type_id;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/category/category_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add($cat_type_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('cat_name', 'Category Title', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["cat_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/category_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('cat_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->category->add_category($cat_type_id, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('CategorySuccess', 'Category Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/category/' . $cat_type_id);
                exit;
            } else {              
                $data['cat_name'] = $this->input->post('cat_name');
                $data['cat_content'] = $this->input->post('cat_content');
                $data['cat_image'] = $this->input->post('cat_image');
                $data['cat_title'] = $this->input->post('cat_title');
                $data['cat_keywords'] = $this->input->post('cat_keywords');
                $data['cat_description'] = $this->input->post('cat_description');
            }
        }
        $data['breadcumb'] = 'Add Category';
        $data['cat_type_id'] = $cat_type_id;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/category/category_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($cat_type_id,$category_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('cat_name', 'Category Title', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["cat_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/category_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('cat_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->category->update_category($category_id, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('CategorySuccess', 'Category Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/category/'.$cat_type_id);
                exit;
            } else {           
                $data['cat_name'] = $this->input->post('cat_name');
                $data['cat_content'] = $this->input->post('cat_content');
                $data['cat_image'] = $this->input->post('cat_image');
                $data['cat_title'] = $this->input->post('cat_title');
                $data['cat_keywords'] = $this->input->post('cat_keywords');
                $data['cat_description'] = $this->input->post('cat_description');
            }
        } else {
            $value = $this->common_model->get_single_row_from_any_table('cat_id', $category_id, 'tbl_category');           
            $data['cat_name'] = $value->cat_name;
            $data['cat_content'] = $value->cat_content;
            $data['location_id'] = $value->cat_loc_fk;
            $data['cat_image'] = $value->cat_image;
            $data['cat_title'] = $value->cat_title;
            $data['cat_keywords'] = $value->cat_keywords;
            $data['cat_description'] = $value->cat_description;
        }
        $data['breadcumb'] = 'Edit Category';
        $data['cat_type_id'] = $cat_type_id;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/category/category_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($cat_type_id,$category_id, $status) {
        if ($cat_type_id!='' && $category_id != '' && $status != '') {
            $this->category->update_status($category_id, $status);
            $this->session->set_flashdata('CategorySuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/category/'.$cat_type_id);
            exit;
        }
    }

}
