<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Email_Templates extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/email_templates_model', 'email_templates');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['email_templates'] = $this->email_templates->get_templates_list();
        $data['page_heading'] = 'Manage Email Templates';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/email_templates/email_templates_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($template_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('content', 'Email Template Content', 'trim|required');
            if ($this->form_validation->run()) {
                $this->email_templates->update_email_template($template_id);
                $this->session->set_userdata('success_message', 'Email Template Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/email-template');
                exit;
            } else {
                $data['et_sender_name'] = $this->input->post('sender_name');
                $data['et_sender_email'] = $this->input->post('sender_email');
                $data['et_cc_emails'] = $this->input->post('cc_emails');
                $data['et_title'] = $this->input->post('title');
                $data['et_subject'] = $this->input->post('subject');
                $data['et_content'] = $this->input->post('content');
            }
        } else {
            $email_template_detail = $this->email_templates->get_template_detail($template_id);
            $data['et_sender_name'] = $email_template_detail['et_sender_name'];
            $data['et_sender_email'] = $email_template_detail['et_sender_email'];
            $data['et_cc_emails'] = $email_template_detail['et_cc_emails'];
            $data['et_subject'] = $email_template_detail['et_subject'];
            $data['et_content'] = $email_template_detail['et_content'];
        }
        $data['page_heading'] = 'Edit Email Template';
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/email_templates/email_template_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($template_id, $template_status) {
        if ($template_id != '' && $template_status != '') {
            $this->email_templates->update_status($template_id, $template_status);
            $this->session->set_userdata('success_message', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/email-template');
            exit;
        }
    }
}