<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Locations extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model($this->config->item('backend_folder_name') . '/location_model', 'location');
        $this->load->library('form_validation');
    }

    public function index($location_type_id) {
        $data['location_data'] = $this->location->get_location_list($location_type_id);
        $data['page_heading'] = 'Manage Location';
        $data['location_type_id'] = $location_type_id;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/location/location_list');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function add($location_type_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('loc_name', 'Location Title', 'trim|required');
            if ($this->form_validation->run()) {
                $this->location->add_location($location_type_id);
                $this->session->set_flashdata('LocationSuccess', 'Location Has Been Added Successfully');
                redirect($this->config->item('backend_url') . '/location/' . $location_type_id);
                exit;
            } else {
                $data['loc_parent_fk'] = $this->input->post('loc_parent_fk');
                $data['loc_name'] = $this->input->post('loc_name');
            }
        }
        $data['page_heading'] = 'Add Location';
        $data['location_type_id'] = $location_type_id;
        $data['parent_locations'] = $this->location->get_location_parent_list($location_type_id);
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/location/location_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function edit($location_type_id, $location_id) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('loc_name', 'Location Title', 'trim|required');
            if ($this->form_validation->run()) {
                $this->location->update_location($location_id);
                $this->session->set_flashdata('LocationSuccess', 'Location Has Been Updated Successfully');
                redirect($this->config->item('backend_url') . '/location/' . $location_type_id);
                exit;
            } else {
                $data['loc_parent_fk'] = $this->input->post('loc_parent_fk');
                $data['loc_name'] = $this->input->post('loc_name');
            }
        } else {
            $value = $this->common_model->get_single_row_from_any_table('loc_id', $location_id, 'tbl_locations');
            $data['loc_parent_fk'] = $value->loc_parent_fk;
            $data['loc_name'] = $value->loc_name;
        }
        $data['page_heading'] = 'Add Location';
        $data['location_type_id'] = $location_type_id;
        $data['parent_locations'] = $this->location->get_location_parent_list($location_type_id);
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/location/location_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function change_status($location_id, $status) {
        if ($location_id != '' && $status != '') {
            $this->location->update_status($location_id, $status);
            $this->session->set_flashdata('location_msg', 'Status Of This Record Has Been Updated Successfully');
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

    public function location_detail($location_type_id, $location_id) {
        $location_detail = $this->location->get_location_detail($location_id);
        $data['loc_content'] = $location_detail['loc_content'];
        $data['loc_iframe_code'] = $location_detail['loc_iframe_code'];
        $data['loc_email'] = $location_detail['loc_email'];
        $data['loc_phone'] = $location_detail['loc_phone'];
        $data['loc_hours'] = $location_detail['loc_hours'];
        $data['loc_min_order'] = $location_detail['loc_min_order'];
        $data['loc_del_charges'] = $location_detail['loc_del_charges'];
        $data['loc_del_line'] = $location_detail['loc_del_line'];
        $data['loc_min_order_line'] = $location_detail['loc_min_order_line'];
        $data['loc_address'] = $location_detail['loc_address'];
        $data['loc_gst'] = $location_detail['loc_gst'];
        $data['loc_pst'] = $location_detail['loc_pst'];
        $data['loc_hst'] = $location_detail['loc_hst'];
        if (!empty($_POST)) {
            $this->location->add_location_detail($location_id);
            $this->session->set_flashdata('location_msg', 'Location Has Been Added Successfully');
            redirect($this->config->item('backend_url') . '/location/' . $location_type_id);
            exit;
        }
        $data['page_heading'] = 'Add Location Detail';
        $data['location_type_id'] = $location_type_id;
        $this->load->view($this->config->item('backend_folder_name') . "/header", $data);
        $this->load->view($this->config->item('backend_folder_name') . '/location/location_detail_form');
        $this->load->view($this->config->item('backend_folder_name') . '/footer');
    }

    public function location_images($location_id) {
        if (!empty($_POST)) {
            if ($_FILES["loc_img_name"]['name']) {
                $config['upload_path'] = './assets/uploads/location_images';
                $config['allowed_types'] = 'jpg|png|jpeg|gif';
                $this->load->library('upload', $config);
                if (!$this->upload->do_upload('loc_img_name')) {
                    $error_msg = $this->upload->display_errors();
                } else {
                    $detail = array('upload_data' => $this->upload->data());
                }
            }
            $this->location->add_location_image($location_id, $detail['upload_data']['file_name']);
            $this->session->set_userdata('location_msg', 'location Images Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/location/images/' . $location_id);
            exit;
        } else {
            $data['page_heading'] = 'Manage Location Images';
            $data['location_id'] = $location_id;
            $data['location_images_list'] = $this->location->get_location_images($location_id);
            $this->load->view($this->config->item('backend_folder_name') . '/header', $data);
            $this->load->view($this->config->item('backend_folder_name') . '/location/location_images');
            $this->load->view($this->config->item('backend_folder_name') . '/footer');
        }
    }

    public function change_image_status($location_id, $location_imgage_id, $location_imgage_status) {
        if ($location_id != '' && $location_imgage_id != '' && $location_imgage_status != '') {
            $this->location->update_image_status($location_imgage_id, $location_imgage_status);
            $this->session->set_flashdata('location_msg', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('backend_url') . '/location/images/' . $location_id);
            exit;
        }
    }

    public function set_default_image($location_id, $location_imgage_id, $location_imgage_status) {
        if ($location_id != '' && $location_imgage_id != '' && $location_imgage_status != '') {
            if ($location_imgage_status == 'yes') {
                $this->location->unset_default_image($location_id);
                $this->location->set_default_image($location_imgage_id, $location_imgage_status);
                redirect($this->config->item('backend_url') . '/location/images/' . $location_id);
                exit;
            }
        }
    }

}
